/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.floatstream;

import com.github.wrdlbrnft.streamcompat.bytestream.ByteStream;
import com.github.wrdlbrnft.streamcompat.bytestream.ByteStreamCompat;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStream;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStreamCompat;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStream;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStreamCompat;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatExceptional;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatIteratorWrapper;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatIteratorWrapperImpl;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStream;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamCompat;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$1;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$10;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$11;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$12;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$13;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$14;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$15;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$16;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$17;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$18;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$19;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$2;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$20;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$21;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$22;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$23;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$24;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$25;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$26;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$27;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$28;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$29;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$3;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$30;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$31;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$32;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$33;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$34;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$35;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$36;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$37;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$38;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$39;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$4;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$40;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$41;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$42;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$43;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$44;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$5;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$6;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$7;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$8;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$9;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$FloatExceptionalImpl$$Lambda$1;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$FloatExceptionalImpl$$Lambda$2;
import com.github.wrdlbrnft.streamcompat.function.Consumer;
import com.github.wrdlbrnft.streamcompat.function.FloatBinaryOperator;
import com.github.wrdlbrnft.streamcompat.function.FloatConsumer;
import com.github.wrdlbrnft.streamcompat.function.FloatFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatPredicate;
import com.github.wrdlbrnft.streamcompat.function.FloatToByteFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatToCharFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatToDoubleFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatToIntFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatToLongFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatUnaryOperator;
import com.github.wrdlbrnft.streamcompat.function.Function;
import com.github.wrdlbrnft.streamcompat.function.ObjFloatConsumer;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.function.ToFloatFunction;
import com.github.wrdlbrnft.streamcompat.intstream.IntStream;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamCompat;
import com.github.wrdlbrnft.streamcompat.iterator.array.FloatArrayIterator;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.ByteChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.CharChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.ChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.DoubleChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.FloatChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.IntChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.child.LongChildIterator;
import com.github.wrdlbrnft.streamcompat.iterator.primtive.FloatIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongStream;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamCompat;
import com.github.wrdlbrnft.streamcompat.optionals.OptionalFloat;
import com.github.wrdlbrnft.streamcompat.stream.Stream;
import com.github.wrdlbrnft.streamcompat.stream.StreamCompat;
import com.github.wrdlbrnft.streamcompat.util.KahanSummation;
import com.github.wrdlbrnft.streamcompat.util.Utils;
import java.util.Arrays;

class FloatStreamImpl
implements FloatStream {
    private static final int DEFAULT_ARRAY_SIZE = 16;
    private final FloatIteratorWrapper mIteratorWrapper = new FloatIteratorWrapperImpl();
    private final FloatIterator mIterator;

    FloatStreamImpl(FloatIterator iterator) {
        this.mIterator = this.mIteratorWrapper.apply(iterator);
    }

    @Override
    public FloatStream filter(FloatPredicate predicate) {
        Utils.requireNonNull(predicate);
        DummyIterator iterator = new DummyIterator();
        return new FloatStreamImpl(new FloatChildIterator(FloatStreamImpl$$Lambda$1.lambdaFactory$(this, predicate, iterator), FloatStreamImpl$$Lambda$2.lambdaFactory$(), FloatStreamImpl$$Lambda$3.lambdaFactory$()));
    }

    @Override
    public FloatStream map(FloatUnaryOperator mapper) {
        Utils.requireNonNull(mapper);
        return new FloatStreamImpl(new FloatChildIterator(FloatStreamImpl$$Lambda$4.lambdaFactory$(this), FloatStreamImpl$$Lambda$5.lambdaFactory$(), FloatStreamImpl$$Lambda$6.lambdaFactory$(this, mapper)));
    }

    @Override
    public FloatStream flatMap(FloatFunction<? extends FloatStream> mapper) {
        Utils.requireNonNull(mapper);
        FloatIterator[] buffer = new FloatIterator[1];
        return new FloatStreamImpl(new FloatChildIterator(FloatStreamImpl$$Lambda$7.lambdaFactory$(this, buffer, mapper), FloatStreamImpl$$Lambda$8.lambdaFactory$(), FloatStreamImpl$$Lambda$9.lambdaFactory$()));
    }

    @Override
    public <U> Stream<U> mapToObj(FloatFunction<? extends U> mapper) {
        Utils.requireNonNull(mapper);
        return StreamCompat.of(new ChildIterator(FloatStreamImpl$$Lambda$10.lambdaFactory$(this), FloatStreamImpl$$Lambda$11.lambdaFactory$(), FloatStreamImpl$$Lambda$12.lambdaFactory$(this, mapper)));
    }

    @Override
    public LongStream mapToLong(FloatToLongFunction mapper) {
        Utils.requireNonNull(mapper);
        return LongStreamCompat.of(new LongChildIterator(FloatStreamImpl$$Lambda$13.lambdaFactory$(this), FloatStreamImpl$$Lambda$14.lambdaFactory$(), FloatStreamImpl$$Lambda$15.lambdaFactory$(this, mapper)));
    }

    @Override
    public IntStream mapToInt(FloatToIntFunction mapper) {
        Utils.requireNonNull(mapper);
        return IntStreamCompat.of(new IntChildIterator(FloatStreamImpl$$Lambda$16.lambdaFactory$(this), FloatStreamImpl$$Lambda$17.lambdaFactory$(), FloatStreamImpl$$Lambda$18.lambdaFactory$(this, mapper)));
    }

    @Override
    public CharacterStream mapToChar(FloatToCharFunction mapper) {
        Utils.requireNonNull(mapper);
        return CharacterStreamCompat.of(new CharChildIterator(FloatStreamImpl$$Lambda$19.lambdaFactory$(this), FloatStreamImpl$$Lambda$20.lambdaFactory$(), FloatStreamImpl$$Lambda$21.lambdaFactory$(this, mapper)));
    }

    @Override
    public DoubleStream mapToDouble(FloatToDoubleFunction mapper) {
        Utils.requireNonNull(mapper);
        return DoubleStreamCompat.of(new DoubleChildIterator(FloatStreamImpl$$Lambda$22.lambdaFactory$(this), FloatStreamImpl$$Lambda$23.lambdaFactory$(), FloatStreamImpl$$Lambda$24.lambdaFactory$(this, mapper)));
    }

    @Override
    public ByteStream mapToByte(FloatToByteFunction mapper) {
        Utils.requireNonNull(mapper);
        return ByteStreamCompat.of(new ByteChildIterator(FloatStreamImpl$$Lambda$25.lambdaFactory$(this), FloatStreamImpl$$Lambda$26.lambdaFactory$(), FloatStreamImpl$$Lambda$27.lambdaFactory$(this, mapper)));
    }

    @Override
    public FloatIterator iterator() {
        return this.mIterator;
    }

    @Override
    public void forEach(FloatConsumer action) {
        Utils.requireNonNull(action);
        while (this.mIterator.hasNext()) {
            float value = this.mIterator.nextFloat();
            action.accept(value);
        }
    }

    @Override
    public Stream<Float> boxed() {
        return this.mapToObj(FloatStreamImpl$$Lambda$28.lambdaFactory$());
    }

    @Override
    public FloatStream limit(long limit) {
        long[] buffer = new long[]{0L, limit};
        return new FloatStreamImpl(new FloatChildIterator(FloatStreamImpl$$Lambda$29.lambdaFactory$(this), FloatStreamImpl$$Lambda$30.lambdaFactory$(this, buffer), FloatStreamImpl$$Lambda$31.lambdaFactory$(this, buffer)));
    }

    @Override
    public FloatStream skip(long count) {
        long[] buffer = new long[]{0L, count};
        return new FloatStreamImpl(new FloatChildIterator(FloatStreamImpl$$Lambda$32.lambdaFactory$(this, buffer), FloatStreamImpl$$Lambda$33.lambdaFactory$(), FloatStreamImpl$$Lambda$34.lambdaFactory$()));
    }

    @Override
    public float reduce(float identity, FloatBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        float current = identity;
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsFloat(current, this.mIterator.nextFloat());
        }
        return current;
    }

    @Override
    public OptionalFloat reduce(FloatBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        if (!this.mIterator.hasNext()) {
            return OptionalFloat.empty();
        }
        float current = this.mIterator.nextFloat();
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsFloat(current, this.mIterator.nextFloat());
        }
        return OptionalFloat.of(current);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjFloatConsumer<R> accumulator) {
        Utils.requireNonNull(supplier);
        Utils.requireNonNull(accumulator);
        R sink = supplier.get();
        while (this.mIterator.hasNext()) {
            accumulator.accept(sink, this.mIterator.nextFloat());
        }
        return sink;
    }

    @Override
    public <E extends Throwable> FloatExceptional<E> exception(Class<E> cls) {
        return new FloatExceptionalImpl<E>(cls);
    }

    @Override
    public float sum() {
        float[] summation = (float[])this.collect(FloatStreamImpl$$Lambda$35.lambdaFactory$(), FloatStreamImpl$$Lambda$36.lambdaFactory$());
        return KahanSummation.computeFinalSum(summation);
    }

    @Override
    public OptionalFloat min() {
        return this.reduce(FloatStreamImpl$$Lambda$37.lambdaFactory$());
    }

    @Override
    public OptionalFloat max() {
        return this.reduce(FloatStreamImpl$$Lambda$38.lambdaFactory$());
    }

    @Override
    public long count() {
        return this.mapToLong(FloatStreamImpl$$Lambda$39.lambdaFactory$()).sum();
    }

    @Override
    public FloatStream sort() {
        return new FloatStreamImpl(new FloatChildIterator(FloatStreamImpl$$Lambda$40.lambdaFactory$(this), FloatStreamImpl$$Lambda$41.lambdaFactory$(), FloatStreamImpl$$Lambda$42.lambdaFactory$()));
    }

    @Override
    public OptionalFloat average() {
        float[] avg = (float[])this.collect(FloatStreamImpl$$Lambda$43.lambdaFactory$(), FloatStreamImpl$$Lambda$44.lambdaFactory$());
        return avg[2] > 0.0f ? OptionalFloat.of(KahanSummation.computeFinalSum(avg) / avg[2]) : OptionalFloat.empty();
    }

    @Override
    public OptionalFloat findFirst() {
        return this.mIterator.hasNext() ? OptionalFloat.of(this.mIterator.nextFloat()) : OptionalFloat.empty();
    }

    @Override
    public boolean anyMatch(FloatPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextFloat())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allMatch(FloatPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (predicate.test(this.mIterator.nextFloat())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneMatch(FloatPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextFloat())) continue;
            return false;
        }
        return true;
    }

    @Override
    public float[] toArray() {
        float[] tmp = new float[16];
        int index = 0;
        while (this.mIterator.hasNext()) {
            float c = this.mIterator.nextFloat();
            if (index >= tmp.length) {
                float[] newArray = new float[tmp.length * 2];
                System.arraycopy(tmp, 0, newArray, 0, tmp.length);
                tmp = newArray;
            }
            tmp[index++] = c;
        }
        float[] result = new float[index];
        System.arraycopy(tmp, 0, result, 0, index);
        return result;
    }

    private static /* synthetic */ void lambda$average$115(float[] ll, float d) {
        ll[2] = ll[2] + 1.0f;
        KahanSummation.sumWithCompensation(ll, d);
        ll[3] = ll[3] + d;
    }

    private static /* synthetic */ float[] lambda$average$114() {
        return new float[4];
    }

    private /* synthetic */ FloatArrayIterator lambda$sort$113() {
        float[] array = this.toArray();
        Arrays.sort(array);
        return new FloatArrayIterator(array);
    }

    private static /* synthetic */ long lambda$count$112(float i) {
        return 1L;
    }

    private static /* synthetic */ void lambda$sum$111(float[] ll, float d) {
        KahanSummation.sumWithCompensation(ll, d);
        ll[2] = ll[2] + d;
    }

    private static /* synthetic */ float[] lambda$sum$110() {
        return new float[3];
    }

    private /* synthetic */ FloatIterator lambda$skip$109(long[] lArray) {
        while (this.mIterator.hasNext() && lArray[0] < lArray[1]) {
            this.mIterator.nextFloat();
            lArray[0] = lArray[0] + 1L;
        }
        return this.mIterator;
    }

    private /* synthetic */ float lambda$limit$108(long[] lArray, FloatIterator iterator) {
        lArray[0] = lArray[0] + 1L;
        return this.mIterator.nextFloat();
    }

    private /* synthetic */ boolean lambda$limit$107(long[] lArray, FloatIterator iterator) {
        return lArray[0] < lArray[1] && this.mIterator.hasNext();
    }

    private /* synthetic */ FloatIterator lambda$limit$106() {
        return this.mIterator;
    }

    private /* synthetic */ byte lambda$mapToByte$105(FloatToByteFunction floatToByteFunction, FloatIterator iterator) {
        return floatToByteFunction.applyAsByte(this.mIterator.nextFloat());
    }

    private /* synthetic */ FloatIterator lambda$mapToByte$104() {
        return this.mIterator;
    }

    private /* synthetic */ double lambda$mapToDouble$103(FloatToDoubleFunction floatToDoubleFunction, FloatIterator iterator) {
        return floatToDoubleFunction.applyAsDouble(this.mIterator.nextFloat());
    }

    private /* synthetic */ FloatIterator lambda$mapToDouble$102() {
        return this.mIterator;
    }

    private /* synthetic */ char lambda$mapToChar$101(FloatToCharFunction floatToCharFunction, FloatIterator iterator) {
        return floatToCharFunction.applyAsChar(this.mIterator.nextFloat());
    }

    private /* synthetic */ FloatIterator lambda$mapToChar$100() {
        return this.mIterator;
    }

    private /* synthetic */ int lambda$mapToInt$99(FloatToIntFunction floatToIntFunction, FloatIterator iterator) {
        return floatToIntFunction.applyAsInt(this.mIterator.nextFloat());
    }

    private /* synthetic */ FloatIterator lambda$mapToInt$98() {
        return this.mIterator;
    }

    private /* synthetic */ long lambda$mapToLong$97(FloatToLongFunction floatToLongFunction, FloatIterator iterator) {
        return floatToLongFunction.applyAsLong(this.mIterator.nextFloat());
    }

    private /* synthetic */ FloatIterator lambda$mapToLong$96() {
        return this.mIterator;
    }

    private /* synthetic */ Object lambda$mapToObj$95(FloatFunction floatFunction, FloatIterator iterator) {
        return floatFunction.apply(this.mIterator.nextFloat());
    }

    private /* synthetic */ FloatIterator lambda$mapToObj$94() {
        return this.mIterator;
    }

    private /* synthetic */ FloatIterator lambda$flatMap$93(FloatIterator[] floatIteratorArray, FloatFunction floatFunction) {
        if (floatIteratorArray[0] == null || !floatIteratorArray[0].hasNext()) {
            if (!this.mIterator.hasNext()) {
                return FloatStreamCompat.EMPTY_ITERATOR;
            }
            floatIteratorArray[0] = ((FloatStream)floatFunction.apply(this.mIterator.nextFloat())).iterator();
        }
        return floatIteratorArray[0];
    }

    private /* synthetic */ float lambda$map$92(FloatUnaryOperator floatUnaryOperator, FloatIterator iterator) {
        return floatUnaryOperator.applyAsFloat(this.mIterator.nextFloat());
    }

    private /* synthetic */ FloatIterator lambda$map$91() {
        return this.mIterator;
    }

    private /* synthetic */ DummyIterator lambda$filter$90(FloatPredicate floatPredicate, DummyIterator dummyIterator) {
        while (this.mIterator.hasNext()) {
            float value = this.mIterator.nextFloat();
            if (!floatPredicate.test(value)) continue;
            return dummyIterator.newValue(value);
        }
        return dummyIterator;
    }

    static /* synthetic */ DummyIterator access$lambda$0(FloatStreamImpl floatStreamImpl, FloatPredicate floatPredicate, DummyIterator dummyIterator) {
        return floatStreamImpl.lambda$filter$90(floatPredicate, dummyIterator);
    }

    static /* synthetic */ FloatIterator access$lambda$1(FloatStreamImpl floatStreamImpl) {
        return floatStreamImpl.lambda$map$91();
    }

    static /* synthetic */ float access$lambda$2(FloatStreamImpl floatStreamImpl, FloatUnaryOperator floatUnaryOperator, FloatIterator floatIterator) {
        return floatStreamImpl.lambda$map$92(floatUnaryOperator, floatIterator);
    }

    static /* synthetic */ FloatIterator access$lambda$3(FloatStreamImpl floatStreamImpl, FloatIterator[] floatIteratorArray, FloatFunction floatFunction) {
        return floatStreamImpl.lambda$flatMap$93(floatIteratorArray, floatFunction);
    }

    static /* synthetic */ FloatIterator access$lambda$4(FloatStreamImpl floatStreamImpl) {
        return floatStreamImpl.lambda$mapToObj$94();
    }

    static /* synthetic */ Object access$lambda$5(FloatStreamImpl floatStreamImpl, FloatFunction floatFunction, FloatIterator floatIterator) {
        return floatStreamImpl.lambda$mapToObj$95(floatFunction, floatIterator);
    }

    static /* synthetic */ FloatIterator access$lambda$6(FloatStreamImpl floatStreamImpl) {
        return floatStreamImpl.lambda$mapToLong$96();
    }

    static /* synthetic */ long access$lambda$7(FloatStreamImpl floatStreamImpl, FloatToLongFunction floatToLongFunction, FloatIterator floatIterator) {
        return floatStreamImpl.lambda$mapToLong$97(floatToLongFunction, floatIterator);
    }

    static /* synthetic */ FloatIterator access$lambda$8(FloatStreamImpl floatStreamImpl) {
        return floatStreamImpl.lambda$mapToInt$98();
    }

    static /* synthetic */ int access$lambda$9(FloatStreamImpl floatStreamImpl, FloatToIntFunction floatToIntFunction, FloatIterator floatIterator) {
        return floatStreamImpl.lambda$mapToInt$99(floatToIntFunction, floatIterator);
    }

    static /* synthetic */ FloatIterator access$lambda$10(FloatStreamImpl floatStreamImpl) {
        return floatStreamImpl.lambda$mapToChar$100();
    }

    static /* synthetic */ char access$lambda$11(FloatStreamImpl floatStreamImpl, FloatToCharFunction floatToCharFunction, FloatIterator floatIterator) {
        return floatStreamImpl.lambda$mapToChar$101(floatToCharFunction, floatIterator);
    }

    static /* synthetic */ FloatIterator access$lambda$12(FloatStreamImpl floatStreamImpl) {
        return floatStreamImpl.lambda$mapToDouble$102();
    }

    static /* synthetic */ double access$lambda$13(FloatStreamImpl floatStreamImpl, FloatToDoubleFunction floatToDoubleFunction, FloatIterator floatIterator) {
        return floatStreamImpl.lambda$mapToDouble$103(floatToDoubleFunction, floatIterator);
    }

    static /* synthetic */ FloatIterator access$lambda$14(FloatStreamImpl floatStreamImpl) {
        return floatStreamImpl.lambda$mapToByte$104();
    }

    static /* synthetic */ byte access$lambda$15(FloatStreamImpl floatStreamImpl, FloatToByteFunction floatToByteFunction, FloatIterator floatIterator) {
        return floatStreamImpl.lambda$mapToByte$105(floatToByteFunction, floatIterator);
    }

    static /* synthetic */ FloatIterator access$lambda$16(FloatStreamImpl floatStreamImpl) {
        return floatStreamImpl.lambda$limit$106();
    }

    static /* synthetic */ boolean access$lambda$17(FloatStreamImpl floatStreamImpl, long[] lArray, FloatIterator floatIterator) {
        return floatStreamImpl.lambda$limit$107(lArray, floatIterator);
    }

    static /* synthetic */ float access$lambda$18(FloatStreamImpl floatStreamImpl, long[] lArray, FloatIterator floatIterator) {
        return floatStreamImpl.lambda$limit$108(lArray, floatIterator);
    }

    static /* synthetic */ FloatIterator access$lambda$19(FloatStreamImpl floatStreamImpl, long[] lArray) {
        return floatStreamImpl.lambda$skip$109(lArray);
    }

    static /* synthetic */ float[] access$lambda$20() {
        return FloatStreamImpl.lambda$sum$110();
    }

    static /* synthetic */ void access$lambda$21(float[] fArray, float f) {
        FloatStreamImpl.lambda$sum$111(fArray, f);
    }

    static /* synthetic */ long access$lambda$22(float f) {
        return FloatStreamImpl.lambda$count$112(f);
    }

    static /* synthetic */ FloatArrayIterator access$lambda$23(FloatStreamImpl floatStreamImpl) {
        return floatStreamImpl.lambda$sort$113();
    }

    static /* synthetic */ float[] access$lambda$24() {
        return FloatStreamImpl.lambda$average$114();
    }

    static /* synthetic */ void access$lambda$25(float[] fArray, float f) {
        FloatStreamImpl.lambda$average$115(fArray, f);
    }

    private class FloatExceptionalImpl<E extends Throwable>
    implements FloatExceptional<E> {
        private final Class<E> mExceptionClass;

        public FloatExceptionalImpl(Class<E> exceptionClass) {
            this.mExceptionClass = exceptionClass;
        }

        @Override
        public FloatStream mapException(ToFloatFunction<E> mapper) {
            FloatStreamImpl.this.mIteratorWrapper.mapException(this.mExceptionClass, mapper);
            return FloatStreamImpl.this;
        }

        @Override
        public FloatStream consume(Consumer<E> consumer) {
            FloatStreamImpl.this.mIteratorWrapper.consumeException(this.mExceptionClass, consumer);
            return FloatStreamImpl.this;
        }

        @Override
        public <I extends RuntimeException> FloatStream rethrow(Function<E, I> mapper) {
            FloatStreamImpl.this.mIteratorWrapper.consumeException(this.mExceptionClass, FloatStreamImpl$FloatExceptionalImpl$$Lambda$1.lambdaFactory$(mapper));
            return FloatStreamImpl.this;
        }

        @Override
        public FloatStream ignore() {
            FloatStreamImpl.this.mIteratorWrapper.consumeException(this.mExceptionClass, FloatStreamImpl$FloatExceptionalImpl$$Lambda$2.lambdaFactory$());
            return FloatStreamImpl.this;
        }

        private static /* synthetic */ void lambda$ignore$117(Throwable e) {
        }

        private static /* synthetic */ void lambda$rethrow$116(Function function, Throwable e) {
            throw (RuntimeException)function.apply(e);
        }

        static /* synthetic */ void access$lambda$0(Function function, Throwable throwable) {
            FloatExceptionalImpl.lambda$rethrow$116(function, throwable);
        }

        static /* synthetic */ void access$lambda$1(Throwable throwable) {
            FloatExceptionalImpl.lambda$ignore$117(throwable);
        }
    }

    private static class DummyIterator
    extends BaseIterator<Float>
    implements FloatIterator {
        private float mValue;
        private boolean mHasNext;

        public DummyIterator(float value) {
            this(value, true);
        }

        public DummyIterator() {
            this(0.0f, false);
        }

        private DummyIterator(float value, boolean hasNext) {
            this.mValue = value;
            this.mHasNext = hasNext;
        }

        public DummyIterator newValue(float value) {
            this.mValue = value;
            this.mHasNext = true;
            return this;
        }

        @Override
        public float nextFloat() {
            this.mHasNext = false;
            return this.mValue;
        }

        @Override
        public boolean hasNext() {
            return this.mHasNext;
        }

        @Override
        public Float next() {
            return Float.valueOf(this.nextFloat());
        }
    }
}

