/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.characterstream;

import com.github.wrdlbrnft.streamcompat.characterstream.CharacterIteratorWrapper;
import com.github.wrdlbrnft.streamcompat.exceptions.StreamException;
import com.github.wrdlbrnft.streamcompat.function.Consumer;
import com.github.wrdlbrnft.streamcompat.function.ToCharFunction;
import com.github.wrdlbrnft.streamcompat.iterator.primtive.CharIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

class CharacterIteratorWrapperImpl
implements CharacterIteratorWrapper {
    private Wrapper mWrapper;

    CharacterIteratorWrapperImpl() {
    }

    @Override
    public CharIterator apply(CharIterator iterator) {
        WrapperImpl wrapper = new WrapperImpl(iterator);
        this.mWrapper = wrapper;
        return wrapper;
    }

    @Override
    public <E extends Throwable> void consumeException(Class<E> exceptionClass, Consumer<E> consumer) {
        this.mWrapper.consumeException(exceptionClass, consumer);
    }

    @Override
    public <E extends Throwable> void mapException(Class<E> exceptionClass, ToCharFunction<E> mapper) {
        this.mWrapper.mapException(exceptionClass, mapper);
    }

    private static class ResultImpl
    implements ExceptionHandler.Result {
        private final boolean mDoesHandle;
        private final boolean mHasMappedValue;
        private final char mMappedValue;

        private ResultImpl(boolean doesHandle, boolean hasMappedValue, char mappedValue) {
            this.mDoesHandle = doesHandle;
            this.mHasMappedValue = hasMappedValue;
            this.mMappedValue = mappedValue;
        }

        @Override
        public boolean doesHandle() {
            return this.mDoesHandle;
        }

        @Override
        public boolean hasMappedValue() {
            return this.mHasMappedValue;
        }

        @Override
        public char getMappedValue() {
            return this.mMappedValue;
        }
    }

    private static class WrapperImpl
    implements CharIterator,
    Wrapper {
        private final List<ExceptionHandler<?>> mExceptionHandlers = new ArrayList();
        private final CharIterator mIterator;
        private boolean mEvaluated = false;
        private boolean mHasNext = false;
        private char mNext;

        private WrapperImpl(CharIterator iterator) {
            this.mIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            if (!this.doesHandleExceptions()) {
                return this.mIterator.hasNext();
            }
            this.evaluate();
            return this.mHasNext;
        }

        @Override
        public Character next() {
            return Character.valueOf(this.nextChar());
        }

        boolean doesHandleExceptions() {
            return !this.mExceptionHandlers.isEmpty();
        }

        @Override
        public char nextChar() {
            if (!this.doesHandleExceptions()) {
                return this.mIterator.nextChar();
            }
            this.evaluate();
            this.mEvaluated = false;
            if (this.mHasNext) {
                return this.mNext;
            }
            throw new NoSuchElementException();
        }

        private void evaluate() {
            if (this.mEvaluated) {
                return;
            }
            this.mEvaluated = true;
            while (this.mIterator.hasNext()) {
                try {
                    this.mNext = ((Character)this.mIterator.next()).charValue();
                    this.mHasNext = true;
                    return;
                }
                catch (Exception e) {
                    for (ExceptionHandler<?> handler : this.mExceptionHandlers) {
                        ExceptionHandler.Result result = handler.handle(e);
                        if (result.doesHandle()) {
                            if (!result.hasMappedValue()) continue;
                            this.mNext = result.getMappedValue();
                            this.mHasNext = true;
                            return;
                        }
                        throw new StreamException("Failed to evaluate item.", e);
                    }
                }
            }
            this.mHasNext = false;
        }

        @Override
        public <E extends Throwable> void consumeException(Class<E> exceptionClass, Consumer<E> consumer) {
            this.mExceptionHandlers.add(new ConsumeExceptionHandler(exceptionClass, consumer));
        }

        @Override
        public <E extends Throwable> void mapException(Class<E> exceptionClass, ToCharFunction<E> mapper) {
            this.mExceptionHandlers.add(new MappingExceptionHandler(exceptionClass, mapper));
        }
    }

    private static class MappingExceptionHandler<E extends Throwable>
    extends ExceptionHandler<E> {
        private final ToCharFunction<E> mMapper;

        private MappingExceptionHandler(Class<E> exceptionClass, ToCharFunction<E> mapper) {
            super(exceptionClass);
            this.mMapper = mapper;
        }

        @Override
        protected ExceptionHandler.Result performHandle(E exception) {
            return new ResultImpl(true, true, this.mMapper.apply(exception));
        }
    }

    private static class ConsumeExceptionHandler<E extends Throwable>
    extends ExceptionHandler<E> {
        private final Consumer<E> mConsumer;

        private ConsumeExceptionHandler(Class<E> exceptionClass, Consumer<E> consumer) {
            super(exceptionClass);
            this.mConsumer = consumer;
        }

        @Override
        protected ExceptionHandler.Result performHandle(E exception) {
            this.mConsumer.accept(exception);
            return new ResultImpl(true, false, '\u0000');
        }
    }

    private static abstract class ExceptionHandler<E extends Throwable> {
        private final Class<E> mExceptionClass;

        private ExceptionHandler(Class<E> exceptionClass) {
            this.mExceptionClass = exceptionClass;
        }

        Result handle(Throwable exception) {
            if (!this.mExceptionClass.isAssignableFrom(exception.getClass())) {
                return new ResultImpl(false, false, '\u0000');
            }
            return this.performHandle(exception);
        }

        protected abstract Result performHandle(E var1);

        static interface Result {
            public boolean doesHandle();

            public boolean hasMappedValue();

            public char getMappedValue();
        }
    }

    private static interface Wrapper {
        public <E extends Throwable> void consumeException(Class<E> var1, Consumer<E> var2);

        public <E extends Throwable> void mapException(Class<E> var1, ToCharFunction<E> var2);
    }
}

