/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.floatstream;

import com.github.wrdlbrnft.streamcompat.exceptions.StreamException;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatIteratorWrapper;
import com.github.wrdlbrnft.streamcompat.function.Consumer;
import com.github.wrdlbrnft.streamcompat.function.ToFloatFunction;
import com.github.wrdlbrnft.streamcompat.iterator.primtive.FloatIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

class FloatIteratorWrapperImpl
implements FloatIteratorWrapper {
    private Wrapper mWrapper;

    FloatIteratorWrapperImpl() {
    }

    @Override
    public FloatIterator apply(FloatIterator iterator) {
        WrapperImpl wrapper = new WrapperImpl(iterator);
        this.mWrapper = wrapper;
        return wrapper;
    }

    @Override
    public <E extends Throwable> void consumeException(Class<E> exceptionClass, Consumer<E> consumer) {
        this.mWrapper.consumeException(exceptionClass, consumer);
    }

    @Override
    public <E extends Throwable> void mapException(Class<E> exceptionClass, ToFloatFunction<E> mapper) {
        this.mWrapper.mapException(exceptionClass, mapper);
    }

    private static class ResultImpl
    implements ExceptionHandler.Result {
        private final boolean mDoesHandle;
        private final boolean mHasMappedValue;
        private final float mMappedValue;

        private ResultImpl(boolean doesHandle, boolean hasMappedValue, float mappedValue) {
            this.mDoesHandle = doesHandle;
            this.mHasMappedValue = hasMappedValue;
            this.mMappedValue = mappedValue;
        }

        @Override
        public boolean doesHandle() {
            return this.mDoesHandle;
        }

        @Override
        public boolean hasMappedValue() {
            return this.mHasMappedValue;
        }

        @Override
        public float getMappedValue() {
            return this.mMappedValue;
        }
    }

    private static class WrapperImpl
    implements FloatIterator,
    Wrapper {
        private final List<ExceptionHandler<?>> mExceptionHandlers = new ArrayList();
        private final FloatIterator mIterator;
        private boolean mEvaluated = false;
        private boolean mHasNext = false;
        private float mNext;

        private WrapperImpl(FloatIterator iterator) {
            this.mIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            if (!this.doesHandleExceptions()) {
                return this.mIterator.hasNext();
            }
            this.evaluate();
            return this.mHasNext;
        }

        @Override
        public Float next() {
            return Float.valueOf(this.nextFloat());
        }

        boolean doesHandleExceptions() {
            return !this.mExceptionHandlers.isEmpty();
        }

        @Override
        public float nextFloat() {
            if (!this.doesHandleExceptions()) {
                return this.mIterator.nextFloat();
            }
            this.evaluate();
            this.mEvaluated = false;
            if (this.mHasNext) {
                return this.mNext;
            }
            throw new NoSuchElementException();
        }

        private void evaluate() {
            if (this.mEvaluated) {
                return;
            }
            this.mEvaluated = true;
            while (this.mIterator.hasNext()) {
                try {
                    this.mNext = ((Float)this.mIterator.next()).floatValue();
                    this.mHasNext = true;
                    return;
                }
                catch (Exception e) {
                    for (ExceptionHandler<?> handler : this.mExceptionHandlers) {
                        ExceptionHandler.Result result = handler.handle(e);
                        if (result.doesHandle()) {
                            if (!result.hasMappedValue()) continue;
                            this.mNext = result.getMappedValue();
                            this.mHasNext = true;
                            return;
                        }
                        throw new StreamException("Failed to evaluate item.", e);
                    }
                }
            }
            this.mHasNext = false;
        }

        @Override
        public <E extends Throwable> void consumeException(Class<E> exceptionClass, Consumer<E> consumer) {
            this.mExceptionHandlers.add(new ConsumeExceptionHandler(exceptionClass, consumer));
        }

        @Override
        public <E extends Throwable> void mapException(Class<E> exceptionClass, ToFloatFunction<E> mapper) {
            this.mExceptionHandlers.add(new MappingExceptionHandler(exceptionClass, mapper));
        }
    }

    private static class MappingExceptionHandler<E extends Throwable>
    extends ExceptionHandler<E> {
        private final ToFloatFunction<E> mMapper;

        private MappingExceptionHandler(Class<E> exceptionClass, ToFloatFunction<E> mapper) {
            super(exceptionClass);
            this.mMapper = mapper;
        }

        @Override
        protected ExceptionHandler.Result performHandle(E exception) {
            return new ResultImpl(true, true, this.mMapper.apply(exception));
        }
    }

    private static class ConsumeExceptionHandler<E extends Throwable>
    extends ExceptionHandler<E> {
        private final Consumer<E> mConsumer;

        private ConsumeExceptionHandler(Class<E> exceptionClass, Consumer<E> consumer) {
            super(exceptionClass);
            this.mConsumer = consumer;
        }

        @Override
        protected ExceptionHandler.Result performHandle(E exception) {
            this.mConsumer.accept(exception);
            return new ResultImpl(true, false, 0.0f);
        }
    }

    private static abstract class ExceptionHandler<E extends Throwable> {
        private final Class<E> mExceptionClass;

        private ExceptionHandler(Class<E> exceptionClass) {
            this.mExceptionClass = exceptionClass;
        }

        Result handle(Throwable exception) {
            if (!this.mExceptionClass.isAssignableFrom(exception.getClass())) {
                return new ResultImpl(false, false, 0.0f);
            }
            return this.performHandle(exception);
        }

        protected abstract Result performHandle(E var1);

        static interface Result {
            public boolean doesHandle();

            public boolean hasMappedValue();

            public float getMappedValue();
        }
    }

    private static interface Wrapper {
        public <E extends Throwable> void consumeException(Class<E> var1, Consumer<E> var2);

        public <E extends Throwable> void mapException(Class<E> var1, ToFloatFunction<E> var2);
    }
}

