/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.stream;

import com.github.wrdlbrnft.streamcompat.exceptions.StreamException;
import com.github.wrdlbrnft.streamcompat.function.Consumer;
import com.github.wrdlbrnft.streamcompat.function.Function;
import com.github.wrdlbrnft.streamcompat.stream.IteratorWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class BaseIteratorWrapperImpl<T>
implements IteratorWrapper<T> {
    private Wrapper<T> mWrapper;

    BaseIteratorWrapperImpl() {
    }

    @Override
    public Iterator<T> apply(Iterator<T> iterator) {
        WrapperImpl wrapper = new WrapperImpl(iterator);
        this.mWrapper = wrapper;
        return wrapper;
    }

    @Override
    public <E extends Throwable> void consumeException(Class<E> exceptionClass, Consumer<E> consumer) {
        this.mWrapper.consumeException(exceptionClass, consumer);
    }

    @Override
    public <E extends Throwable> void mapException(Class<E> exceptionClass, Function<E, T> mapper) {
        this.mWrapper.mapException(exceptionClass, mapper);
    }

    private static class ResultImpl<T>
    implements ExceptionHandler.Result<T> {
        private final boolean mDoesHandle;
        private final boolean mHasMappedValue;
        private final T mMappedValue;

        private ResultImpl(boolean doesHandle, boolean hasMappedValue, T mappedValue) {
            this.mDoesHandle = doesHandle;
            this.mHasMappedValue = hasMappedValue;
            this.mMappedValue = mappedValue;
        }

        @Override
        public boolean doesHandle() {
            return this.mDoesHandle;
        }

        @Override
        public boolean hasMappedValue() {
            return this.mHasMappedValue;
        }

        @Override
        public T getMappedValue() {
            return this.mMappedValue;
        }
    }

    private static class WrapperImpl<T>
    implements Iterator<T>,
    Wrapper<T> {
        private final List<ExceptionHandler<T, ?>> mExceptionHandlers = new ArrayList();
        private final Iterator<T> mIterator;
        private boolean mEvaluated = false;
        private boolean mHasNext = false;
        private T mNext;

        private WrapperImpl(Iterator<T> iterator) {
            this.mIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            if (!this.doesHandleExceptions()) {
                return this.mIterator.hasNext();
            }
            this.evaluate();
            return this.mHasNext;
        }

        @Override
        public T next() {
            if (!this.doesHandleExceptions()) {
                return this.mIterator.next();
            }
            this.evaluate();
            this.mEvaluated = false;
            if (this.mHasNext) {
                return this.mNext;
            }
            throw new NoSuchElementException();
        }

        boolean doesHandleExceptions() {
            return !this.mExceptionHandlers.isEmpty();
        }

        private void evaluate() {
            if (this.mEvaluated) {
                return;
            }
            this.mEvaluated = true;
            while (this.mIterator.hasNext()) {
                try {
                    this.mNext = this.mIterator.next();
                    this.mHasNext = true;
                    return;
                }
                catch (Exception e) {
                    for (ExceptionHandler<T, ?> handler : this.mExceptionHandlers) {
                        ExceptionHandler.Result<T> result = handler.handle(e);
                        if (result.doesHandle()) {
                            if (!result.hasMappedValue()) continue;
                            this.mNext = result.getMappedValue();
                            this.mHasNext = true;
                            return;
                        }
                        throw new StreamException("Failed to evaluate item.", e);
                    }
                }
            }
            this.mHasNext = false;
        }

        @Override
        public <E extends Throwable> void consumeException(Class<E> exceptionClass, Consumer<E> consumer) {
            this.mExceptionHandlers.add(new ConsumeExceptionHandler(exceptionClass, consumer));
        }

        @Override
        public <E extends Throwable> void mapException(Class<E> exceptionClass, Function<E, T> mapper) {
            this.mExceptionHandlers.add(new MappingExceptionHandler(exceptionClass, mapper));
        }
    }

    private static class MappingExceptionHandler<T, E extends Throwable>
    extends ExceptionHandler<T, E> {
        private final Function<E, T> mMapper;

        private MappingExceptionHandler(Class<E> exceptionClass, Function<E, T> mapper) {
            super(exceptionClass);
            this.mMapper = mapper;
        }

        @Override
        protected ExceptionHandler.Result<T> performHandle(E exception) {
            return new ResultImpl(true, true, this.mMapper.apply(exception));
        }
    }

    private static class ConsumeExceptionHandler<T, E extends Throwable>
    extends ExceptionHandler<T, E> {
        private final Consumer<E> mConsumer;

        private ConsumeExceptionHandler(Class<E> exceptionClass, Consumer<E> consumer) {
            super(exceptionClass);
            this.mConsumer = consumer;
        }

        @Override
        protected ExceptionHandler.Result<T> performHandle(E exception) {
            this.mConsumer.accept(exception);
            return new ResultImpl(true, false, null);
        }
    }

    private static abstract class ExceptionHandler<T, E extends Throwable> {
        private final Class<E> mExceptionClass;

        private ExceptionHandler(Class<E> exceptionClass) {
            this.mExceptionClass = exceptionClass;
        }

        Result<T> handle(Throwable exception) {
            if (!this.mExceptionClass.isAssignableFrom(exception.getClass())) {
                return new ResultImpl(false, false, null);
            }
            return this.performHandle(exception);
        }

        protected abstract Result<T> performHandle(E var1);

        static interface Result<T> {
            public boolean doesHandle();

            public boolean hasMappedValue();

            public T getMappedValue();
        }
    }

    private static interface Wrapper<T> {
        public <E extends Throwable> void consumeException(Class<E> var1, Consumer<E> var2);

        public <E extends Throwable> void mapException(Class<E> var1, Function<E, T> var2);
    }
}

