/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.intstream;

import com.github.wrdlbrnft.streamcompat.exceptions.StreamException;
import com.github.wrdlbrnft.streamcompat.function.Consumer;
import com.github.wrdlbrnft.streamcompat.function.ToIntFunction;
import com.github.wrdlbrnft.streamcompat.intstream.IntIteratorWrapper;
import com.github.wrdlbrnft.streamcompat.iterator.primtive.IntIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

class IntIteratorWrapperImpl
implements IntIteratorWrapper {
    private Wrapper mWrapper;

    IntIteratorWrapperImpl() {
    }

    @Override
    public IntIterator apply(IntIterator iterator) {
        WrapperImpl wrapper = new WrapperImpl(iterator);
        this.mWrapper = wrapper;
        return wrapper;
    }

    @Override
    public <E extends Throwable> void consumeException(Class<E> exceptionClass, Consumer<E> consumer) {
        this.mWrapper.consumeException(exceptionClass, consumer);
    }

    @Override
    public <E extends Throwable> void mapException(Class<E> exceptionClass, ToIntFunction<E> mapper) {
        this.mWrapper.mapException(exceptionClass, mapper);
    }

    private static class ResultImpl
    implements ExceptionHandler.Result {
        private final boolean mDoesHandle;
        private final boolean mHasMappedValue;
        private final int mMappedValue;

        private ResultImpl(boolean doesHandle, boolean hasMappedValue, int mappedValue) {
            this.mDoesHandle = doesHandle;
            this.mHasMappedValue = hasMappedValue;
            this.mMappedValue = mappedValue;
        }

        @Override
        public boolean doesHandle() {
            return this.mDoesHandle;
        }

        @Override
        public boolean hasMappedValue() {
            return this.mHasMappedValue;
        }

        @Override
        public int getMappedValue() {
            return this.mMappedValue;
        }
    }

    private static class WrapperImpl
    implements IntIterator,
    Wrapper {
        private final List<ExceptionHandler<?>> mExceptionHandlers = new ArrayList();
        private final IntIterator mIterator;
        private boolean mEvaluated = false;
        private boolean mHasNext = false;
        private int mNext;

        private WrapperImpl(IntIterator iterator) {
            this.mIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            if (!this.doesHandleExceptions()) {
                return this.mIterator.hasNext();
            }
            this.evaluate();
            return this.mHasNext;
        }

        @Override
        public Integer next() {
            return this.nextInt();
        }

        boolean doesHandleExceptions() {
            return !this.mExceptionHandlers.isEmpty();
        }

        @Override
        public int nextInt() {
            if (!this.doesHandleExceptions()) {
                return this.mIterator.nextInt();
            }
            this.evaluate();
            this.mEvaluated = false;
            if (this.mHasNext) {
                return this.mNext;
            }
            throw new NoSuchElementException();
        }

        private void evaluate() {
            if (this.mEvaluated) {
                return;
            }
            this.mEvaluated = true;
            while (this.mIterator.hasNext()) {
                try {
                    this.mNext = (Integer)this.mIterator.next();
                    this.mHasNext = true;
                    return;
                }
                catch (Exception e) {
                    for (ExceptionHandler<?> handler : this.mExceptionHandlers) {
                        ExceptionHandler.Result result = handler.handle(e);
                        if (result.doesHandle()) {
                            if (!result.hasMappedValue()) continue;
                            this.mNext = result.getMappedValue();
                            this.mHasNext = true;
                            return;
                        }
                        throw new StreamException("Failed to evaluate item.", e);
                    }
                }
            }
            this.mHasNext = false;
        }

        @Override
        public <E extends Throwable> void consumeException(Class<E> exceptionClass, Consumer<E> consumer) {
            this.mExceptionHandlers.add(new ConsumeExceptionHandler(exceptionClass, consumer));
        }

        @Override
        public <E extends Throwable> void mapException(Class<E> exceptionClass, ToIntFunction<E> mapper) {
            this.mExceptionHandlers.add(new MappingExceptionHandler(exceptionClass, mapper));
        }
    }

    private static class MappingExceptionHandler<E extends Throwable>
    extends ExceptionHandler<E> {
        private final ToIntFunction<E> mMapper;

        private MappingExceptionHandler(Class<E> exceptionClass, ToIntFunction<E> mapper) {
            super(exceptionClass);
            this.mMapper = mapper;
        }

        @Override
        protected ExceptionHandler.Result performHandle(E exception) {
            return new ResultImpl(true, true, this.mMapper.apply(exception));
        }
    }

    private static class ConsumeExceptionHandler<E extends Throwable>
    extends ExceptionHandler<E> {
        private final Consumer<E> mConsumer;

        private ConsumeExceptionHandler(Class<E> exceptionClass, Consumer<E> consumer) {
            super(exceptionClass);
            this.mConsumer = consumer;
        }

        @Override
        protected ExceptionHandler.Result performHandle(E exception) {
            this.mConsumer.accept(exception);
            return new ResultImpl(true, false, 0);
        }
    }

    private static abstract class ExceptionHandler<E extends Throwable> {
        private final Class<E> mExceptionClass;

        private ExceptionHandler(Class<E> exceptionClass) {
            this.mExceptionClass = exceptionClass;
        }

        Result handle(Throwable exception) {
            if (!this.mExceptionClass.isAssignableFrom(exception.getClass())) {
                return new ResultImpl(false, false, 0);
            }
            return this.performHandle(exception);
        }

        protected abstract Result performHandle(E var1);

        static interface Result {
            public boolean doesHandle();

            public boolean hasMappedValue();

            public int getMappedValue();
        }
    }

    private static interface Wrapper {
        public <E extends Throwable> void consumeException(Class<E> var1, Consumer<E> var2);

        public <E extends Throwable> void mapException(Class<E> var1, ToIntFunction<E> var2);
    }
}

