/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.optionals;

import com.github.wrdlbrnft.streamcompat.function.LongConsumer;
import com.github.wrdlbrnft.streamcompat.function.LongSupplier;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.util.Utils;
import java.util.NoSuchElementException;

public final class OptionalLong {
    private static final OptionalLong EMPTY = new OptionalLong();
    private final boolean mIsPresent;
    private final long mValue;

    private OptionalLong() {
        this.mIsPresent = false;
        this.mValue = 0L;
    }

    public static OptionalLong empty() {
        return EMPTY;
    }

    private OptionalLong(long value) {
        this.mIsPresent = true;
        this.mValue = value;
    }

    public static OptionalLong of(long value) {
        return new OptionalLong(value);
    }

    public long getAsLong() {
        if (!this.mIsPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.mValue;
    }

    public boolean isPresent() {
        return this.mIsPresent;
    }

    public void ifPresent(LongConsumer consumer) {
        if (this.mIsPresent) {
            consumer.accept(this.mValue);
        }
    }

    public long orElse(long other) {
        return this.mIsPresent ? this.mValue : other;
    }

    public long orElseGet(LongSupplier other) {
        return this.mIsPresent ? this.mValue : other.getAsLong();
    }

    public <X extends Throwable> long orElseThrow(Supplier<X> exceptionSupplier) throws X {
        if (this.mIsPresent) {
            return this.mValue;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalLong)) {
            return false;
        }
        OptionalLong other = (OptionalLong)obj;
        return this.mIsPresent && other.mIsPresent ? this.mValue == other.mValue : this.mIsPresent == other.mIsPresent;
    }

    public int hashCode() {
        return this.mIsPresent ? Utils.hashCode(this.mValue) : 0;
    }

    public String toString() {
        return this.mIsPresent ? String.format("OptionalLong[%s]", this.mValue) : "OptionalLong.empty";
    }
}

