/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.util;

public class Utils {
    public static <T> T requireNonNull(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    public static <T> T requireNonNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    public static <A, B> boolean equals(A a, B b) {
        return a == null ? b == null : a.equals(b);
    }

    public static <T> int hashCode(T object) {
        return object == null ? 0 : object.hashCode();
    }

    public static int hashCode(int value) {
        return value;
    }

    public static int hashCode(char value) {
        return value;
    }

    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    public static int hashCode(double value) {
        long v = Double.doubleToLongBits(value);
        return (int)(v ^ v >>> 32);
    }

    public static int hashCode(float value) {
        return Float.floatToIntBits(value);
    }
}

