/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.stream;

import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStream;
import com.github.wrdlbrnft.streamcompat.characterstream.CharacterStreamCompat;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStream;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStreamCompat;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStream;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamCompat;
import com.github.wrdlbrnft.streamcompat.function.BinaryOperator;
import com.github.wrdlbrnft.streamcompat.function.Function;
import com.github.wrdlbrnft.streamcompat.function.Predicate;
import com.github.wrdlbrnft.streamcompat.function.ToCharFunction;
import com.github.wrdlbrnft.streamcompat.function.ToDoubleFunction;
import com.github.wrdlbrnft.streamcompat.function.ToFloatFunction;
import com.github.wrdlbrnft.streamcompat.function.ToIntFunction;
import com.github.wrdlbrnft.streamcompat.function.ToLongFunction;
import com.github.wrdlbrnft.streamcompat.intstream.IntStream;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamCompat;
import com.github.wrdlbrnft.streamcompat.longstream.LongStream;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamCompat;
import com.github.wrdlbrnft.streamcompat.stream.Collector;
import com.github.wrdlbrnft.streamcompat.stream.FlatMapToCharIterator;
import com.github.wrdlbrnft.streamcompat.stream.FlatMapToDoubleIterator;
import com.github.wrdlbrnft.streamcompat.stream.FlatMapToFloatIterator;
import com.github.wrdlbrnft.streamcompat.stream.FlatMapToIntIterator;
import com.github.wrdlbrnft.streamcompat.stream.FlatMapToLongIterator;
import com.github.wrdlbrnft.streamcompat.stream.FlatMappingIterator;
import com.github.wrdlbrnft.streamcompat.stream.LimitIterator;
import com.github.wrdlbrnft.streamcompat.stream.MapToCharIterator;
import com.github.wrdlbrnft.streamcompat.stream.MapToDoubleIterator;
import com.github.wrdlbrnft.streamcompat.stream.MapToFloatIterator;
import com.github.wrdlbrnft.streamcompat.stream.MapToIntIterator;
import com.github.wrdlbrnft.streamcompat.stream.MapToLongIterator;
import com.github.wrdlbrnft.streamcompat.stream.MappingIterator;
import com.github.wrdlbrnft.streamcompat.stream.PredicateIterator;
import com.github.wrdlbrnft.streamcompat.stream.Stream;
import com.github.wrdlbrnft.streamcompat.stream.StreamImpl$$Lambda$1;
import com.github.wrdlbrnft.streamcompat.stream.StreamImpl$$Lambda$4;
import com.github.wrdlbrnft.streamcompat.stream.StreamImpl$$Lambda$5;
import com.github.wrdlbrnft.streamcompat.stream.StreamImpl$$Lambda$6;
import com.github.wrdlbrnft.streamcompat.util.Optional;
import com.github.wrdlbrnft.streamcompat.util.Utils;
import java.util.Comparator;
import java.util.Iterator;

class StreamImpl<T>
implements Stream<T> {
    private final Iterator<T> mIterator;

    public StreamImpl(Iterator<T> iterator) {
        this.mIterator = iterator;
    }

    @Override
    public Stream<T> filter(Predicate<T> predicate) {
        Utils.requireNonNull(predicate);
        PredicateIterator<T> iterator = new PredicateIterator<T>(this.mIterator, predicate);
        return new StreamImpl<T>(iterator);
    }

    @Override
    public <R> Stream<R> map(Function<T, ? extends R> mapper) {
        Utils.requireNonNull(mapper);
        MappingIterator<T, ? extends R> iterator = new MappingIterator<T, R>(this.mIterator, mapper);
        return new StreamImpl<T>(iterator);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        Utils.requireNonNull(mapper);
        MapToIntIterator<? super T> iterator = new MapToIntIterator<T>(this.mIterator, mapper);
        return IntStreamCompat.of(iterator);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        Utils.requireNonNull(mapper);
        MapToLongIterator<? super T> iterator = new MapToLongIterator<T>(this.mIterator, mapper);
        return LongStreamCompat.of(iterator);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        Utils.requireNonNull(mapper);
        MapToDoubleIterator<? super T> iterator = new MapToDoubleIterator<T>(this.mIterator, mapper);
        return DoubleStreamCompat.of(iterator);
    }

    @Override
    public FloatStream mapToFloat(ToFloatFunction<? super T> mapper) {
        Utils.requireNonNull(mapper);
        MapToFloatIterator<? super T> iterator = new MapToFloatIterator<T>(this.mIterator, mapper);
        return FloatStreamCompat.of(iterator);
    }

    @Override
    public CharacterStream mapToChar(ToCharFunction<? super T> mapper) {
        Utils.requireNonNull(mapper);
        MapToCharIterator<? super T> iterator = new MapToCharIterator<T>(this.mIterator, mapper);
        return CharacterStreamCompat.of(iterator);
    }

    @Override
    public <R> Stream<R> flatMap(Function<T, ? extends Stream<? extends R>> mapper) {
        Utils.requireNonNull(mapper);
        FlatMappingIterator iterator = new FlatMappingIterator(this.mIterator, mapper);
        return new StreamImpl<T>(iterator);
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        Utils.requireNonNull(mapper);
        FlatMapToIntIterator<? super T> iterator = new FlatMapToIntIterator<T>(this.mIterator, mapper);
        return IntStreamCompat.of(iterator);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        Utils.requireNonNull(mapper);
        FlatMapToLongIterator<? super T> iterator = new FlatMapToLongIterator<T>(this.mIterator, mapper);
        return LongStreamCompat.of(iterator);
    }

    @Override
    public FloatStream flatMapToFloat(Function<? super T, ? extends FloatStream> mapper) {
        Utils.requireNonNull(mapper);
        FlatMapToFloatIterator<? super T> iterator = new FlatMapToFloatIterator<T>(this.mIterator, mapper);
        return FloatStreamCompat.of(iterator);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        Utils.requireNonNull(mapper);
        FlatMapToDoubleIterator<? super T> iterator = new FlatMapToDoubleIterator<T>(this.mIterator, mapper);
        return DoubleStreamCompat.of(iterator);
    }

    @Override
    public CharacterStream flatMapToChar(Function<? super T, ? extends CharacterStream> mapper) {
        Utils.requireNonNull(mapper);
        FlatMapToCharIterator<? super T> iterator = new FlatMapToCharIterator<T>(this.mIterator, mapper);
        return CharacterStreamCompat.of(iterator);
    }

    @Override
    public <A, R> R collect(Collector<T, A, R> function) {
        Utils.requireNonNull(function);
        A result = function.supplier().get();
        while (this.mIterator.hasNext()) {
            function.accumulator().accept(result, this.mIterator.next());
        }
        return function.finisher().apply(result);
    }

    @Override
    public Stream<T> limit(long limit) {
        LimitIterator<T> iterator = new LimitIterator<T>(this.mIterator, limit);
        return new StreamImpl<T>(iterator);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        if (!this.mIterator.hasNext()) {
            return Optional.empty();
        }
        return Optional.of(this.reduce(this.mIterator.next(), accumulator));
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.reduce(identity, StreamImpl$$Lambda$1.lambdaFactory$(), accumulator);
    }

    @Override
    public <U> U reduce(U identity, Function<? super T, ? extends U> mapper, BinaryOperator<U> accumulator) {
        Utils.requireNonNull(mapper);
        Utils.requireNonNull(accumulator);
        Object current = identity;
        while (this.mIterator.hasNext()) {
            current = accumulator.apply(current, mapper.apply(this.mIterator.next()));
        }
        return current;
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        Utils.requireNonNull(comparator);
        return this.reduce(StreamImpl$$Lambda$4.lambdaFactory$(comparator));
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        Utils.requireNonNull(comparator);
        return this.reduce(StreamImpl$$Lambda$5.lambdaFactory$(comparator));
    }

    @Override
    public long count() {
        return this.mapToLong(StreamImpl$$Lambda$6.lambdaFactory$()).sum();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        Utils.requireNonNull(predicate);
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        Utils.requireNonNull(predicate);
        while (this.mIterator.hasNext()) {
            if (predicate.test(this.mIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        Utils.requireNonNull(predicate);
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Optional<T> findFirst() {
        while (this.mIterator.hasNext()) {
            T item = this.mIterator.next();
            if (item == null) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.mIterator;
    }

    private static /* synthetic */ long lambda$count$48(Object i) {
        return 1L;
    }

    private static /* synthetic */ Object lambda$max$47(Comparator comparator, Object a, Object b) {
        return comparator.compare(a, b) < 0 ? b : a;
    }

    private static /* synthetic */ Object lambda$min$46(Comparator comparator, Object a, Object b) {
        return comparator.compare(a, b) < 0 ? a : b;
    }

    static /* synthetic */ Object access$lambda$0(Object object) {
        return object;
    }

    static /* synthetic */ Object access$lambda$1(Comparator comparator, Object object, Object object2) {
        return StreamImpl.lambda$min$46(comparator, object, object2);
    }

    static /* synthetic */ Object access$lambda$2(Comparator comparator, Object object, Object object2) {
        return StreamImpl.lambda$max$47(comparator, object, object2);
    }

    static /* synthetic */ long access$lambda$3(Object object) {
        return StreamImpl.lambda$count$48(object);
    }
}

