/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.characterstream;

import com.github.wrdlbrnft.streamcompat.function.CharPredicate;
import com.github.wrdlbrnft.streamcompat.iterator.CharIterator;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseCharIterator;
import java.util.NoSuchElementException;

class CharacterPredicateIterator
extends BaseCharIterator
implements CharIterator {
    private final CharIterator mBaseIterator;
    private final CharPredicate mPredicate;
    private char mNext;
    private boolean mHasNext;

    CharacterPredicateIterator(CharIterator baseIterator, CharPredicate predicate) {
        this.mBaseIterator = baseIterator;
        this.mPredicate = predicate;
        this.moveToNext();
    }

    private void moveToNext() {
        while (this.mBaseIterator.hasNext()) {
            char item = ((Character)this.mBaseIterator.next()).charValue();
            if (!this.mPredicate.test(item)) continue;
            this.mNext = item;
            this.mHasNext = true;
            return;
        }
        this.mHasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.mHasNext;
    }

    @Override
    public char nextChar() {
        if (!this.mHasNext) {
            throw new NoSuchElementException("No items left to iterate over.");
        }
        char current = this.mNext;
        this.moveToNext();
        return current;
    }
}

