/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.stream;

import com.github.wrdlbrnft.streamcompat.floatstream.FloatStream;
import com.github.wrdlbrnft.streamcompat.function.Function;
import com.github.wrdlbrnft.streamcompat.iterator.FloatIterator;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseFloatIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

class FlatMapToFloatIterator<I>
extends BaseFloatIterator {
    private final Iterator<I> mBaseIterator;
    private final Function<? super I, ? extends FloatStream> mMapper;
    private FloatIterator mChild = null;
    private boolean mHasNext;
    private float mNext;

    public FlatMapToFloatIterator(Iterator<I> iterator, Function<? super I, ? extends FloatStream> mapper) {
        this.mBaseIterator = iterator;
        this.mMapper = mapper;
        this.moveToNext();
    }

    private void moveToNext() {
        if (this.mChild != null && this.mChild.hasNext()) {
            this.mHasNext = true;
            this.mNext = this.mChild.nextFloat();
            return;
        }
        this.mChild = null;
        while (this.mBaseIterator.hasNext()) {
            I input = this.mBaseIterator.next();
            FloatStream stream = this.mMapper.apply(input);
            this.mChild = stream.iterator();
            if (this.mChild == null || !this.mChild.hasNext()) continue;
            this.mHasNext = true;
            this.mNext = this.mChild.nextFloat();
            return;
        }
        this.mHasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.mHasNext;
    }

    @Override
    public float nextFloat() {
        if (!this.mHasNext) {
            throw new NoSuchElementException("No items left to iterate over.");
        }
        float current = this.mNext;
        this.moveToNext();
        return current;
    }
}

