/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.floatstream;

import com.github.wrdlbrnft.streamcompat.charstream.CharStream;
import com.github.wrdlbrnft.streamcompat.charstream.CharStreamCompat;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStream;
import com.github.wrdlbrnft.streamcompat.doublestream.DoubleStreamCompat;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatFlatMappingIterator;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatLimitIterator;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatMappingIterator;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatPredicateIterator;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStream;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$1;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$2;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$3;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$4;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$5;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$6;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatStreamImpl$$Lambda$7;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatToCharMappingIterator;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatToDoubleMappingIterator;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatToIntMappingIterator;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatToLongMappingIterator;
import com.github.wrdlbrnft.streamcompat.floatstream.FloatToObjectMappingIterator;
import com.github.wrdlbrnft.streamcompat.function.FloatBinaryOperator;
import com.github.wrdlbrnft.streamcompat.function.FloatFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatPredicate;
import com.github.wrdlbrnft.streamcompat.function.FloatToCharFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatToDoubleFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatToIntFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatToLongFunction;
import com.github.wrdlbrnft.streamcompat.function.FloatUnaryOperator;
import com.github.wrdlbrnft.streamcompat.function.ObjFloatConsumer;
import com.github.wrdlbrnft.streamcompat.function.Supplier;
import com.github.wrdlbrnft.streamcompat.intstream.IntStream;
import com.github.wrdlbrnft.streamcompat.intstream.IntStreamCompat;
import com.github.wrdlbrnft.streamcompat.iterator.FloatIterator;
import com.github.wrdlbrnft.streamcompat.longstream.LongStream;
import com.github.wrdlbrnft.streamcompat.longstream.LongStreamCompat;
import com.github.wrdlbrnft.streamcompat.stream.Stream;
import com.github.wrdlbrnft.streamcompat.stream.StreamCompat;
import com.github.wrdlbrnft.streamcompat.util.KahanSummation;
import com.github.wrdlbrnft.streamcompat.util.OptionalFloat;
import com.github.wrdlbrnft.streamcompat.util.Utils;

class FloatStreamImpl
implements FloatStream {
    private final FloatIterator mIterator;

    FloatStreamImpl(FloatIterator iterator) {
        this.mIterator = iterator;
    }

    @Override
    public FloatStream filter(FloatPredicate predicate) {
        Utils.requireNonNull(predicate);
        FloatPredicateIterator iterator = new FloatPredicateIterator(this.mIterator, predicate);
        return new FloatStreamImpl(iterator);
    }

    @Override
    public FloatStream map(FloatUnaryOperator mapper) {
        Utils.requireNonNull(mapper);
        FloatMappingIterator iterator = new FloatMappingIterator(this.mIterator, mapper);
        return new FloatStreamImpl(iterator);
    }

    @Override
    public FloatStream flatMap(FloatFunction<? extends FloatStream> mapper) {
        Utils.requireNonNull(mapper);
        FloatFlatMappingIterator iterator = new FloatFlatMappingIterator(this.mIterator, mapper);
        return new FloatStreamImpl(iterator);
    }

    @Override
    public <U> Stream<U> mapToObj(FloatFunction<? extends U> mapper) {
        Utils.requireNonNull(mapper);
        FloatToObjectMappingIterator<? extends U> iterator = new FloatToObjectMappingIterator<U>(this.mIterator, mapper);
        return StreamCompat.of(iterator);
    }

    @Override
    public LongStream mapToLong(FloatToLongFunction mapper) {
        Utils.requireNonNull(mapper);
        FloatToLongMappingIterator iterator = new FloatToLongMappingIterator(this.mIterator, mapper);
        return LongStreamCompat.of(iterator);
    }

    @Override
    public IntStream mapToInt(FloatToIntFunction mapper) {
        Utils.requireNonNull(mapper);
        FloatToIntMappingIterator iterator = new FloatToIntMappingIterator(this.mIterator, mapper);
        return IntStreamCompat.of(iterator);
    }

    @Override
    public CharStream mapToChar(FloatToCharFunction mapper) {
        Utils.requireNonNull(mapper);
        FloatToCharMappingIterator iterator = new FloatToCharMappingIterator(this.mIterator, mapper);
        return CharStreamCompat.of(iterator);
    }

    @Override
    public DoubleStream mapToDouble(FloatToDoubleFunction mapper) {
        Utils.requireNonNull(mapper);
        FloatToDoubleMappingIterator iterator = new FloatToDoubleMappingIterator(this.mIterator, mapper);
        return DoubleStreamCompat.of(iterator);
    }

    @Override
    public FloatIterator iterator() {
        return this.mIterator;
    }

    @Override
    public Stream<Float> boxed() {
        return StreamCompat.of(this.mIterator);
    }

    @Override
    public FloatStream limit(long limit) {
        FloatLimitIterator iterator = new FloatLimitIterator(this.mIterator, limit);
        return new FloatStreamImpl(iterator);
    }

    @Override
    public float reduce(float identity, FloatBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        float current = identity;
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsFloat(current, this.mIterator.nextFloat());
        }
        return current;
    }

    @Override
    public OptionalFloat reduce(FloatBinaryOperator accumulator) {
        Utils.requireNonNull(accumulator);
        if (!this.mIterator.hasNext()) {
            return OptionalFloat.empty();
        }
        float current = this.mIterator.nextFloat();
        while (this.mIterator.hasNext()) {
            current = accumulator.applyAsFloat(current, this.mIterator.nextFloat());
        }
        return OptionalFloat.of(current);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjFloatConsumer<R> accumulator) {
        Utils.requireNonNull(supplier);
        Utils.requireNonNull(accumulator);
        R sink = supplier.get();
        while (this.mIterator.hasNext()) {
            accumulator.accept(sink, this.mIterator.nextFloat());
        }
        return sink;
    }

    @Override
    public float sum() {
        float[] summation = (float[])this.collect(FloatStreamImpl$$Lambda$1.lambdaFactory$(), FloatStreamImpl$$Lambda$2.lambdaFactory$());
        return KahanSummation.computeFinalSum(summation);
    }

    @Override
    public OptionalFloat min() {
        return this.reduce(FloatStreamImpl$$Lambda$3.lambdaFactory$());
    }

    @Override
    public OptionalFloat max() {
        return this.reduce(FloatStreamImpl$$Lambda$4.lambdaFactory$());
    }

    @Override
    public long count() {
        return this.mapToLong(FloatStreamImpl$$Lambda$5.lambdaFactory$()).sum();
    }

    @Override
    public OptionalFloat average() {
        float[] avg = (float[])this.collect(FloatStreamImpl$$Lambda$6.lambdaFactory$(), FloatStreamImpl$$Lambda$7.lambdaFactory$());
        return avg[2] > 0.0f ? OptionalFloat.of(KahanSummation.computeFinalSum(avg) / avg[2]) : OptionalFloat.empty();
    }

    @Override
    public OptionalFloat findFirst() {
        return this.mIterator.hasNext() ? OptionalFloat.of(this.mIterator.nextFloat()) : OptionalFloat.empty();
    }

    @Override
    public boolean anyMatch(FloatPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextFloat())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allMatch(FloatPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (predicate.test(this.mIterator.nextFloat())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneMatch(FloatPredicate predicate) {
        while (this.mIterator.hasNext()) {
            if (!predicate.test(this.mIterator.nextFloat())) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$average$15(float[] ll, float d) {
        ll[2] = ll[2] + 1.0f;
        KahanSummation.sumWithCompensation(ll, d);
        ll[3] = ll[3] + d;
    }

    private static /* synthetic */ float[] lambda$average$14() {
        return new float[4];
    }

    private static /* synthetic */ long lambda$count$13(float i) {
        return 1L;
    }

    private static /* synthetic */ void lambda$sum$12(float[] ll, float d) {
        KahanSummation.sumWithCompensation(ll, d);
        ll[2] = ll[2] + d;
    }

    private static /* synthetic */ float[] lambda$sum$11() {
        return new float[3];
    }

    static /* synthetic */ float[] access$lambda$0() {
        return FloatStreamImpl.lambda$sum$11();
    }

    static /* synthetic */ void access$lambda$1(float[] fArray, float f) {
        FloatStreamImpl.lambda$sum$12(fArray, f);
    }

    static /* synthetic */ long access$lambda$2(float f) {
        return FloatStreamImpl.lambda$count$13(f);
    }

    static /* synthetic */ float[] access$lambda$3() {
        return FloatStreamImpl.lambda$average$14();
    }

    static /* synthetic */ void access$lambda$4(float[] fArray, float f) {
        FloatStreamImpl.lambda$average$15(fArray, f);
    }
}

