/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat.floatstream;

import com.github.wrdlbrnft.streamcompat.floatstream.FloatStream;
import com.github.wrdlbrnft.streamcompat.function.FloatFunction;
import com.github.wrdlbrnft.streamcompat.iterator.FloatIterator;
import com.github.wrdlbrnft.streamcompat.iterator.base.BaseFloatIterator;
import java.util.NoSuchElementException;

class FloatFlatMappingIterator
extends BaseFloatIterator
implements FloatIterator {
    private final FloatIterator mBaseIterator;
    private final FloatFunction<? extends FloatStream> mMapper;
    private FloatIterator mChild = null;
    private boolean mHasNext;
    private float mNext;

    public FloatFlatMappingIterator(FloatIterator iterator, FloatFunction<? extends FloatStream> mapper) {
        this.mBaseIterator = iterator;
        this.mMapper = mapper;
        this.moveToNext();
    }

    private void moveToNext() {
        if (this.mChild != null && this.mChild.hasNext()) {
            this.mHasNext = true;
            this.mNext = this.mChild.nextFloat();
            return;
        }
        this.mChild = null;
        while (this.mBaseIterator.hasNext()) {
            float input = this.mBaseIterator.nextFloat();
            FloatStream stream = this.mMapper.apply(input);
            this.mChild = stream.iterator();
            if (this.mChild == null || !this.mChild.hasNext()) continue;
            this.mHasNext = true;
            this.mNext = this.mChild.nextFloat();
            return;
        }
        this.mHasNext = false;
    }

    @Override
    public boolean hasNext() {
        return this.mHasNext;
    }

    @Override
    public float nextFloat() {
        if (!this.mHasNext) {
            throw new NoSuchElementException("No items left to iterate over.");
        }
        float current = this.mNext;
        this.moveToNext();
        return current;
    }
}

