/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat;

import com.github.wrdlbrnft.streamcompat.ArrayIterator;
import com.github.wrdlbrnft.streamcompat.BooleanArrayIterator;
import com.github.wrdlbrnft.streamcompat.CharArrayIterator;
import com.github.wrdlbrnft.streamcompat.DoubleArrayIterator;
import com.github.wrdlbrnft.streamcompat.FloatArrayIterator;
import com.github.wrdlbrnft.streamcompat.ImmutableIterator;
import com.github.wrdlbrnft.streamcompat.IntArrayIterator;
import com.github.wrdlbrnft.streamcompat.IteratingStreamImpl;
import com.github.wrdlbrnft.streamcompat.LongArrayIterator;
import com.github.wrdlbrnft.streamcompat.Stream;
import java.util.Collection;

public class StreamCompat {
    public static <S> Stream<S> of(Collection<S> collection) {
        ImmutableIterator<S> iterator = new ImmutableIterator<S>(collection.iterator());
        return new IteratingStreamImpl<S>(iterator);
    }

    @SafeVarargs
    public static <S> Stream<S> of(S ... items) {
        ArrayIterator<S> iterator = new ArrayIterator<S>(items);
        return new IteratingStreamImpl<S>(iterator);
    }

    public static Stream<Character> of(char[] items) {
        CharArrayIterator iterator = new CharArrayIterator(items);
        return new IteratingStreamImpl<Character>(iterator);
    }

    public static Stream<Integer> of(int[] items) {
        IntArrayIterator iterator = new IntArrayIterator(items);
        return new IteratingStreamImpl<Integer>(iterator);
    }

    public static Stream<Long> of(long[] items) {
        LongArrayIterator iterator = new LongArrayIterator(items);
        return new IteratingStreamImpl<Long>(iterator);
    }

    public static Stream<Boolean> of(boolean[] items) {
        BooleanArrayIterator iterator = new BooleanArrayIterator(items);
        return new IteratingStreamImpl<Boolean>(iterator);
    }

    public static Stream<Float> of(float[] items) {
        FloatArrayIterator iterator = new FloatArrayIterator(items);
        return new IteratingStreamImpl<Float>(iterator);
    }

    public static Stream<Double> of(double[] items) {
        DoubleArrayIterator iterator = new DoubleArrayIterator(items);
        return new IteratingStreamImpl<Double>(iterator);
    }
}

