/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.streamcompat;

import com.github.wrdlbrnft.streamcompat.Collector;
import com.github.wrdlbrnft.streamcompat.FlatMappingIterator;
import com.github.wrdlbrnft.streamcompat.Function;
import com.github.wrdlbrnft.streamcompat.MappingIterator;
import com.github.wrdlbrnft.streamcompat.Predicate;
import com.github.wrdlbrnft.streamcompat.PredicateIterator;
import com.github.wrdlbrnft.streamcompat.Stream;
import com.github.wrdlbrnft.streamcompat.Utils;
import java.util.Iterator;

class IteratingStreamImpl<T>
implements Stream<T> {
    private final Iterator<T> mIterator;

    public IteratingStreamImpl(Iterator<T> iterator) {
        this.mIterator = iterator;
    }

    @Override
    public Stream<T> filter(Predicate<T> predicate) {
        Utils.requireNonNull(predicate);
        PredicateIterator<T> iterator = new PredicateIterator<T>(this.mIterator, predicate);
        return new IteratingStreamImpl<T>(iterator);
    }

    @Override
    public <R> Stream<R> map(Function<T, ? extends R> mapper) {
        Utils.requireNonNull(mapper);
        MappingIterator<T, ? extends R> iterator = new MappingIterator<T, R>(this.mIterator, mapper);
        return new IteratingStreamImpl<T>(iterator);
    }

    @Override
    public <R> Stream<R> flatMap(Function<T, ? extends Stream<? extends R>> mapper) {
        Utils.requireNonNull(mapper);
        FlatMappingIterator iterator = new FlatMappingIterator(this.mIterator, mapper);
        return new IteratingStreamImpl<T>(iterator);
    }

    @Override
    public <A, R> R collect(Collector<T, A, R> function) {
        Utils.requireNonNull(function);
        A result = function.supplier().get();
        while (this.mIterator.hasNext()) {
            function.accumulator().accept(result, this.mIterator.next());
        }
        return function.finisher().apply(result);
    }

    @Override
    public Iterator<T> iterator() {
        return this.mIterator;
    }
}

