/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplerest.connection;

import com.github.wrdlbrnft.simplerest.connection.BackendConnectionImpl;
import com.github.wrdlbrnft.simplerest.connection.request.Request;
import com.github.wrdlbrnft.simplerest.connection.response.Response;
import com.github.wrdlbrnft.simplerest.connection.spec.ConnectionSpec;
import com.github.wrdlbrnft.simplerest.connection.spec.http.HttpConnectionSpec;
import com.github.wrdlbrnft.simplerest.util.SimpleRestUtils;

public interface BackendConnection {
    public Response perform(Request var1);

    public void registerObserver(Observer var1);

    public void unregisterObserver(Observer var1);

    public static class Builder {
        private static final ConnectionSpec DEFAULT_CONNECTION_SPEC = new HttpConnectionSpec();
        private String mEndpointUrl;
        private ConnectionSpec mConnectionSpec = DEFAULT_CONNECTION_SPEC;

        public Builder setEndpointUrl(String endpointUrl) {
            this.mEndpointUrl = endpointUrl;
            return this;
        }

        public Builder setConnectionSpec(ConnectionSpec connectionSpec) {
            this.mConnectionSpec = connectionSpec;
            return this;
        }

        public BackendConnection build() {
            return new BackendConnectionImpl(SimpleRestUtils.requireNotNull(this.mEndpointUrl, "You have to specify an endpoint url for a BackendConnection."), SimpleRestUtils.requireNotNull(this.mConnectionSpec, "You have to specify a valid ConnectionSpec for a BackendConnection."));
        }
    }

    public static interface Observer {
        default public void onPerformingRequest(Request request) {
        }

        default public void onResponseReceived(Response response) {
        }

        default public void onRequestFailed(Throwable throwable) {
        }

        default public void onRequestProcessed(Request request, Response response, Throwable error) {
        }
    }
}

