/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplerest.util;

import android.text.TextUtils;
import com.github.wrdlbrnft.simplerest.SimpleRestConfig;
import com.github.wrdlbrnft.simplerest.connection.request.Request;
import com.github.wrdlbrnft.simplerest.connection.response.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LogUtils {
    public static Block newBlock() {
        return new BlockImpl();
    }

    public static void logRequest(Block block, Request request) {
        if (SimpleRestConfig.Debug.ENABLED) {
            if (SimpleRestConfig.Debug.SHOW_HEADERS) {
                Map<String, String> headers = request.getHeaders();
                Set<String> keySet = headers.keySet();
                block.append("\t" + keySet.size() + " Headers: ").newLine();
                for (String key : keySet) {
                    String value = headers.get(key);
                    block.append("\t- " + key + ": " + value).newLine();
                }
                block.newLine();
            }
            block.append((Object)((Object)request.getMethod()) + " " + request.getRelativeUrl()).newLine();
            String data = request.getData();
            if (!TextUtils.isEmpty((CharSequence)data)) {
                block.append(data).newLine();
            }
        }
    }

    public static void logResponse(Block block, Response response) {
        if (SimpleRestConfig.Debug.ENABLED) {
            String data;
            block.append("--> " + response.getStatus()).newLine();
            if (SimpleRestConfig.Debug.SHOW_HEADERS) {
                Map<String, String> headers = response.getHeaders();
                Set<String> keySet = headers.keySet();
                block.append("\t" + keySet.size() + " Headers: ").newLine();
                for (String key : keySet) {
                    String value = headers.get(key);
                    block.append("\t- " + key + ": " + value).newLine();
                }
                block.newLine();
            }
            if (!TextUtils.isEmpty((CharSequence)(data = response.getData()))) {
                block.append(data).newLine();
            }
        }
    }

    private static class BlockImpl
    implements Block {
        private final List<StringBuilder> mLines = new ArrayList<StringBuilder>();
        private StringBuilder mCurrent;

        public BlockImpl() {
            this.newLine();
        }

        @Override
        public Block append(String text) {
            this.mCurrent.append(text);
            return this;
        }

        @Override
        public Block newLine() {
            this.mCurrent = new StringBuilder();
            this.mLines.add(this.mCurrent);
            return this;
        }

        @Override
        public String build() {
            StringBuilder builder = new StringBuilder();
            int maxLineLength = this.determineMaxLineLength();
            int blockLength = maxLineLength + 4;
            BlockImpl.appendRepeatedChar(builder, '#', blockLength);
            builder.append("\n");
            int count = this.mLines.size();
            for (int i = 0; i < count; ++i) {
                StringBuilder line = this.mLines.get(i);
                if (i > 0) {
                    builder.append("\n");
                }
                builder.append("# ");
                int length = line.length();
                int differenceToMaxLength = maxLineLength - length;
                builder.append((CharSequence)line);
                BlockImpl.appendRepeatedChar(builder, ' ', differenceToMaxLength);
                builder.append(" #");
            }
            builder.append("\n");
            BlockImpl.appendRepeatedChar(builder, '#', blockLength);
            return builder.toString();
        }

        private static void appendRepeatedChar(StringBuilder builder, char c, int count) {
            for (int i = 0; i < count; ++i) {
                builder.append(c);
            }
        }

        private int determineMaxLineLength() {
            int maxLineLength = 0;
            for (StringBuilder line : this.mLines) {
                int length = line.length();
                if (length <= maxLineLength) continue;
                maxLineLength = length;
            }
            return maxLineLength;
        }
    }

    public static interface Block {
        public Block append(String var1);

        public Block newLine();

        public String build();
    }
}

