/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplerest;

import com.github.wrdlbrnft.simplerest.Api;
import com.github.wrdlbrnft.simplerest.taskrunners.ApiTaskRunner;
import com.github.wrdlbrnft.simplerest.tasks.ApiTask;
import com.github.wrdlbrnft.simplerest.tasks.Result;
import java.util.concurrent.Callable;

public abstract class BaseApi
implements Api {
    private ApiTaskRunner mRunner;

    protected BaseApi(ApiTaskRunner runner) {
        this.mRunner = runner;
    }

    protected BaseApi() {
        this(null);
    }

    protected void setApiTaskRunner(ApiTaskRunner runner) {
        this.mRunner = runner;
    }

    protected <T> ApiTask<T> queueTask(Callable<Result<T>> callable) {
        return this.mRunner.queueTask(callable);
    }

    public ApiTaskRunner getRunner() {
        return this.mRunner;
    }

    public static class EmptyResultImpl<T>
    implements Result<T> {
        private final int mStatusCode;

        public EmptyResultImpl(int statusCode) {
            this.mStatusCode = statusCode;
        }

        @Override
        public int getStatusCode() {
            return this.mStatusCode;
        }

        @Override
        public T getData() {
            return null;
        }
    }

    public static class ResultImpl<T>
    implements Result<T> {
        private final int mStatusCode;
        private final T mItem;

        public ResultImpl(int statusCode, T item) {
            this.mStatusCode = statusCode;
            this.mItem = item;
        }

        @Override
        public int getStatusCode() {
            return this.mStatusCode;
        }

        @Override
        public T getData() {
            return this.mItem;
        }
    }
}

