/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplerest.connection;

import android.support.annotation.NonNull;
import com.github.wrdlbrnft.simplerest.connection.AbsBackendConnection;
import com.github.wrdlbrnft.simplerest.connection.exception.BackendConnectionException;
import com.github.wrdlbrnft.simplerest.connection.request.QueryParameter;
import com.github.wrdlbrnft.simplerest.connection.request.Request;
import com.github.wrdlbrnft.simplerest.connection.spec.ConnectionSpec;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;

class BackendConnectionImpl
extends AbsBackendConnection {
    private final String mEndpointUrl;
    private final ConnectionSpec mConnectionSpec;

    public BackendConnectionImpl(String endpointUrl, ConnectionSpec connectionSpec) {
        this.mEndpointUrl = endpointUrl;
        this.mConnectionSpec = connectionSpec;
    }

    @Override
    protected HttpURLConnection performConnect(Request request) throws BackendConnectionException {
        try {
            String urlString = this.createUrl(request);
            HttpURLConnection connection = this.mConnectionSpec.openConnection(urlString);
            connection.setInstanceFollowRedirects(request.shouldFollowRedirects());
            Map<String, String> headers = request.getHeaders();
            for (String key : headers.keySet()) {
                connection.setRequestProperty(key, headers.get(key));
            }
            connection.setUseCaches(false);
            Request.Method method = request.getMethod();
            connection.setDoOutput(method.doesOutput());
            connection.setDoInput(method.doesInput());
            connection.setRequestMethod(method.getHttpRepresentation());
            connection.connect();
            return connection;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new BackendConnectionException("Connection to backend failed!", e);
        }
    }

    @NonNull
    private String createUrl(Request request) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.mEndpointUrl).append(request.getRelativeUrl());
        List<QueryParameter> queryParameters = request.getQueryParameters();
        int count = queryParameters.size();
        for (int i = 0; i < count; ++i) {
            QueryParameter parameter = queryParameters.get(i);
            builder.append(i == 0 ? "?" : "&");
            builder.append(parameter.getKey()).append("=").append(parameter.getValue());
        }
        return builder.toString();
    }
}

