/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplejson.parsers;

import com.github.wrdlbrnft.simplejson.exceptions.SimpleJsonException;
import com.github.wrdlbrnft.simplejson.parsers.Parser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseParser<T>
implements Parser<T> {
    @Override
    public final T fromJsonObject(JSONObject object, String key) throws SimpleJsonException {
        try {
            JSONObject entityObject = object.getJSONObject(key);
            return this.fromJsonObject(entityObject);
        }
        catch (JSONException e) {
            throw new SimpleJsonException("Failed to get object with key \"" + key + "\" from json: " + object, e);
        }
    }

    @Override
    public final void toJsonObject(JSONObject object, String key, T value) throws SimpleJsonException {
        try {
            object.put(key, (Object)this.toJsonObject(value));
        }
        catch (JSONException e) {
            throw new SimpleJsonException("Failed to add object " + value + " with the key \"" + key + "\" to this json: " + object, e);
        }
    }

    @Override
    public final T fromJsonArray(JSONArray array, int index) throws SimpleJsonException {
        try {
            JSONObject entityObject = array.getJSONObject(index);
            return this.fromJsonObject(entityObject);
        }
        catch (JSONException e) {
            throw new SimpleJsonException("Failed to get object with index " + index + " from json array: " + array, e);
        }
    }

    @Override
    public final void toJsonArray(JSONArray array, T value) throws SimpleJsonException {
        array.put((Object)this.toJsonObject(value));
    }

    @Override
    public final T fromJson(String json) throws SimpleJsonException {
        try {
            JSONObject object = new JSONObject(json);
            return this.fromJsonObject(object);
        }
        catch (JSONException e) {
            throw new SimpleJsonException("Failed to parse object from json: " + json, e);
        }
    }

    @Override
    public final List<T> fromJsonArray(String json) throws SimpleJsonException {
        try {
            ArrayList<T> list = new ArrayList<T>();
            JSONArray array = new JSONArray(json);
            for (int i = 0; i < array.length(); ++i) {
                JSONObject object = array.getJSONObject(i);
                list.add(this.fromJsonObject(object));
            }
            return list;
        }
        catch (JSONException e) {
            throw new SimpleJsonException("Failed to parse list of objects from json: " + json, e);
        }
    }

    @Override
    public final String toJson(T entity) throws SimpleJsonException {
        JSONObject object = this.toJsonObject(entity);
        return object.toString();
    }

    @Override
    public final String toJson(Collection<T> entities) throws SimpleJsonException {
        JSONArray array = new JSONArray();
        for (T entity : entities) {
            JSONObject t = this.toJsonObject(entity);
            array.put((Object)t);
        }
        return array.toString();
    }

    @Override
    public final T fromJsonObject(JSONObject object) throws SimpleJsonException {
        try {
            return this.convertFromJson(object);
        }
        catch (JSONException e) {
            throw new SimpleJsonException("Failed to parse object from json: " + object, e);
        }
    }

    @Override
    public final JSONObject toJsonObject(T entity) throws SimpleJsonException {
        try {
            return this.convertToJson(entity);
        }
        catch (JSONException e) {
            throw new SimpleJsonException("Failed to format object to json: " + entity, e);
        }
    }

    protected abstract T convertFromJson(JSONObject var1) throws JSONException;

    protected abstract JSONObject convertToJson(T var1) throws JSONException;
}

