/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplejson.parsers.base.date;

import com.github.wrdlbrnft.simplejson.parsers.base.date.DateFormatter;
import java.text.ParseException;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UnixTimeStampDateFormatter
implements DateFormatter {
    private final boolean mInMilliSeconds;

    public UnixTimeStampDateFormatter(boolean inMilliSeconds) {
        this.mInMilliSeconds = inMilliSeconds;
    }

    public UnixTimeStampDateFormatter() {
        this(true);
    }

    @Override
    public Date fromJsonObject(JSONObject object, String key) throws JSONException, ParseException {
        long timeStamp = this.mInMilliSeconds ? object.getLong(key) : object.getLong(key) * 1000L;
        return new Date(timeStamp);
    }

    @Override
    public void toJsonObject(JSONObject object, String key, Date value) throws JSONException {
        long timeStamp = this.mInMilliSeconds ? value.getTime() : value.getTime() / 1000L;
        object.put(key, timeStamp);
    }

    @Override
    public Date fromJsonArray(JSONArray array, int index) throws JSONException, ParseException {
        long timeStamp = this.mInMilliSeconds ? array.getLong(index) : array.getLong(index) * 1000L;
        return new Date(timeStamp);
    }

    @Override
    public void toJsonArray(JSONArray array, Date value) {
        long timeStamp = this.mInMilliSeconds ? value.getTime() : value.getTime() / 1000L;
        array.put(timeStamp);
    }
}

