/*
 * Decompiled with CFR 0.152.
 */
package com.github.wrdlbrnft.simplejson.parsers.base;

import com.github.wrdlbrnft.simplejson.exceptions.SimpleJsonException;
import com.github.wrdlbrnft.simplejson.parsers.ElementParser;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FloatParser
implements ElementParser<Float> {
    @Override
    public Float fromJsonObject(JSONObject object, String key) throws SimpleJsonException {
        try {
            return Float.valueOf((float)object.getDouble(key));
        }
        catch (JSONException e) {
            throw new SimpleJsonException("Failed to get Double value with key \"" + key + "\" from json: " + object, e);
        }
    }

    @Override
    public void toJsonObject(JSONObject object, String key, Float value) throws SimpleJsonException {
        try {
            object.put(key, (Object)value);
        }
        catch (JSONException e) {
            throw new SimpleJsonException("Failed to add Double value " + value + " with key \"" + key + "\" to json: " + object, e);
        }
    }

    @Override
    public Float fromJsonArray(JSONArray array, int index) throws SimpleJsonException {
        try {
            return Float.valueOf((float)array.getDouble(index));
        }
        catch (JSONException e) {
            throw new SimpleJsonException("Failed to get Double value with index " + index + " from json array: " + array, e);
        }
    }

    @Override
    public void toJsonArray(JSONArray array, Float value) throws SimpleJsonException {
        array.put((Object)value);
    }
}

