/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.flattener;

import com.github.wnameless.json.flattener.ObjectMapperFactory;
import com.github.wnameless.json.flattener.PrintMode;
import com.github.wnameless.json.flattener.StringEscapePolicy;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.text.translate.CharSequenceTranslator;

public class JsonifyArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 1L;
    private CharSequenceTranslator translator = StringEscapePolicy.DEFAULT.getCharSequenceTranslator();

    public void setTranslator(CharSequenceTranslator translator) {
        this.translator = translator;
    }

    public String toString(PrintMode printMode) {
        try {
            switch (printMode) {
                case REGULAR: {
                    return ObjectMapperFactory.getWriter().writeValueAsString(ObjectMapperFactory.get(this.translator).readValue(this.toString(), Object.class));
                }
                case PRETTY: {
                    return ObjectMapperFactory.getWriter().writerWithDefaultPrettyPrinter().writeValueAsString(ObjectMapperFactory.get(this.translator).readValue(this.toString(), Object.class));
                }
            }
            return ObjectMapperFactory.getWriter().writeValueAsString(ObjectMapperFactory.get(this.translator).readValue(this.toString(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Object e : this) {
            if (e instanceof String) {
                sb.append('\"');
                sb.append(this.translator.translate((CharSequence)((String)e)));
                sb.append('\"');
            } else {
                sb.append(e);
            }
            sb.append(',');
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
        return sb.toString();
    }
}

