/*
 * Decompiled with CFR 0.152.
 */
package com.warkiz.widget;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.warkiz.widget.IndicatorSeekBar;
import com.warkiz.widget.SizeUtils;

public class IndicatorStayLayout
extends LinearLayout {
    public IndicatorStayLayout(Context context) {
        this(context, null);
    }

    public IndicatorStayLayout(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IndicatorStayLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(1);
    }

    protected void onFinishInflate() {
        int childCount = this.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            this.layoutIndicator(this.getChildAt(i), i);
        }
        super.onFinishInflate();
    }

    public void attachTo(IndicatorSeekBar seekBar) {
        this.attachTo(seekBar, -2);
    }

    public void attachTo(IndicatorSeekBar seekBar, int index) {
        if (seekBar == null) {
            throw new NullPointerException("the seek bar wanna attach to IndicatorStayLayout can not be null value.");
        }
        this.layoutIndicator(seekBar, index);
        this.addView(seekBar, index + 1);
    }

    private void layoutIndicator(View child, int index) {
        if (child instanceof IndicatorSeekBar) {
            IndicatorSeekBar seekBar = (IndicatorSeekBar)child;
            View contentView = seekBar.getIndicatorContentView(true);
            if (contentView == null) {
                throw new IllegalStateException("Can not find any indicator in the IndicatorSeekBar, please make sure you have called the attr: SHOW_INDICATOR_TYPE for IndicatorSeekBar and the value is not IndicatorType.NONE.");
            }
            if (contentView instanceof IndicatorSeekBar) {
                throw new IllegalStateException("IndicatorSeekBar can not be a contentView for Indicator in case this inflating loop.");
            }
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-2, -2);
            ViewGroup.MarginLayoutParams layoutParams = new ViewGroup.MarginLayoutParams(params);
            layoutParams.setMargins(layoutParams.leftMargin, layoutParams.topMargin, layoutParams.rightMargin, SizeUtils.dp2px(this.mContext, 2.0f) - seekBar.getPaddingTop());
            this.addView(contentView, index, (ViewGroup.LayoutParams)layoutParams);
            seekBar.updateStayIndicator(this.getViewScreenX());
        }
    }

    public void setOrientation(int orientation) {
        if (orientation != 1) {
            throw new IllegalArgumentException("IndicatorStayLayout is always vertical and does not support horizontal orientation");
        }
        super.setOrientation(orientation);
    }

    private int getViewScreenX() {
        int[] mLocation = new int[2];
        this.getLocationOnScreen(mLocation);
        return mLocation[0];
    }
}

