/*
 * Decompiled with CFR 0.152.
 */
package com.warkiz.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;

public class IndicatorUtils {
    static int dp2px(Context context, float dpValue) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    static int sp2px(Context context, float spValue) {
        return (int)(spValue * context.getResources().getDisplayMetrics().scaledDensity + 0.5f);
    }

    static int px2sp(Context context, float pxValue) {
        return (int)(pxValue / context.getResources().getDisplayMetrics().scaledDensity + 0.5f);
    }

    public static boolean isViewCovered(View view) {
        boolean totalViewVisible;
        View currentView = view;
        Rect currentViewRect = new Rect();
        boolean partVisible = currentView.getGlobalVisibleRect(currentViewRect);
        boolean totalHeightVisible = currentViewRect.bottom - currentViewRect.top >= view.getMeasuredHeight();
        boolean totalWidthVisible = currentViewRect.right - currentViewRect.left >= view.getMeasuredWidth();
        boolean bl = totalViewVisible = partVisible && totalHeightVisible && totalWidthVisible;
        if (!totalViewVisible) {
            return true;
        }
        while (currentView.getParent() instanceof ViewGroup) {
            ViewGroup currentParent = (ViewGroup)currentView.getParent();
            if (currentParent.getVisibility() != 0) {
                return true;
            }
            int start = IndicatorUtils.indexOfViewInParent(currentView, currentParent);
            for (int i = start + 1; i < currentParent.getChildCount(); ++i) {
                Rect viewRect = new Rect();
                view.getGlobalVisibleRect(viewRect);
                View otherView = currentParent.getChildAt(i);
                Rect otherViewRect = new Rect();
                otherView.getGlobalVisibleRect(otherViewRect);
                if (!Rect.intersects((Rect)viewRect, (Rect)otherViewRect)) continue;
                return true;
            }
            currentView = currentParent;
        }
        return false;
    }

    private static int indexOfViewInParent(View view, ViewGroup parent) {
        int index;
        for (index = 0; index < parent.getChildCount() && parent.getChildAt(index) != view; ++index) {
        }
        return index;
    }
}

