/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.sets;

import com.carrotsearch.hppcrt.AbstractCharCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.CharArrays;
import com.carrotsearch.hppcrt.CharContainer;
import com.carrotsearch.hppcrt.CharLookupContainer;
import com.carrotsearch.hppcrt.CharSet;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.CharCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.CharPredicate;
import com.carrotsearch.hppcrt.procedures.CharProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharHashSet
extends AbstractCharCollection
implements CharLookupContainer,
CharSet,
Cloneable {
    public char[] keys;
    public boolean allocatedDefaultKey = false;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<CharCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = CharHashSet.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public CharHashSet() {
        this(8, 0.75);
    }

    public CharHashSet(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public CharHashSet(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public CharHashSet(CharContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public boolean add(char key) {
        char existing;
        if (key == '\u0000') {
            if (this.allocatedDefaultKey) {
                return false;
            }
            this.allocatedDefaultKey = true;
            return true;
        }
        int mask = this.keys.length - 1;
        char[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key == existing) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndAdd(key, slot);
        } else {
            ++this.assigned;
            keys[slot] = key;
        }
        return true;
    }

    public int add(char e1, char e2) {
        int count = 0;
        if (this.add(e1)) {
            ++count;
        }
        if (this.add(e2)) {
            ++count;
        }
        return count;
    }

    public int add(char ... elements) {
        int count = 0;
        for (char e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int addAll(CharContainer container) {
        return this.addAll((Iterable<? extends CharCursor>)container);
    }

    @Override
    public int addAll(Iterable<? extends CharCursor> iterable) {
        int count = 0;
        for (CharCursor charCursor : iterable) {
            if (!this.add(charCursor.value)) continue;
            ++count;
        }
        return count;
    }

    private void expandAndAdd(char pendingKey, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != '\u0000');
        char[] oldKeys = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        int mask = this.keys.length - 1;
        char key = '\u0000';
        int slot = -1;
        char[] keys = this.keys;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == '\u0000') continue;
            slot = BitMixer.mix(key, perturb) & mask;
            while (keys[slot] != '\u0000') {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            char[] keys = new char[capacity];
            this.keys = keys;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public int removeAll(char key) {
        return this.remove(key) ? 1 : 0;
    }

    @Override
    public boolean remove(char key) {
        char existing;
        if (key == '\u0000') {
            if (this.allocatedDefaultKey) {
                this.allocatedDefaultKey = false;
                return true;
            }
            return false;
        }
        int mask = this.keys.length - 1;
        char[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key == existing) {
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int slot;
        char existing;
        int mask = this.keys.length - 1;
        char[] keys = this.keys;
        int perturb = this.perturbation;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != '\u0000') {
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = '\u0000';
        --this.assigned;
    }

    @Override
    public boolean contains(char key) {
        char existing;
        if (key == '\u0000') {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        char[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        CharArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    public int hashCode() {
        int h = 0;
        char[] keys = this.keys;
        int i = keys.length;
        while (--i >= 0) {
            char existing = keys[i];
            if (existing == '\u0000') continue;
            h += BitMixer.mix(existing);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            CharSet other = (CharSet)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                if (other.contains(((CharCursor)it.next()).value)) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends CharProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply('\u0000');
        }
        char[] keys = this.keys;
        for (int i = keys.length - 1; i >= 0; --i) {
            char existing = keys[i];
            if (existing == '\u0000') continue;
            procedure.apply(existing);
        }
        return procedure;
    }

    @Override
    public char[] toArray(char[] target) {
        int count = 0;
        if (this.allocatedDefaultKey) {
            target[count++] = '\u0000';
        }
        char[] keys = this.keys;
        for (int i = 0; i < keys.length; ++i) {
            char existing = keys[i];
            if (existing == '\u0000') continue;
            target[count++] = existing;
        }
        assert (count == this.size());
        return target;
    }

    public CharHashSet clone() {
        CharHashSet cloned = new CharHashSet(this.size(), this.loadFactor);
        cloned.addAll(this);
        return cloned;
    }

    @Override
    public <T extends CharPredicate> T forEach(T predicate) {
        char existing;
        if (this.allocatedDefaultKey && !predicate.apply('\u0000')) {
            return predicate;
        }
        char[] keys = this.keys;
        for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == '\u0000' || predicate.apply(existing)); --i) {
        }
        return predicate;
    }

    @Override
    public int removeAll(CharPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply('\u0000')) {
            this.allocatedDefaultKey = false;
        }
        char[] keys = this.keys;
        int i = 0;
        while (i < keys.length) {
            char existing = keys[i];
            if (existing != '\u0000' && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    public static CharHashSet from(char ... elements) {
        CharHashSet set = new CharHashSet(elements.length);
        set.add(elements);
        return set;
    }

    public static CharHashSet from(CharContainer container) {
        return new CharHashSet(container);
    }

    public static CharHashSet newInstance() {
        return new CharHashSet();
    }

    public static CharHashSet newInstance(int initialCapacity, double loadFactor) {
        return new CharHashSet(initialCapacity, loadFactor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<CharCursor> {
        public final CharCursor cursor = new CharCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected CharCursor fetch() {
            int i;
            if (this.cursor.index == CharHashSet.this.keys.length + 1) {
                if (CharHashSet.this.allocatedDefaultKey) {
                    this.cursor.index = CharHashSet.this.keys.length;
                    this.cursor.value = '\u0000';
                    return this.cursor;
                }
                this.cursor.index = CharHashSet.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && CharHashSet.this.keys[i] == '\u0000'; --i) {
            }
            if (i == -1) {
                return (CharCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = CharHashSet.this.keys[i];
            return this.cursor;
        }
    }
}

