/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.sets;

import com.carrotsearch.hppcrt.AbstractByteCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.ByteArrays;
import com.carrotsearch.hppcrt.ByteContainer;
import com.carrotsearch.hppcrt.ByteLookupContainer;
import com.carrotsearch.hppcrt.ByteSet;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.ByteCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.BytePredicate;
import com.carrotsearch.hppcrt.procedures.ByteProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteHashSet
extends AbstractByteCollection
implements ByteLookupContainer,
ByteSet,
Cloneable {
    public byte[] keys;
    public boolean allocatedDefaultKey = false;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<ByteCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = ByteHashSet.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public ByteHashSet() {
        this(8, 0.75);
    }

    public ByteHashSet(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public ByteHashSet(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public ByteHashSet(ByteContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public boolean add(byte key) {
        byte existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                return false;
            }
            this.allocatedDefaultKey = true;
            return true;
        }
        int mask = this.keys.length - 1;
        byte[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndAdd(key, slot);
        } else {
            ++this.assigned;
            keys[slot] = key;
        }
        return true;
    }

    public int add(byte e1, byte e2) {
        int count = 0;
        if (this.add(e1)) {
            ++count;
        }
        if (this.add(e2)) {
            ++count;
        }
        return count;
    }

    public int add(byte ... elements) {
        int count = 0;
        for (byte e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int addAll(ByteContainer container) {
        return this.addAll((Iterable<? extends ByteCursor>)container);
    }

    @Override
    public int addAll(Iterable<? extends ByteCursor> iterable) {
        int count = 0;
        for (ByteCursor byteCursor : iterable) {
            if (!this.add(byteCursor.value)) continue;
            ++count;
        }
        return count;
    }

    private void expandAndAdd(byte pendingKey, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != 0);
        byte[] oldKeys = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        int mask = this.keys.length - 1;
        byte key = 0;
        int slot = -1;
        byte[] keys = this.keys;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == 0) continue;
            slot = BitMixer.mix(key, perturb) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            byte[] keys = new byte[capacity];
            this.keys = keys;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public int removeAll(byte key) {
        return this.remove(key) ? 1 : 0;
    }

    @Override
    public boolean remove(byte key) {
        byte existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                this.allocatedDefaultKey = false;
                return true;
            }
            return false;
        }
        int mask = this.keys.length - 1;
        byte[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int slot;
        byte existing;
        int mask = this.keys.length - 1;
        byte[] keys = this.keys;
        int perturb = this.perturbation;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0) {
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0;
        --this.assigned;
    }

    @Override
    public boolean contains(byte key) {
        byte existing;
        if (key == 0) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        byte[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        ByteArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    public int hashCode() {
        int h = 0;
        byte[] keys = this.keys;
        int i = keys.length;
        while (--i >= 0) {
            byte existing = keys[i];
            if (existing == 0) continue;
            h += BitMixer.mix(existing);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ByteSet other = (ByteSet)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                if (other.contains(((ByteCursor)it.next()).value)) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends ByteProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply((byte)0);
        }
        byte[] keys = this.keys;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte existing = keys[i];
            if (existing == 0) continue;
            procedure.apply(existing);
        }
        return procedure;
    }

    @Override
    public byte[] toArray(byte[] target) {
        int count = 0;
        if (this.allocatedDefaultKey) {
            target[count++] = 0;
        }
        byte[] keys = this.keys;
        for (int i = 0; i < keys.length; ++i) {
            byte existing = keys[i];
            if (existing == 0) continue;
            target[count++] = existing;
        }
        assert (count == this.size());
        return target;
    }

    public ByteHashSet clone() {
        ByteHashSet cloned = new ByteHashSet(this.size(), this.loadFactor);
        cloned.addAll(this);
        return cloned;
    }

    @Override
    public <T extends BytePredicate> T forEach(T predicate) {
        byte existing;
        if (this.allocatedDefaultKey && !predicate.apply((byte)0)) {
            return predicate;
        }
        byte[] keys = this.keys;
        for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == 0 || predicate.apply(existing)); --i) {
        }
        return predicate;
    }

    @Override
    public int removeAll(BytePredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply((byte)0)) {
            this.allocatedDefaultKey = false;
        }
        byte[] keys = this.keys;
        int i = 0;
        while (i < keys.length) {
            byte existing = keys[i];
            if (existing != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    public static ByteHashSet from(byte ... elements) {
        ByteHashSet set = new ByteHashSet(elements.length);
        set.add(elements);
        return set;
    }

    public static ByteHashSet from(ByteContainer container) {
        return new ByteHashSet(container);
    }

    public static ByteHashSet newInstance() {
        return new ByteHashSet();
    }

    public static ByteHashSet newInstance(int initialCapacity, double loadFactor) {
        return new ByteHashSet(initialCapacity, loadFactor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<ByteCursor> {
        public final ByteCursor cursor = new ByteCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ByteCursor fetch() {
            int i;
            if (this.cursor.index == ByteHashSet.this.keys.length + 1) {
                if (ByteHashSet.this.allocatedDefaultKey) {
                    this.cursor.index = ByteHashSet.this.keys.length;
                    this.cursor.value = 0;
                    return this.cursor;
                }
                this.cursor.index = ByteHashSet.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ByteHashSet.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (ByteCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ByteHashSet.this.keys[i];
            return this.cursor;
        }
    }
}

