/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.CharIndexedContainer;
import java.util.Arrays;

public final class CharArrays {
    public static final char[] EMPTY = new char[0];
    private static final int BLANK_ARRAY_SIZE_IN_BIT_SHIFT = 10;
    private static final int BLANK_ARRAY_SIZE = 1024;
    private static final char[] BLANKING_OBJECT_ARRAY = new char[1024];

    private CharArrays() {
    }

    public static void rotate(char[] table, int from, int mid, int to) {
        CharArrays.reverse(table, from, mid);
        CharArrays.reverse(table, mid, to);
        CharArrays.reverse(table, from, to);
    }

    public static void rotate(CharIndexedContainer table, int from, int mid, int to) {
        CharArrays.reverse(table, from, mid);
        CharArrays.reverse(table, mid, to);
        CharArrays.reverse(table, from, to);
    }

    public static void reverse(char[] table, int from, int to) {
        int halfSize = to - from >>> 1;
        for (int i = 0; i < halfSize; ++i) {
            char tmpValue = table[i + from];
            table[i + from] = table[to - i - 1];
            table[to - i - 1] = tmpValue;
        }
    }

    public static void reverse(CharIndexedContainer table, int from, int to) {
        int halfSize = to - from >>> 1;
        for (int i = 0; i < halfSize; ++i) {
            char tmpValue = table.get(i + from);
            table.set(i + from, table.get(to - i - 1));
            table.set(to - i - 1, tmpValue);
        }
    }

    public static void blankArray(char[] objectArray, int startIndex, int endIndex) {
        assert (startIndex <= endIndex);
        int size = endIndex - startIndex;
        int nbChunks = size >> 10;
        int rem = size & 0x3FF;
        for (int i = 0; i < nbChunks; ++i) {
            System.arraycopy(BLANKING_OBJECT_ARRAY, 0, objectArray, startIndex + (i << 10), 1024);
        }
        if (rem > 0) {
            Arrays.fill(objectArray, startIndex + (nbChunks << 10), startIndex + (nbChunks << 10) + rem, '\u0000');
        }
    }
}

