/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.IteratorPool;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIterator<E>
implements Iterator<E> {
    private static final int NOT_CACHED = 0;
    private static final int CACHED = 1;
    private static final int AT_END = 2;
    private int state = 0;
    private boolean isFree = true;
    private E nextElement;
    private IteratorPool<E, AbstractIterator<E>> iteratorPool = null;

    @Override
    public boolean hasNext() {
        if (this.state == 0) {
            this.state = 1;
            this.nextElement = this.fetch();
        }
        if (this.state == 2 && this.iteratorPool != null && !this.isFree) {
            this.iteratorPool.release(this);
            this.isFree = true;
        }
        return this.state == 1;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = 0;
        return this.nextElement;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract E fetch();

    protected final E done() {
        this.state = 2;
        return null;
    }

    final void setPool(IteratorPool<E, AbstractIterator<E>> pool) {
        this.iteratorPool = pool;
    }

    final void resetState() {
        this.state = 0;
    }

    final void setBorrowed() {
        this.isFree = false;
    }

    public final void release() {
        if (this.iteratorPool != null && !this.isFree) {
            this.iteratorPool.release(this);
            this.isFree = true;
        }
    }
}

