/*
 * Decompiled with CFR 0.152.
 */
package bov.vitali.smsinterceptor;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import bov.vitali.smsinterceptor.OnMessageListener;
import bov.vitali.smsinterceptor.SmsReceiver;

public class SmsInterceptor {
    private static final int REQUEST_CODE = 100;
    private static final String ACTION = "android.provider.Telephony.SMS_RECEIVED";
    private SmsReceiver smsReceiver;
    private OnMessageListener listener;
    private Activity activity;
    private Fragment fragment;
    private String[] phoneNumbers;
    private String regex;

    public SmsInterceptor(Activity activity, OnMessageListener listener) {
        this.activity = activity;
        this.listener = listener;
    }

    public SmsInterceptor(Activity activity, Fragment fragment, OnMessageListener listener) {
        this.activity = activity;
        this.listener = listener;
        this.fragment = fragment;
    }

    public void register() {
        if (this.isStoragePermissionGranted(this.activity, this.fragment)) {
            this.setupReceiver();
        }
    }

    public void unregister() {
        this.activity.unregisterReceiver((BroadcastReceiver)this.smsReceiver);
    }

    public void setPhoneNumber(String number) {
        this.phoneNumbers = new String[]{number};
    }

    public void setPhoneNumbers(String[] numbers) {
        this.phoneNumbers = numbers;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 100 && grantResults[0] == 0 && grantResults[1] == 0) {
            this.setupReceiver();
        }
    }

    private void setupReceiver() {
        this.smsReceiver = new SmsReceiver();
        this.smsReceiver.setPhoneNumbers(this.phoneNumbers);
        this.smsReceiver.setRegex(this.regex);
        SmsReceiver.bindListener(this.listener);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(ACTION);
        this.activity.registerReceiver((BroadcastReceiver)this.smsReceiver, intentFilter);
    }

    private boolean isStoragePermissionGranted(Activity activity, Fragment fragment) {
        if (Build.VERSION.SDK_INT >= 23) {
            if (ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.RECEIVE_SMS") == 0 && ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.READ_SMS") == 0) {
                return true;
            }
            if (fragment == null) {
                ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.RECEIVE_SMS", "android.permission.READ_SMS"}, (int)100);
            } else {
                fragment.requestPermissions(new String[]{"android.permission.RECEIVE_SMS", "android.permission.READ_SMS"}, 100);
            }
            return false;
        }
        return true;
    }
}

