/*
 * Decompiled with CFR 0.152.
 */
package com.github.vacxe.phonemask;

import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import com.github.vacxe.phonemask.PhoneMaskWatcher;
import com.github.vacxe.phonemask.Utils;
import com.github.vacxe.phonemask.ValueListener;

public class PhoneMaskManager {
    private String mask = null;
    private String region = "";
    private ValueListener valueListener = null;
    private View.OnFocusChangeListener onFocusChangeListener = null;
    private String maskSymbol = "#";
    private PhoneMaskWatcher phoneMaskWatcher = null;

    public PhoneMaskManager withMask(String mask) {
        this.mask = mask;
        return this;
    }

    public PhoneMaskManager withRegion(String region) {
        this.region = region;
        return this;
    }

    public PhoneMaskManager withValueListener(ValueListener valueListener) {
        this.valueListener = valueListener;
        return this;
    }

    public PhoneMaskManager withOnFocusChangeListener(View.OnFocusChangeListener onFocusChangeListener) {
        this.onFocusChangeListener = onFocusChangeListener;
        return this;
    }

    public PhoneMaskManager withMaskSymbol(String maskSymbol) {
        this.maskSymbol = maskSymbol;
        return this;
    }

    public String getPhone() {
        return this.phoneMaskWatcher.getPhone();
    }

    public PhoneMaskManager bindTo(final EditText editText) {
        if (this.mask == null) {
            Log.e((String)"PhoneMaskManager", (String)"Mask can't be null");
        } else {
            editText.setInputType(3);
            editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

                public void onFocusChange(View v, boolean hasFocus) {
                    if (hasFocus) {
                        if (editText.getText().toString().isEmpty()) {
                            editText.setText((CharSequence)PhoneMaskManager.this.region);
                        }
                    } else {
                        String region;
                        String input = Utils.notDigitRegex.matcher(editText.getText().toString()).replaceAll("");
                        if (input.equals(region = Utils.notDigitRegex.matcher(PhoneMaskManager.this.region).replaceAll(""))) {
                            editText.setText((CharSequence)"");
                        }
                    }
                    if (PhoneMaskManager.this.onFocusChangeListener != null) {
                        PhoneMaskManager.this.onFocusChangeListener.onFocusChange(v, hasFocus);
                    }
                }
            });
            this.phoneMaskWatcher = new PhoneMaskWatcher(this.mask, this.region, this.valueListener, this.maskSymbol);
            editText.addTextChangedListener((TextWatcher)this.phoneMaskWatcher);
        }
        return this;
    }
}

