/*
 * Decompiled with CFR 0.152.
 */
package com.github.vacxe.phonemask;

import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import com.github.vacxe.phonemask.PhoneMaskWatcher;
import com.github.vacxe.phonemask.ValueListener;

public class PhoneMaskManager {
    private String mask = null;
    private String region = "";
    private ValueListener valueListener = null;

    public PhoneMaskManager withMask(String mask) {
        this.mask = mask;
        return this;
    }

    public PhoneMaskManager withRegion(String region) {
        this.region = region;
        return this;
    }

    public PhoneMaskManager withValueListener(ValueListener valueListener) {
        this.valueListener = valueListener;
        return this;
    }

    public void bindTo(final EditText editText) {
        if (this.mask == null) {
            Log.e((String)"PhoneMaskManager", (String)"Mask can't be null");
        } else {
            editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

                public void onFocusChange(View v, boolean hasFocus) {
                    if (hasFocus && editText.getText().toString().isEmpty()) {
                        editText.setText((CharSequence)PhoneMaskManager.this.region);
                    }
                }
            });
            editText.addTextChangedListener((TextWatcher)new PhoneMaskWatcher(this.mask, this.region, this.valueListener));
        }
    }
}

