/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.configuration;

import com.ulisesbocchio.jasyptspringboot.encryptor.SimpleAsymmetricConfig;
import com.ulisesbocchio.jasyptspringboot.encryptor.SimpleAsymmetricStringEncryptor;
import com.ulisesbocchio.jasyptspringboot.encryptor.SimpleGCMConfig;
import com.ulisesbocchio.jasyptspringboot.encryptor.SimpleGCMStringEncryptor;
import com.ulisesbocchio.jasyptspringboot.properties.JasyptEncryptorConfigurationProperties;
import com.ulisesbocchio.jasyptspringboot.util.AsymmetricCryptography;
import java.util.function.Supplier;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.encryption.pbe.config.SimpleStringPBEConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringEncryptorBuilder {
    private static final Logger log = LoggerFactory.getLogger(StringEncryptorBuilder.class);
    private final JasyptEncryptorConfigurationProperties configProps;
    private final String propertyPrefix;

    public StringEncryptorBuilder(JasyptEncryptorConfigurationProperties configProps, String propertyPrefix) {
        this.configProps = configProps;
        this.propertyPrefix = propertyPrefix;
    }

    public StringEncryptor build() {
        if (this.isPBEConfig()) {
            return this.createPBEDefault();
        }
        if (this.isAsymmetricConfig()) {
            return this.createAsymmetricDefault();
        }
        if (this.isGCMConfig()) {
            return this.createGCMDefault();
        }
        throw new IllegalStateException("either '" + this.propertyPrefix + ".password', one of ['" + this.propertyPrefix + ".private-key-string', '" + this.propertyPrefix + ".private-key-location'] for asymmetric encryption, or one of ['" + this.propertyPrefix + ".gcm-secret-key-string', '" + this.propertyPrefix + ".gcm-secret-key-location', '" + this.propertyPrefix + ".gcm-secret-key-password'] for AES/GCM encryption must be provided for Password-based or Asymmetric encryption");
    }

    private boolean isGCMConfig() {
        return this.configProps.getGcmSecretKeyString() != null || this.configProps.getGcmSecretKeyLocation() != null || this.configProps.getGcmSecretKeyPassword() != null;
    }

    private boolean isPBEConfig() {
        return this.configProps.getPassword() != null;
    }

    private boolean isAsymmetricConfig() {
        return this.configProps.getPrivateKeyString() != null || this.configProps.getPrivateKeyLocation() != null || this.configProps.getPublicKeyString() != null || this.configProps.getPublicKeyLocation() != null;
    }

    private StringEncryptor createGCMDefault() {
        SimpleGCMConfig config = new SimpleGCMConfig();
        config.setSecretKey(this.get(this.configProps::getGcmSecretKeyString, this.propertyPrefix + ".gcm-secret-key-string", null));
        config.setSecretKeyLocation(this.get(this.configProps::getGcmSecretKeyLocation, this.propertyPrefix + ".gcm-secret-key-location", null));
        config.setSecretKeyPassword(this.get(this.configProps::getGcmSecretKeyPassword, this.propertyPrefix + ".gcm-key-password", null));
        config.setSecretKeySalt(this.get(this.configProps::getGcmSecretKeySalt, this.propertyPrefix + ".gcm-secret-key-salt", null));
        config.setSecretKeyAlgorithm(this.get(this.configProps::getGcmSecretKeyAlgorithm, this.propertyPrefix + ".gcm-secret-key-algorithm", "PBKDF2WithHmacSHA256"));
        config.setSecretKeyIterations(this.get(this.configProps::getKeyObtentionIterationsInt, this.propertyPrefix + ".key-obtention-iterations", 1000));
        config.setIvGeneratorClassName(this.get(this.configProps::getIvGeneratorClassname, this.propertyPrefix + ".iv-generator-classname", "org.jasypt.iv.RandomIvGenerator"));
        return new SimpleGCMStringEncryptor(config);
    }

    private StringEncryptor createAsymmetricDefault() {
        SimpleAsymmetricConfig config = new SimpleAsymmetricConfig();
        config.setPrivateKey(this.get(this.configProps::getPrivateKeyString, this.propertyPrefix + ".private-key-string", null));
        config.setPrivateKeyLocation(this.get(this.configProps::getPrivateKeyLocation, this.propertyPrefix + ".private-key-location", null));
        config.setPrivateKeyFormat(this.get(this.configProps::getPrivateKeyFormat, this.propertyPrefix + ".private-key-format", AsymmetricCryptography.KeyFormat.DER));
        config.setPublicKey(this.get(this.configProps::getPublicKeyString, this.propertyPrefix + ".public-key-string", null));
        config.setPublicKeyLocation(this.get(this.configProps::getPublicKeyLocation, this.propertyPrefix + ".public-key-location", null));
        config.setPublicKeyFormat(this.get(this.configProps::getPublicKeyFormat, this.propertyPrefix + ".public-key-format", AsymmetricCryptography.KeyFormat.DER));
        return new SimpleAsymmetricStringEncryptor(config);
    }

    private StringEncryptor createPBEDefault() {
        PooledPBEStringEncryptor encryptor = new PooledPBEStringEncryptor();
        SimpleStringPBEConfig config = new SimpleStringPBEConfig();
        config.setPassword(this.getRequired(this.configProps::getPassword, this.propertyPrefix + ".password"));
        config.setAlgorithm(this.get(this.configProps::getAlgorithm, this.propertyPrefix + ".algorithm", "PBEWITHHMACSHA512ANDAES_256"));
        config.setKeyObtentionIterations(this.get(this.configProps::getKeyObtentionIterations, this.propertyPrefix + ".key-obtention-iterations", "1000"));
        config.setPoolSize(this.get(this.configProps::getPoolSize, this.propertyPrefix + ".pool-size", "1"));
        config.setProviderName((String)this.get(this.configProps::getProviderName, this.propertyPrefix + ".provider-name", null));
        config.setProviderClassName((String)this.get(this.configProps::getProviderClassName, this.propertyPrefix + ".provider-class-name", null));
        config.setSaltGeneratorClassName(this.get(this.configProps::getSaltGeneratorClassname, this.propertyPrefix + ".salt-generator-classname", "org.jasypt.salt.RandomSaltGenerator"));
        config.setIvGeneratorClassName(this.get(this.configProps::getIvGeneratorClassname, this.propertyPrefix + ".iv-generator-classname", "org.jasypt.iv.RandomIvGenerator"));
        config.setStringOutputType(this.get(this.configProps::getStringOutputType, this.propertyPrefix + ".string-output-type", "base64"));
        encryptor.setConfig((PBEConfig)config);
        return encryptor;
    }

    private <T> T getRequired(Supplier<T> supplier, String key) {
        T value = supplier.get();
        if (value == null) {
            throw new IllegalStateException(String.format("Required Encryption configuration property missing: %s", key));
        }
        return value;
    }

    private <T> T get(Supplier<T> supplier, String key, T defaultValue) {
        T value = supplier.get();
        if (value == defaultValue) {
            log.info("Encryptor config not found for property {}, using default value: {}", (Object)key, value);
        }
        return value;
    }
}

