/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.microedition.khronos.egl.EGLSurface;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006J\u000e\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0006J\u0018\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0006H\u0002J\u0006\u0010&\u001a\u00020\u001fJ\u000e\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020\u0004J\u0018\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u0006H\u0002J\u0006\u0010.\u001a\u00020\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/github/triniwiz/canvas/TextureRender;", "", "()V", "FLOAT_SIZE_BYTES", "", "FRAGMENT_SHADER", "", "TAG", "TRIANGLE_VERTICES_DATA_POS_OFFSET", "TRIANGLE_VERTICES_DATA_STRIDE_BYTES", "TRIANGLE_VERTICES_DATA_UV_OFFSET", "VERTEX_SHADER", "eglSurface", "Ljavax/microedition/khronos/egl/EGLSurface;", "getEglSurface$canvas_release", "()Ljavax/microedition/khronos/egl/EGLSurface;", "setEglSurface$canvas_release", "(Ljavax/microedition/khronos/egl/EGLSurface;)V", "mMVPMatrix", "", "mProgram", "mSTMatrix", "mTextureID", "mTriangleVertices", "Ljava/nio/FloatBuffer;", "mTriangleVerticesData", "maPositionHandle", "maTextureHandle", "muMVPMatrixHandle", "muSTMatrixHandle", "changeFragmentShader", "", "fragmentShader", "checkGlError", "op", "createProgram", "vertexSource", "fragmentSource", "createTexture", "drawFrame", "st", "Landroid/graphics/SurfaceTexture;", "getTextureId", "loadShader", "shaderType", "source", "surfaceCreated", "canvas_release"})
public final class TextureRender {
    private final String TAG;
    private final int FLOAT_SIZE_BYTES;
    private final int TRIANGLE_VERTICES_DATA_STRIDE_BYTES;
    private final int TRIANGLE_VERTICES_DATA_POS_OFFSET;
    private final int TRIANGLE_VERTICES_DATA_UV_OFFSET;
    private final float[] mTriangleVerticesData;
    private FloatBuffer mTriangleVertices;
    private final String VERTEX_SHADER;
    private final String FRAGMENT_SHADER;
    private final float[] mMVPMatrix;
    private final float[] mSTMatrix;
    private int mProgram;
    private int mTextureID;
    private int muMVPMatrixHandle;
    private int muSTMatrixHandle;
    private int maPositionHandle;
    private int maTextureHandle;
    @Nullable
    private EGLSurface eglSurface;

    @Nullable
    public final EGLSurface getEglSurface$canvas_release() {
        return this.eglSurface;
    }

    public final void setEglSurface$canvas_release(@Nullable EGLSurface eGLSurface) {
        this.eglSurface = eGLSurface;
    }

    public final int getTextureId() {
        return this.mTextureID;
    }

    public final void drawFrame(@NotNull SurfaceTexture st) {
        Intrinsics.checkNotNullParameter((Object)st, (String)"st");
        this.checkGlError("onDrawFrame start");
        st.getTransformMatrix(this.mSTMatrix);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16640);
        GLES20.glUseProgram((int)this.mProgram);
        this.checkGlError("glUseProgram");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)this.mTextureID);
        this.mTriangleVertices.position(this.TRIANGLE_VERTICES_DATA_POS_OFFSET);
        GLES20.glVertexAttribPointer((int)this.maPositionHandle, (int)3, (int)5126, (boolean)false, (int)this.TRIANGLE_VERTICES_DATA_STRIDE_BYTES, (Buffer)this.mTriangleVertices);
        this.checkGlError("glVertexAttribPointer maPosition");
        GLES20.glEnableVertexAttribArray((int)this.maPositionHandle);
        this.checkGlError("glEnableVertexAttribArray maPositionHandle");
        this.mTriangleVertices.position(this.TRIANGLE_VERTICES_DATA_UV_OFFSET);
        GLES20.glVertexAttribPointer((int)this.maTextureHandle, (int)3, (int)5126, (boolean)false, (int)this.TRIANGLE_VERTICES_DATA_STRIDE_BYTES, (Buffer)this.mTriangleVertices);
        this.checkGlError("glVertexAttribPointer maTextureHandle");
        GLES20.glEnableVertexAttribArray((int)this.maTextureHandle);
        this.checkGlError("glEnableVertexAttribArray maTextureHandle");
        Matrix.setIdentityM((float[])this.mMVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.muMVPMatrixHandle, (int)1, (boolean)false, (float[])this.mMVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.muSTMatrixHandle, (int)1, (boolean)false, (float[])this.mSTMatrix, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.checkGlError("glDrawArrays");
        GLES20.glFinish();
    }

    public final void createTexture() {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        this.mTextureID = textures[0];
    }

    public final void surfaceCreated() {
        this.mProgram = this.createProgram(this.VERTEX_SHADER, this.FRAGMENT_SHADER);
        if (this.mProgram == 0) {
            throw (Throwable)new RuntimeException("failed creating program");
        }
        this.maPositionHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aPosition");
        this.checkGlError("glGetAttribLocation aPosition");
        if (this.maPositionHandle == -1) {
            throw (Throwable)new RuntimeException("Could not get attrib location for aPosition");
        }
        this.maTextureHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aTextureCoord");
        this.checkGlError("glGetAttribLocation aTextureCoord");
        if (this.maTextureHandle == -1) {
            throw (Throwable)new RuntimeException("Could not get attrib location for aTextureCoord");
        }
        this.muMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uMVPMatrix");
        this.checkGlError("glGetUniformLocation uMVPMatrix");
        if (this.muMVPMatrixHandle == -1) {
            throw (Throwable)new RuntimeException("Could not get attrib location for uMVPMatrix");
        }
        this.muSTMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uSTMatrix");
        this.checkGlError("glGetUniformLocation uSTMatrix");
        if (this.muSTMatrixHandle == -1) {
            throw (Throwable)new RuntimeException("Could not get attrib location for uSTMatrix");
        }
        if (this.mTextureID == -12345) {
            this.createTexture();
        }
        GLES20.glBindTexture((int)36197, (int)this.mTextureID);
        this.checkGlError("glBindTexture mTextureID");
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9728);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        this.checkGlError("glTexParameter");
    }

    public final void changeFragmentShader(@NotNull String fragmentShader) {
        Intrinsics.checkNotNullParameter((Object)fragmentShader, (String)"fragmentShader");
        GLES20.glDeleteProgram((int)this.mProgram);
        this.mProgram = this.createProgram(this.VERTEX_SHADER, fragmentShader);
        if (this.mProgram == 0) {
            throw (Throwable)new RuntimeException("failed creating program");
        }
    }

    private final int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        this.checkGlError("glCreateShader type=" + shaderType);
        GLES20.glShaderSource((int)shader, (String)source);
        GLES20.glCompileShader((int)shader);
        int[] compiled = new int[1];
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
        if (compiled[0] == 0) {
            Log.e((String)this.TAG, (String)("Could not compile shader " + shaderType + ':'));
            Log.e((String)this.TAG, (String)(" " + GLES20.glGetShaderInfoLog((int)shader)));
            GLES20.glDeleteShader((int)shader);
            shader = 0;
        }
        return shader;
    }

    private final int createProgram(String vertexSource, String fragmentSource) {
        int vertexShader = this.loadShader(35633, vertexSource);
        if (vertexShader == 0) {
            return 0;
        }
        int pixelShader = this.loadShader(35632, fragmentSource);
        if (pixelShader == 0) {
            return 0;
        }
        int program = GLES20.glCreateProgram();
        this.checkGlError("glCreateProgram");
        if (program == 0) {
            Log.e((String)this.TAG, (String)"Could not create program");
        }
        GLES20.glAttachShader((int)program, (int)vertexShader);
        this.checkGlError("glAttachShader");
        GLES20.glAttachShader((int)program, (int)pixelShader);
        this.checkGlError("glAttachShader");
        GLES20.glLinkProgram((int)program);
        int[] linkStatus = new int[1];
        GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
        if (linkStatus[0] != 1) {
            Log.e((String)this.TAG, (String)"Could not link program: ");
            Log.e((String)this.TAG, (String)GLES20.glGetProgramInfoLog((int)program));
            GLES20.glDeleteProgram((int)program);
            program = 0;
        }
        return program;
    }

    public final void checkGlError(@NotNull String op) {
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        int error2 = 0;
        int n = GLES20.glGetError();
        boolean bl = false;
        boolean bl2 = false;
        int it = n;
        boolean bl3 = false;
        error2 = it;
        if (n != 0) {
            Log.e((String)this.TAG, (String)(op + ": glError " + error2));
            throw (Throwable)new RuntimeException(op + ": glError " + error2);
        }
    }

    public TextureRender() {
        this.TAG = "TextureRender";
        this.FLOAT_SIZE_BYTES = 4;
        this.TRIANGLE_VERTICES_DATA_STRIDE_BYTES = 5 * this.FLOAT_SIZE_BYTES;
        this.TRIANGLE_VERTICES_DATA_UV_OFFSET = 3;
        this.mTriangleVerticesData = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
        this.VERTEX_SHADER = "uniform mat4 uMVPMatrix;\nuniform mat4 uSTMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n  gl_Position = uMVPMatrix * aPosition;\n  vTextureCoord = (uSTMatrix * aTextureCoord).xy;\n}\n";
        this.FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nvoid main() {\n  gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
        this.mMVPMatrix = new float[16];
        this.mSTMatrix = new float[16];
        this.mTextureID = -12345;
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(this.mTriangleVerticesData.length * this.FLOAT_SIZE_BYTES).order(ByteOrder.nativeOrder()).asFloatBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)floatBuffer, (String)"ByteBuffer.allocateDirec\u2026eOrder()).asFloatBuffer()");
        this.mTriangleVertices = floatBuffer;
        FloatBuffer floatBuffer2 = this.mTriangleVertices.put(this.mTriangleVerticesData);
        if (floatBuffer2 != null) {
            floatBuffer2.position(0);
        }
        Matrix.setIdentityM((float[])this.mSTMatrix, (int)0);
    }
}

