/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.annotation.SuppressLint;
import android.content.res.Resources;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLDisplay;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.github.triniwiz.canvas.GLView;
import com.github.triniwiz.canvas.TNSCanvas;
import com.github.triniwiz.canvas.Utils;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import javax.microedition.khronos.egl.EGL;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLSurface;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0012\b\u0000\u0018\u0000 Z2\u00020\u0001:\u0002Z[B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010E\u001a\u00020#2\u0006\u0010F\u001a\u00020\u0001J\u001a\u0010G\u001a\u00020#2\b\u0010H\u001a\u0004\u0018\u00010\u001d2\b\u0010F\u001a\u0004\u0018\u00010\u0001J\u0006\u0010I\u001a\u00020JJ\u0010\u0010K\u001a\u00020\u00042\b\u0010F\u001a\u0004\u0018\u00010#J\u0006\u0010L\u001a\u00020JJ\u0010\u0010M\u001a\u00020J2\b\u0010N\u001a\u0004\u0018\u00010\u0001J\u0010\u0010O\u001a\u00020\u00042\b\u0010F\u001a\u0004\u0018\u00010#J\u000e\u0010P\u001a\u00020J2\u0006\u0010F\u001a\u00020#J\u0006\u0010Q\u001a\u00020JJ\u0006\u0010R\u001a\u00020JJ\u000e\u0010S\u001a\u00020J2\u0006\u0010T\u001a\u00020,J\u0016\u0010U\u001a\u00020J2\u0006\u0010V\u001a\u00020A2\u0006\u0010W\u001a\u00020AJ\u0006\u0010X\u001a\u00020JJ\u0010\u0010Y\u001a\u00020\u00042\b\u0010F\u001a\u0004\u0018\u00010#R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u001a\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0006R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0018\u0010(\u001a\b\u0018\u00010)R\u00020\u00008\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00105\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0006\"\u0004\b7\u0010\bR\u001a\u00108\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u0006\"\u0004\b:\u0010\bR\u001a\u0010;\u001a\n\u0012\u0004\u0012\u00020<\u0018\u00010\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010=\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u0006\"\u0004\b?\u0010\bR\u000e\u0010@\u001a\u00020AX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010B\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\u0006\"\u0004\bD\u0010\b\u00a8\u0006\\"}, d2={"Lcom/github/triniwiz/canvas/GLContext;", "", "()V", "alpha", "", "getAlpha", "()Z", "setAlpha", "(Z)V", "antialias", "getAntialias", "setAntialias", "depth", "getDepth", "setDepth", "desynchronized", "getDesynchronized", "setDesynchronized", "failIfMajorPerformanceCaveat", "getFailIfMajorPerformanceCaveat", "setFailIfMajorPerformanceCaveat", "glView", "Ljava/lang/ref/WeakReference;", "Lcom/github/triniwiz/canvas/GLView;", "isGLThreadStarted", "isHeadless", "mEGL", "Ljavax/microedition/khronos/egl/EGL10;", "mEGLConfig", "Ljavax/microedition/khronos/egl/EGLConfig;", "mEGLContext", "Ljavax/microedition/khronos/egl/EGLContext;", "mEGLDisplay", "Ljavax/microedition/khronos/egl/EGLDisplay;", "mEGLSurface", "Ljavax/microedition/khronos/egl/EGLSurface;", "getMEGLSurface$canvas_release", "()Ljavax/microedition/khronos/egl/EGLSurface;", "setMEGLSurface$canvas_release", "(Ljavax/microedition/khronos/egl/EGLSurface;)V", "mGLThread", "Lcom/github/triniwiz/canvas/GLContext$GLThread;", "mQueue", "Ljava/util/concurrent/BlockingQueue;", "Ljava/lang/Runnable;", "offscreenTexture", "Landroid/graphics/SurfaceTexture;", "powerPreference", "", "getPowerPreference", "()Ljava/lang/String;", "setPowerPreference", "(Ljava/lang/String;)V", "premultipliedAlpha", "getPremultipliedAlpha", "setPremultipliedAlpha", "preserveDrawingBuffer", "getPreserveDrawingBuffer", "setPreserveDrawingBuffer", "reference", "Lcom/github/triniwiz/canvas/TNSCanvas;", "stencil", "getStencil", "setStencil", "textureId", "", "xrCompatible", "getXrCompatible", "setXrCompatible", "createEglSurface", "surface", "createSurface", "config", "destroy", "", "destroySurface", "flush", "init", "texture", "makeCurrent", "makeEglSurfaceCurrent", "onPause", "onResume", "queueEvent", "runnable", "resize", "width", "height", "startGLThread", "swapBuffers", "Companion", "GLThread", "canvas_release"})
public final class GLContext {
    @JvmField
    @Nullable
    public WeakReference<GLView> glView;
    private final BlockingQueue<Runnable> mQueue = new LinkedBlockingQueue();
    @JvmField
    @Nullable
    public GLThread mGLThread;
    private javax.microedition.khronos.egl.EGLDisplay mEGLDisplay;
    @Nullable
    private EGLSurface mEGLSurface;
    private SurfaceTexture offscreenTexture;
    private int textureId;
    private EGLContext mEGLContext;
    private EGLConfig mEGLConfig;
    private EGL10 mEGL;
    private boolean alpha = true;
    private boolean antialias = true;
    private boolean depth = true;
    private boolean failIfMajorPerformanceCaveat;
    @NotNull
    private String powerPreference = "default";
    private boolean premultipliedAlpha = true;
    private boolean preserveDrawingBuffer;
    private boolean stencil;
    private boolean desynchronized;
    private boolean xrCompatible;
    @JvmField
    @Nullable
    public WeakReference<TNSCanvas> reference;
    @NotNull
    public static final String TAG = "GLContext";
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private static final int EGL_CONTEXT_CLIENT_MINOR_VERSION = 12539;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final EGLSurface getMEGLSurface$canvas_release() {
        return this.mEGLSurface;
    }

    public final void setMEGLSurface$canvas_release(@Nullable EGLSurface eGLSurface) {
        this.mEGLSurface = eGLSurface;
    }

    public final boolean getAlpha() {
        return this.alpha;
    }

    public final void setAlpha(boolean bl) {
        this.alpha = bl;
    }

    public final boolean getAntialias() {
        return this.antialias;
    }

    public final void setAntialias(boolean bl) {
        this.antialias = bl;
    }

    public final boolean getDepth() {
        return this.depth;
    }

    public final void setDepth(boolean bl) {
        this.depth = bl;
    }

    public final boolean getFailIfMajorPerformanceCaveat() {
        return this.failIfMajorPerformanceCaveat;
    }

    public final void setFailIfMajorPerformanceCaveat(boolean bl) {
        this.failIfMajorPerformanceCaveat = bl;
    }

    @NotNull
    public final String getPowerPreference() {
        return this.powerPreference;
    }

    public final void setPowerPreference(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.powerPreference = string;
    }

    public final boolean getPremultipliedAlpha() {
        return this.premultipliedAlpha;
    }

    public final void setPremultipliedAlpha(boolean bl) {
        this.premultipliedAlpha = bl;
    }

    public final boolean getPreserveDrawingBuffer() {
        return this.preserveDrawingBuffer;
    }

    public final void setPreserveDrawingBuffer(boolean bl) {
        this.preserveDrawingBuffer = bl;
    }

    public final boolean getStencil() {
        return this.stencil;
    }

    public final void setStencil(boolean bl) {
        this.stencil = bl;
    }

    public final boolean getDesynchronized() {
        return this.desynchronized;
    }

    public final void setDesynchronized(boolean bl) {
        this.desynchronized = bl;
    }

    public final boolean getXrCompatible() {
        return this.xrCompatible;
    }

    public final void setXrCompatible(boolean bl) {
        this.xrCompatible = bl;
    }

    public final boolean isHeadless() {
        boolean bl;
        if (this.mGLThread != null) {
            GLThread gLThread = this.mGLThread;
            Intrinsics.checkNotNull((Object)gLThread);
            bl = gLThread.getMSurface() == null;
        } else {
            bl = true;
        }
        return bl;
    }

    public final void queueEvent(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.mQueue.add(runnable);
    }

    public final void init(@Nullable Object texture) {
        if (this.mGLThread != null) {
            return;
        }
        GLThread gLThread = this.mGLThread = new GLThread(texture);
        Intrinsics.checkNotNull((Object)gLThread);
        gLThread.setPriority(10);
    }

    public final void startGLThread() {
        GLThread gLThread = this.mGLThread;
        Intrinsics.checkNotNull((Object)gLThread);
        gLThread.start();
    }

    public final void resize(int width, int height) {
        if (this.reference != null) {
            WeakReference<TNSCanvas> weakReference = this.reference;
            Intrinsics.checkNotNull(weakReference);
            TNSCanvas canvasView = (TNSCanvas)((Object)weakReference.get());
            if (canvasView != null) {
                this.queueEvent(new Runnable(this, width, height, canvasView){
                    final /* synthetic */ GLContext this$0;
                    final /* synthetic */ int $width;
                    final /* synthetic */ int $height;
                    final /* synthetic */ TNSCanvas $canvasView;

                    public final void run() {
                        if (GLContext.access$getOffscreenTexture$p(this.this$0) != null) {
                            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                            GLES20.glClear((int)16384);
                            if (!this.this$0.swapBuffers(this.this$0.getMEGLSurface$canvas_release())) {
                                Log.e((String)"GLContext", (String)"Cannot swap buffers!");
                            }
                            SurfaceTexture surfaceTexture = GLContext.access$getOffscreenTexture$p(this.this$0);
                            Intrinsics.checkNotNull((Object)surfaceTexture);
                            surfaceTexture.release();
                            GLContext.access$setOffscreenTexture$p(this.this$0, null);
                            GLContext gLContext = this.this$0;
                            GLContext.access$setTextureId$p(gLContext, GLContext.access$getTextureId$p(gLContext) + 1);
                            GLContext.access$setOffscreenTexture$p(this.this$0, new SurfaceTexture(GLContext.access$getTextureId$p(this.this$0)));
                            SurfaceTexture surfaceTexture2 = GLContext.access$getOffscreenTexture$p(this.this$0);
                            Intrinsics.checkNotNull((Object)surfaceTexture2);
                            surfaceTexture2.setDefaultBufferSize(this.$width, this.$height);
                            GLThread gLThread = this.this$0.mGLThread;
                            Intrinsics.checkNotNull((Object)gLThread);
                            gLThread.setMSurface(GLContext.access$getOffscreenTexture$p(this.this$0));
                            this.this$0.setMEGLSurface$canvas_release(this.this$0.createSurface(GLContext.access$getMEGLConfig$p(this.this$0), GLContext.access$getOffscreenTexture$p(this.this$0)));
                            if (this.this$0.getMEGLSurface$canvas_release() == null || this.this$0.getMEGLSurface$canvas_release() == EGL10.EGL_NO_SURFACE) {
                                EGL10 eGL10 = GLContext.access$getMEGL$p(this.this$0);
                                Intrinsics.checkNotNull((Object)eGL10);
                                int error2 = eGL10.eglGetError();
                                throw (Throwable)new RuntimeException("eglCreateWindowSurface failed " + GLUtils.getEGLErrorString((int)error2));
                            }
                            if (this.$canvasView.getNativeContext$canvas_release() > 0L) {
                                int[] frameBuffers = new int[1];
                                GLES20.glGetIntegerv((int)36006, (int[])frameBuffers, (int)0);
                                int samples = 0;
                                if (this.$canvasView.contextAntialias) {
                                    samples = 4;
                                }
                                Resources resources = this.$canvasView.getResources();
                                Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"canvasView.resources");
                                DisplayMetrics metrics = resources.getDisplayMetrics();
                                TNSCanvas.Companion.nativeResizeSurface(this.$canvasView.getNativeContext$canvas_release(), this.$canvasView.getDrawingBufferWidth(), this.$canvasView.getDrawingBufferHeight(), this.$canvasView.getScale$canvas_release(), frameBuffers[0], samples, true, metrics.density);
                                GLES20.glViewport((int)0, (int)0, (int)this.$width, (int)this.$height);
                            }
                        } else {
                            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                            GLES20.glClear((int)16384);
                            if (!this.this$0.swapBuffers(this.this$0.getMEGLSurface$canvas_release())) {
                                Log.e((String)"GLContext", (String)"Cannot swap buffers!");
                            }
                            if (this.$canvasView.getNativeContext$canvas_release() > 0L) {
                                GLES20.glViewport((int)0, (int)0, (int)this.$width, (int)this.$height);
                                int[] frameBuffers = new int[1];
                                GLES20.glGetIntegerv((int)36006, (int[])frameBuffers, (int)0);
                                int samples = 0;
                                if (this.$canvasView.contextAntialias) {
                                    samples = 4;
                                }
                                Resources resources = this.$canvasView.getResources();
                                Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"canvasView.resources");
                                DisplayMetrics metrics = resources.getDisplayMetrics();
                                TNSCanvas.Companion.nativeResizeSurface(this.$canvasView.getNativeContext$canvas_release(), this.$canvasView.getDrawingBufferWidth(), this.$canvasView.getDrawingBufferHeight(), this.$canvasView.getScale$canvas_release(), frameBuffers[0], samples, true, metrics.density);
                            }
                        }
                    }
                    {
                        this.this$0 = gLContext;
                        this.$width = n;
                        this.$height = n2;
                        this.$canvasView = tNSCanvas;
                    }
                });
            }
        }
    }

    public final void flush() {
        this.queueEvent(new Runnable(this){
            final /* synthetic */ GLContext this$0;

            public final void run() {
                if (this.this$0.reference != null) {
                    WeakReference<TNSCanvas> weakReference = this.this$0.reference;
                    Intrinsics.checkNotNull(weakReference);
                    TNSCanvas canvasView = (TNSCanvas)((Object)weakReference.get());
                    if (canvasView != null && canvasView.getNativeContext$canvas_release() != 0L && canvasView.pendingInvalidate) {
                        TNSCanvas.Companion.nativeFlush(canvasView.getNativeContext$canvas_release());
                        if (!this.this$0.swapBuffers(this.this$0.getMEGLSurface$canvas_release())) {
                            Log.e((String)"GLContext", (String)"Cannot swap buffers!");
                        }
                        canvasView.pendingInvalidate = false;
                    } else {
                        if (!this.this$0.swapBuffers(this.this$0.getMEGLSurface$canvas_release())) {
                            Log.e((String)"GLContext", (String)"Cannot swap buffers!");
                        }
                        if (canvasView != null) {
                            canvasView.pendingInvalidate = false;
                        }
                    }
                }
            }
            {
                this.this$0 = gLContext;
            }
        });
    }

    @NotNull
    public final EGLSurface createEglSurface(@NotNull Object surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        int[] surfaceAttribs = new int[]{12344};
        EGL10 eGL10 = this.mEGL;
        Intrinsics.checkNotNull((Object)eGL10);
        EGLSurface eGLSurface = eGL10.eglCreateWindowSurface(this.mEGLDisplay, this.mEGLConfig, surface, surfaceAttribs);
        Intrinsics.checkNotNullExpressionValue((Object)eGLSurface, (String)"mEGL!!.eglCreateWindowSu\u2026 surface, surfaceAttribs)");
        return eGLSurface;
    }

    public final void makeEglSurfaceCurrent(@NotNull EGLSurface surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        EGL10 eGL10 = this.mEGL;
        Intrinsics.checkNotNull((Object)eGL10);
        eGL10.eglMakeCurrent(this.mEGLDisplay, surface, surface, this.mEGLContext);
    }

    @NotNull
    public final EGLSurface createSurface(@Nullable EGLConfig config, @Nullable Object surface) {
        if (surface == null) {
            int width = 1;
            int height = 1;
            if (this.reference != null) {
                WeakReference<TNSCanvas> weakReference = this.reference;
                Intrinsics.checkNotNull(weakReference);
                TNSCanvas view = (TNSCanvas)((Object)weakReference.get());
                if (view != null) {
                    width = view.getWidth();
                    height = view.getHeight();
                }
                if (width == 0) {
                    width = 1;
                }
                if (height == 0) {
                    height = 1;
                }
            }
            int[] surfaceAttribs = new int[]{12375, width, 12374, height, 12344};
            ++this.textureId;
            SurfaceTexture surfaceTexture = this.offscreenTexture = new SurfaceTexture(this.textureId);
            Intrinsics.checkNotNull((Object)surfaceTexture);
            surfaceTexture.setDefaultBufferSize(width, height);
            EGL10 eGL10 = this.mEGL;
            Intrinsics.checkNotNull((Object)eGL10);
            EGLSurface eGLSurface = eGL10.eglCreateWindowSurface(this.mEGLDisplay, config, (Object)this.offscreenTexture, null);
            Intrinsics.checkNotNullExpressionValue((Object)eGLSurface, (String)"mEGL!!.eglCreateWindowSu\u2026, offscreenTexture, null)");
            return eGLSurface;
        }
        EGL10 eGL10 = this.mEGL;
        Intrinsics.checkNotNull((Object)eGL10);
        EGLSurface eGLSurface = eGL10.eglCreateWindowSurface(this.mEGLDisplay, config, surface, null);
        Intrinsics.checkNotNullExpressionValue((Object)eGLSurface, (String)"mEGL!!.eglCreateWindowSu\u2026y, config, surface, null)");
        return eGLSurface;
    }

    public final void onPause() {
        this.queueEvent(new Runnable(this){
            final /* synthetic */ GLContext this$0;

            public final void run() {
                if (GLContext.access$getMEGL$p(this.this$0) != null) {
                    EGL10 eGL10 = GLContext.access$getMEGL$p(this.this$0);
                    Intrinsics.checkNotNull((Object)eGL10);
                    eGL10.eglMakeCurrent(GLContext.access$getMEGLDisplay$p(this.this$0), EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                }
                if (this.this$0.mGLThread != null) {
                    GLThread gLThread = this.this$0.mGLThread;
                    Intrinsics.checkNotNull((Object)gLThread);
                    gLThread.setPaused(false);
                }
            }
            {
                this.this$0 = gLContext;
            }
        });
    }

    public final void onResume() {
        this.queueEvent(new Runnable(this){
            final /* synthetic */ GLContext this$0;

            public final void run() {
                if (this.this$0.mGLThread != null) {
                    GLThread gLThread = this.this$0.mGLThread;
                    Intrinsics.checkNotNull((Object)gLThread);
                    gLThread.setPaused(false);
                }
            }
            {
                this.this$0 = gLContext;
            }
        });
    }

    public final boolean makeCurrent(@Nullable EGLSurface surface) {
        EGL10 eGL10 = this.mEGL;
        Intrinsics.checkNotNull((Object)eGL10);
        return eGL10.eglMakeCurrent(this.mEGLDisplay, surface, surface, this.mEGLContext);
    }

    public final boolean destroySurface(@Nullable EGLSurface surface) {
        EGL10 eGL10 = this.mEGL;
        Intrinsics.checkNotNull((Object)eGL10);
        return eGL10.eglDestroySurface(this.mEGLDisplay, surface);
    }

    public final boolean swapBuffers(@Nullable EGLSurface surface) {
        EGL10 eGL10 = this.mEGL;
        Intrinsics.checkNotNull((Object)eGL10);
        return eGL10.eglSwapBuffers(this.mEGLDisplay, surface);
    }

    public final boolean isGLThreadStarted() {
        boolean bl;
        if (this.mGLThread == null) {
            bl = false;
        } else {
            GLThread gLThread = this.mGLThread;
            Intrinsics.checkNotNull((Object)gLThread);
            bl = gLThread.isStarted;
        }
        return bl;
    }

    public final void destroy() {
        if (this.mGLThread != null) {
            try {
                GLThread gLThread = this.mGLThread;
                Intrinsics.checkNotNull((Object)gLThread);
                gLThread.interrupt();
                GLThread gLThread2 = this.mGLThread;
                Intrinsics.checkNotNull((Object)gLThread2);
                gLThread2.join();
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)"Can't interrupt GL thread.", (Throwable)e);
            }
            this.mGLThread = null;
        }
    }

    public static final /* synthetic */ SurfaceTexture access$getOffscreenTexture$p(GLContext $this) {
        return $this.offscreenTexture;
    }

    public static final /* synthetic */ void access$setOffscreenTexture$p(GLContext $this, SurfaceTexture surfaceTexture) {
        $this.offscreenTexture = surfaceTexture;
    }

    public static final /* synthetic */ int access$getTextureId$p(GLContext $this) {
        return $this.textureId;
    }

    public static final /* synthetic */ void access$setTextureId$p(GLContext $this, int n) {
        $this.textureId = n;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0003J\b\u0010\u001e\u001a\u00020\u001cH\u0016J\b\u0010\u001f\u001a\u00020\u001cH\u0002J\b\u0010 \u001a\u00020\u001cH\u0016J\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0007J\b\u0010#\u001a\u00020\u001cH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lcom/github/triniwiz/canvas/GLContext$GLThread;", "Ljava/lang/Thread;", "(Lcom/github/triniwiz/canvas/GLContext;)V", "texture", "", "(Lcom/github/triniwiz/canvas/GLContext;Ljava/lang/Object;)V", "isPaused", "", "isStarted", "mSurface", "getMSurface", "()Ljava/lang/Object;", "setMSurface", "(Ljava/lang/Object;)V", "type", "Lcom/github/triniwiz/canvas/TNSCanvas$ContextType;", "getType", "()Lcom/github/triniwiz/canvas/TNSCanvas$ContextType;", "setType", "(Lcom/github/triniwiz/canvas/TNSCanvas$ContextType;)V", "createGLContext", "Ljavax/microedition/khronos/egl/EGLContext;", "contextVersion", "", "minorVersion", "eglConfig", "Ljavax/microedition/khronos/egl/EGLConfig;", "deInitEGL", "", "initEGL", "interrupt", "makeEGLContextCurrent", "run", "setPaused", "paused", "start", "canvas_release"})
    public final class GLThread
    extends Thread {
        @JvmField
        public boolean isStarted;
        private boolean isPaused;
        @NotNull
        private TNSCanvas.ContextType type = TNSCanvas.ContextType.NONE;
        @Nullable
        private Object mSurface;

        @NotNull
        public final TNSCanvas.ContextType getType() {
            return this.type;
        }

        public final void setType(@NotNull TNSCanvas.ContextType contextType) {
            Intrinsics.checkNotNullParameter((Object)((Object)contextType), (String)"<set-?>");
            this.type = contextType;
        }

        public final synchronized void setPaused(boolean paused) {
            this.isPaused = paused;
        }

        @Override
        public synchronized void start() {
            super.start();
            this.isStarted = true;
        }

        @Override
        public void interrupt() {
            super.interrupt();
            this.isStarted = false;
        }

        @Nullable
        public final Object getMSurface() {
            return this.mSurface;
        }

        public final void setMSurface(@Nullable Object object) {
            this.mSurface = object;
        }

        /*
         * Enabled aggressive block sorting
         */
        @SuppressLint(value={"InlinedApi"})
        private final void initEGL() {
            boolean didEnableBufferPreservation;
            int last22;
            WeakReference<TNSCanvas> weakReference = GLContext.this.reference;
            Intrinsics.checkNotNull(weakReference);
            TNSCanvas view = (TNSCanvas)((Object)weakReference.get());
            EGL eGL = EGLContext.getEGL();
            if (eGL == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.microedition.khronos.egl.EGL10");
            }
            GLContext.this.mEGL = (EGL10)eGL;
            EGL10 eGL10 = GLContext.this.mEGL;
            Intrinsics.checkNotNull((Object)eGL10);
            GLContext.this.mEGLDisplay = eGL10.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            if (GLContext.this.mEGLDisplay == EGL10.EGL_NO_DISPLAY) {
                StringBuilder stringBuilder = new StringBuilder().append("eglGetDisplay failed ");
                EGL10 eGL102 = GLContext.this.mEGL;
                Intrinsics.checkNotNull((Object)eGL102);
                throw (Throwable)new RuntimeException(stringBuilder.append(GLUtils.getEGLErrorString((int)eGL102.eglGetError())).toString());
            }
            int[] version = new int[2];
            EGL10 eGL103 = GLContext.this.mEGL;
            Intrinsics.checkNotNull((Object)eGL103);
            if (!eGL103.eglInitialize(GLContext.this.mEGLDisplay, version)) {
                StringBuilder stringBuilder = new StringBuilder().append("eglInitialize failed ");
                EGL10 eGL104 = GLContext.this.mEGL;
                Intrinsics.checkNotNull((Object)eGL104);
                throw (Throwable)new RuntimeException(stringBuilder.append(GLUtils.getEGLErrorString((int)eGL104.eglGetError())).toString());
            }
            int[] configsCount = new int[1];
            EGLConfig[] configs = new EGLConfig[1];
            int type = 4;
            int depthSize = 16;
            int stencilSize = 0;
            int alpha = 8;
            boolean useAlpha = true;
            boolean enableBufferPreservation = GLContext.this.getPreserveDrawingBuffer();
            if (view != null) {
                if (view.glVersion > 2 && Intrinsics.areEqual((Object)view.getActualContextType$canvas_release(), (Object)"webgl2")) {
                    type = 64;
                }
                if (view.contextStencil && view.getContextType$canvas_release() != TNSCanvas.ContextType.CANVAS) {
                    stencilSize = 8;
                    GLContext.this.setStencil(true);
                }
                if (!view.contextDepth || view.getContextType$canvas_release() == TNSCanvas.ContextType.CANVAS) {
                    GLContext.this.setDepth(false);
                    depthSize = 0;
                }
                enableBufferPreservation = view.contextPreserveDrawingBuffer;
                useAlpha = view.contextAlpha;
                GLContext.this.setAntialias(view.getContextType$canvas_release() == TNSCanvas.ContextType.CANVAS ? false : view.contextAntialias);
            }
            if (!useAlpha) {
                alpha = 0;
            }
            int[] configSpec = new int[]{12352, type, 12324, 8, 12323, 8, 12322, 8, 12321, alpha, 12325, depthSize, 12326, stencilSize};
            if (GLContext.this.getAntialias()) {
                int[] nArray = configSpec;
                int n = configSpec.length + 5;
                boolean bl = false;
                int[] nArray2 = Arrays.copyOf(nArray, n);
                Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
                configSpec = nArray2;
                last22 = configSpec.length - 1;
                configSpec[last22 - 4] = 12338;
                configSpec[last22 - 3] = 1;
                configSpec[last22 - 2] = 12337;
                configSpec[last22 - 1] = 4;
                configSpec[last22] = 12344;
            } else {
                int[] last22 = configSpec;
                int n = configSpec.length + 1;
                boolean bl = false;
                int[] nArray = Arrays.copyOf(last22, n);
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"java.util.Arrays.copyOf(this, newSize)");
                configSpec = nArray;
                last22 = configSpec.length - 1;
                configSpec[last22] = 12344;
            }
            EGL10 eGL105 = GLContext.this.mEGL;
            Intrinsics.checkNotNull((Object)eGL105);
            if (!eGL105.eglChooseConfig(GLContext.this.mEGLDisplay, configSpec, configs, 1, configsCount)) {
                if (!GLContext.this.getAntialias()) {
                    StringBuilder stringBuilder = new StringBuilder().append("eglChooseConfig failed ");
                    EGL10 eGL106 = GLContext.this.mEGL;
                    Intrinsics.checkNotNull((Object)eGL106);
                    throw (Throwable)new IllegalArgumentException(stringBuilder.append(GLUtils.getEGLErrorString((int)eGL106.eglGetError())).toString());
                }
                if (view != null) {
                    view.contextAntialias = false;
                }
                configSpec = new int[]{12352, type, 12324, 8, 12323, 8, 12322, 8, 12321, alpha, 12325, depthSize, 12326, stencilSize, 12344};
                EGL10 eGL107 = GLContext.this.mEGL;
                Intrinsics.checkNotNull((Object)eGL107);
                boolean config = eGL107.eglChooseConfig(GLContext.this.mEGLDisplay, configSpec, configs, 1, configsCount);
                if (config) {
                    GLContext.this.mEGLConfig = configs[0];
                }
            } else if (configsCount[0] > 0) {
                GLContext.this.mEGLConfig = configs[0];
            }
            if (GLContext.this.mEGLConfig == null) {
                throw (Throwable)new RuntimeException("eglConfig not initialized");
            }
            if (Utils.INSTANCE.isEmulator()) {
                EGLConfig eGLConfig = GLContext.this.mEGLConfig;
                Intrinsics.checkNotNull((Object)eGLConfig);
                GLContext.this.mEGLContext = this.createGLContext(2, 0, eGLConfig);
            } else {
                if (view != null && view.glVersion > 2 && Intrinsics.areEqual((Object)view.getActualContextType$canvas_release(), (Object)"webgl2") && (GLContext.this.mEGLContext == null || GLContext.this.mEGLContext == EGL10.EGL_NO_CONTEXT)) {
                    EGLConfig eGLConfig = GLContext.this.mEGLConfig;
                    Intrinsics.checkNotNull((Object)eGLConfig);
                    GLContext.this.mEGLContext = this.createGLContext(3, 0, eGLConfig);
                }
                if (GLContext.this.mEGLContext == null || GLContext.this.mEGLContext == EGL10.EGL_NO_CONTEXT) {
                    EGLConfig eGLConfig = GLContext.this.mEGLConfig;
                    Intrinsics.checkNotNull((Object)eGLConfig);
                    GLContext.this.mEGLContext = this.createGLContext(2, 0, eGLConfig);
                }
            }
            GLContext.this.setMEGLSurface$canvas_release(GLContext.this.createSurface(GLContext.this.mEGLConfig, this.mSurface));
            if (GLContext.this.getMEGLSurface$canvas_release() == null || GLContext.this.getMEGLSurface$canvas_release() == EGL10.EGL_NO_SURFACE) {
                EGL10 eGL108 = GLContext.this.mEGL;
                Intrinsics.checkNotNull((Object)eGL108);
                int error2 = eGL108.eglGetError();
                throw (Throwable)new RuntimeException("eglCreateWindowSurface failed " + GLUtils.getEGLErrorString((int)error2));
            }
            this.makeEGLContextCurrent();
            EGL14.eglSwapInterval((EGLDisplay)EGL14.eglGetCurrentDisplay(), (int)0);
            if (enableBufferPreservation && !(didEnableBufferPreservation = EGL14.eglSurfaceAttrib((EGLDisplay)EGL14.eglGetCurrentDisplay(), (android.opengl.EGLSurface)EGL14.eglGetCurrentSurface((int)12377), (int)12435, (int)12436)) && view != null) {
                view.contextPreserveDrawingBuffer = false;
            }
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            int bit = 16384;
            if (GLContext.this.getDepth()) {
                GLES20.glClearDepthf((float)1.0f);
                bit |= 0x100;
            }
            if (GLContext.this.getStencil()) {
                GLES20.glClearStencil((int)0);
                bit |= 0x400;
            }
            GLES20.glClear((int)bit);
        }

        private final void deInitEGL() {
            this.makeEGLContextCurrent();
            GLContext.this.destroySurface(GLContext.this.getMEGLSurface$canvas_release());
            EGL10 eGL10 = GLContext.this.mEGL;
            Intrinsics.checkNotNull((Object)eGL10);
            eGL10.eglDestroyContext(GLContext.this.mEGLDisplay, GLContext.this.mEGLContext);
            EGL10 eGL102 = GLContext.this.mEGL;
            Intrinsics.checkNotNull((Object)eGL102);
            eGL102.eglTerminate(GLContext.this.mEGLDisplay);
        }

        private final EGLContext createGLContext(int contextVersion, int minorVersion, EGLConfig eglConfig) {
            int[] attribs = new int[]{12440, contextVersion, 12539, minorVersion, 12344};
            EGL10 eGL10 = GLContext.this.mEGL;
            Intrinsics.checkNotNull((Object)eGL10);
            EGLContext eGLContext = eGL10.eglCreateContext(GLContext.this.mEGLDisplay, eglConfig, EGL10.EGL_NO_CONTEXT, attribs);
            Intrinsics.checkNotNullExpressionValue((Object)eGLContext, (String)"mEGL!!.eglCreateContext(\u2026.EGL_NO_CONTEXT, attribs)");
            return eGLContext;
        }

        private final void makeEGLContextCurrent() {
            block5: {
                block4: {
                    EGLContext eGLContext = GLContext.this.mEGLContext;
                    EGL10 eGL10 = GLContext.this.mEGL;
                    Intrinsics.checkNotNull((Object)eGL10);
                    if (Intrinsics.areEqual((Object)eGLContext, (Object)eGL10.eglGetCurrentContext()) ^ true) break block4;
                    EGLSurface eGLSurface = GLContext.this.getMEGLSurface$canvas_release();
                    EGL10 eGL102 = GLContext.this.mEGL;
                    Intrinsics.checkNotNull((Object)eGL102);
                    if (!(Intrinsics.areEqual((Object)eGLSurface, (Object)eGL102.eglGetCurrentSurface(12377)) ^ true)) break block5;
                }
                if (GLContext.this.makeCurrent(GLContext.this.getMEGLSurface$canvas_release())) {
                    // empty if block
                }
            }
        }

        @Override
        public void run() {
            GLView view;
            this.initEGL();
            WeakReference<GLView> weakReference = GLContext.this.glView;
            Intrinsics.checkNotNull(weakReference);
            GLView gLView = view = (GLView)((Object)weakReference.get());
            if ((gLView != null ? gLView.getStartupLock() : null) != null) {
                WeakReference<TNSCanvas> weakReference2 = GLContext.this.reference;
                Intrinsics.checkNotNull(weakReference2);
                TNSCanvas ref = (TNSCanvas)((Object)weakReference2.get());
                if (ref != null) {
                    this.type = ref.getContextType$canvas_release();
                    this.makeEGLContextCurrent();
                    if (this.type == TNSCanvas.ContextType.CANVAS && ref.getNativeContext$canvas_release() == 0L) {
                        int[] frameBuffers = new int[1];
                        if (view.drawingBufferWidth == 0) {
                            view.drawingBufferWidth = view.getWidth();
                        }
                        if (view.drawingBufferHeight == 0) {
                            view.drawingBufferHeight = view.getHeight();
                        }
                        if (view.drawingBufferWidth == 0) {
                            view.drawingBufferWidth = 1;
                        }
                        if (view.drawingBufferHeight == 0) {
                            view.drawingBufferHeight = 1;
                        }
                        GLES20.glViewport((int)0, (int)0, (int)view.drawingBufferWidth, (int)view.drawingBufferHeight);
                        GLES20.glGetIntegerv((int)36006, (int[])frameBuffers, (int)0);
                        int samples = 0;
                        if (ref.contextAntialias) {
                            samples = 4;
                        }
                        Resources resources = view.getResources();
                        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"view.resources");
                        DisplayMetrics metrics = resources.getDisplayMetrics();
                        ref.setNativeContext$canvas_release(TNSCanvas.Companion.nativeInitContext(view.drawingBufferWidth, view.drawingBufferHeight, ref.getScale$canvas_release(), frameBuffers[0], samples, true, -16777216, metrics.density * (float)160, TNSCanvas.Companion.getDirection$canvas_release().toNative()));
                    }
                }
                CountDownLatch countDownLatch = view.getStartupLock();
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
            }
            while (true) {
                try {
                    if (this.isPaused) continue;
                    this.makeEGLContextCurrent();
                    ((Runnable)GLContext.this.mQueue.take()).run();
                }
                catch (InterruptedException e) {
                    this.deInitEGL();
                    return;
                }
            }
        }

        public GLThread() {
            this.mSurface = null;
        }

        public GLThread(Object texture) {
            this.mSurface = texture;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/github/triniwiz/canvas/GLContext$Companion;", "", "()V", "EGL_CONTEXT_CLIENT_MINOR_VERSION", "", "EGL_CONTEXT_CLIENT_VERSION", "TAG", "", "canvas_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

