/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Choreographer;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.triniwiz.canvas.CanvasDOMMatrix;
import com.github.triniwiz.canvas.CanvasRenderingContext;
import com.github.triniwiz.canvas.CanvasRenderingContext2D;
import com.github.triniwiz.canvas.GLTextureView;
import com.github.triniwiz.canvas.WebGL2RenderingContext;
import com.github.triniwiz.canvas.WebGLRenderingContext;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class CanvasView
extends FrameLayout
implements GLTextureView.Renderer,
Choreographer.FrameCallback,
SurfaceHolder.Callback,
Application.ActivityLifecycleCallbacks {
    private HandlerThread handlerThread = new HandlerThread("CanvasViewThread");
    private Handler handler;
    GLTextureView glSurfaceView;
    private boolean handleInvalidationManually = false;
    long canvas = 0L;
    CanvasRenderingContext renderingContext2d = null;
    float scale = 0.0f;
    Context ctx;
    boolean pendingInvalidate;
    final Object lock = new Object();
    static final long ONE_MILLISECOND_NS = 1000000L;
    static final long ONE_S_IN_NS = 1000000000L;
    Handler mainHandler;
    boolean wasPendingDraw = false;
    static long lastCall = 0L;
    ContextType contextType = ContextType.NONE;
    private static boolean isLibraryLoaded = false;
    int glVersion;
    int previousOrientation = 0;
    static final String TAG = "CanvasView";
    WebGLRenderingContext webGLRenderingContext;
    WebGL2RenderingContext webGL2RenderingContext;
    Listener listener;
    int mWidth = -1;
    int mHeight = -1;
    int textureId = 0;
    int renderCount = 0;
    boolean wasDestroyed = false;
    boolean isWebGL = false;
    Size lastSize;
    Size newSize;
    boolean readyEventSent = false;
    private static int rating = -1;

    private static native long nativeInit(long var0, int var2, int var3, int var4, float var5);

    private static native long nativeResize(long var0, int var2, int var3, int var4, float var5);

    private static native long nativeRecreate(long var0, int var2, int var3, int var4, float var5);

    private static native long nativeDeInit(long var0);

    private static native long nativeDestroy(long var0);

    private static native long nativeFlush(long var0);

    private static native String nativeToDataUrl(long var0, String var2, float var3);

    private static native byte[] nativeToData(long var0);

    void clear() {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                GLES20.glClear((int)16384);
            }
        });
    }

    public void doFrame(long frameTimeNanos) {
        if (!this.handleInvalidationManually && this.pendingInvalidate) {
            this.flush();
        }
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
    }

    public CanvasView(Context context) {
        super(context, null);
    }

    public CanvasView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        if (this.isInEditMode()) {
            return;
        }
        if (!isLibraryLoaded) {
            System.loadLibrary("canvasnative");
            System.loadLibrary("canvasextras");
            isLibraryLoaded = true;
        }
        this.glSurfaceView = new GLTextureView(context, attrs);
        this.handlerThread.start();
        this.handler = new Handler(this.handlerThread.getLooper());
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.ctx = context;
        this.scale = context.getResources().getDisplayMetrics().density;
        this.glSurfaceView.setEGLConfigChooser(8, 8, 8, 8, 16, 8);
        if (this.detectOpenGLES30() && !CanvasView.isEmulator()) {
            this.glSurfaceView.setEGLContextClientVersion(3);
            this.glVersion = 3;
        } else {
            this.glSurfaceView.setEGLContextClientVersion(2);
            this.glVersion = 2;
        }
        this.glSurfaceView.setRenderer(this);
        this.glSurfaceView.setOpaque(false);
        this.glSurfaceView.setRenderMode(0);
        this.glSurfaceView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.glSurfaceView.setPreserveEGLContextOnPause(true);
        this.addView((View)this.glSurfaceView);
    }

    private boolean detectOpenGLES30() {
        ActivityManager am = (ActivityManager)this.getContext().getSystemService("activity");
        if (am == null) {
            return false;
        }
        ConfigurationInfo info = am.getDeviceConfigurationInfo();
        return info.reqGlEsVersion >= 196608;
    }

    public void onPause() {
        Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this);
    }

    public void onResume() {
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
    }

    public void destroy() {
        CanvasView.nativeDestroy(this.canvas);
        this.canvas = 0L;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Log.d((String)"com.test", (String)"finalize ?????");
        if (this.canvas != 0L) {
            this.destroy();
        }
    }

    public void setHandleInvalidationManually(boolean handleInvalidationManually) {
        this.handleInvalidationManually = handleInvalidationManually;
    }

    public boolean isHandleInvalidationManually() {
        return this.handleInvalidationManually;
    }

    public GLTextureView getSurface() {
        return this.glSurfaceView;
    }

    public void queueEvent(Runnable runnable) {
        if (this.glSurfaceView != null) {
            this.glSurfaceView.queueEvent(runnable);
        }
    }

    public void setupActivityHandler(Application app) {
        app.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
    }

    public void onActivityStarted(@NonNull Activity activity) {
    }

    public void onActivityResumed(@NonNull Activity activity) {
        this.onResume();
    }

    public void onActivityPaused(@NonNull Activity activity) {
    }

    public void onActivityStopped(@NonNull Activity activity) {
        this.onPause();
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
    }

    public byte[] toData() {
        return CanvasView.nativeToData(this.canvas);
    }

    public String toDataURL() {
        return this.toDataURL("image/png");
    }

    public void toDataURLAsync(DataURLListener listener) {
        this.toDataURLAsync("image/png", listener);
    }

    public void toDataURLAsync(String type, DataURLListener listener) {
        this.toDataURLAsync(type, 0.92f, listener);
    }

    public void toDataURLAsync(final String type, final float quality, final DataURLListener listener) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                listener.onResult(CanvasView.nativeToDataUrl(CanvasView.this.canvas, type, quality));
            }
        });
    }

    public String toDataURL(String type) {
        return this.toDataURL(type, 0.92f);
    }

    public String toDataURL(final String type, final float quality) {
        final CountDownLatch lock = new CountDownLatch(1);
        final String[] data = new String[1];
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                data[0] = CanvasView.nativeToDataUrl(CanvasView.this.canvas, type, quality);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return data[0];
    }

    public static CanvasDOMMatrix createSVGMatrix() {
        return new CanvasDOMMatrix();
    }

    @Nullable
    public CanvasRenderingContext getContext(String type) {
        switch (type) {
            case "2d": {
                if (this.renderingContext2d == null) {
                    this.renderingContext2d = new CanvasRenderingContext2D(this);
                }
                this.contextType = ContextType.CANVAS;
                return this.renderingContext2d;
            }
            case "webgl": {
                if (this.webGLRenderingContext == null) {
                    this.webGLRenderingContext = new WebGLRenderingContext(this);
                }
                this.contextType = ContextType.WEBGL;
                return this.webGLRenderingContext;
            }
            case "webgl2": {
                if (this.webGL2RenderingContext == null) {
                    if (Build.VERSION.SDK_INT >= 18) {
                        this.webGL2RenderingContext = new WebGL2RenderingContext(this);
                        this.isWebGL = true;
                    } else {
                        this.isWebGL = false;
                        this.contextType = ContextType.NONE;
                        return null;
                    }
                }
                this.contextType = ContextType.WEBGL;
                return this.webGL2RenderingContext;
            }
        }
        this.contextType = ContextType.NONE;
        return null;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
    }

    public void surfaceCreated(SurfaceHolder holder) {
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
    }

    @Override
    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (CanvasView.this.listener != null) {
                    CanvasView.this.listener.contextReady();
                }
            }
        });
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    @Override
    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.newSize = new Size(width, height);
    }

    public void flush() {
        this.glSurfaceView.requestRender();
    }

    void showForeground() {
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                CanvasView.this.setForeground((Drawable)new ColorDrawable(-1));
            }
        });
    }

    void hideForeground() {
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                CanvasView.this.setForeground(null);
            }
        });
    }

    @Override
    public void onDrawFrame(GL10 gl) {
        if (this.contextType == ContextType.CANVAS) {
            int[] frameBuffers;
            if (this.canvas == 0L && this.newSize.getWidth() != 0 && this.newSize.getHeight() != 0) {
                GLES20.glViewport((int)0, (int)0, (int)this.newSize.getWidth(), (int)this.newSize.getHeight());
                this.lastSize = this.newSize;
                frameBuffers = new int[1];
                GLES20.glGetIntegerv((int)36006, (int[])frameBuffers, (int)0);
                this.canvas = CanvasView.nativeInit(this.canvas, frameBuffers[0], this.lastSize.getWidth(), this.lastSize.getHeight(), this.scale);
            }
            if (this.lastSize != this.newSize) {
                this.lastSize = this.newSize;
                frameBuffers = new int[1];
                GLES20.glGetIntegerv((int)36006, (int[])frameBuffers, (int)0);
                this.canvas = CanvasView.nativeResize(this.canvas, frameBuffers[0], this.lastSize.getWidth(), this.lastSize.getHeight(), this.scale);
            }
            if (this.pendingInvalidate) {
                if (this.canvas > 0L) {
                    this.canvas = CanvasView.nativeFlush(this.canvas);
                }
                this.pendingInvalidate = false;
            }
        }
    }

    public static boolean isEmulator() {
        int newRating = 0;
        if (rating < 0) {
            if (Build.PRODUCT.contains("sdk") || Build.PRODUCT.contains("Andy") || Build.PRODUCT.contains("ttVM_Hdragon") || Build.PRODUCT.contains("google_sdk") || Build.PRODUCT.contains("Droid4X") || Build.PRODUCT.contains("nox") || Build.PRODUCT.contains("sdk_x86") || Build.PRODUCT.contains("sdk_google") || Build.PRODUCT.contains("vbox86p")) {
                ++newRating;
            }
            if (Build.MANUFACTURER.equals("unknown") || Build.MANUFACTURER.equals("Genymotion") || Build.MANUFACTURER.contains("Andy") || Build.MANUFACTURER.contains("MIT") || Build.MANUFACTURER.contains("nox") || Build.MANUFACTURER.contains("TiantianVM") || Build.MANUFACTURER.contains("vmos")) {
                ++newRating;
            }
            if (Build.BRAND.equals("generic") || Build.BRAND.equals("generic_x86") || Build.BRAND.equals("TTVM") || Build.BRAND.contains("Andy")) {
                ++newRating;
            }
            if (Build.DEVICE.contains("generic") || Build.DEVICE.contains("generic_x86") || Build.DEVICE.contains("Andy") || Build.DEVICE.contains("ttVM_Hdragon") || Build.DEVICE.contains("Droid4X") || Build.DEVICE.contains("nox") || Build.DEVICE.contains("generic_x86_64") || Build.DEVICE.contains("vbox86p")) {
                ++newRating;
            }
            if (Build.MODEL.equals("sdk") || Build.MODEL.equals("google_sdk") || Build.MODEL.contains("Droid4X") || Build.MODEL.contains("TiantianVM") || Build.MODEL.contains("Andy") || Build.MODEL.equals("Android SDK built for x86_64") || Build.MODEL.equals("Android SDK built for x86") || Build.MODEL.equals("vmos")) {
                ++newRating;
            }
            if (Build.HARDWARE.equals("goldfish") || Build.HARDWARE.equals("vbox86") || Build.HARDWARE.contains("nox") || Build.HARDWARE.contains("ttVM_x86")) {
                ++newRating;
            }
            if (Build.FINGERPRINT.contains("generic/sdk/generic") || Build.FINGERPRINT.contains("generic_x86/sdk_x86/generic_x86") || Build.FINGERPRINT.contains("Andy") || Build.FINGERPRINT.contains("ttVM_Hdragon") || Build.FINGERPRINT.contains("generic_x86_64") || Build.FINGERPRINT.contains("generic/google_sdk/generic") || Build.FINGERPRINT.contains("vbox86p") || Build.FINGERPRINT.contains("generic/vbox86p/vbox86p") || Build.FINGERPRINT.contains("test-keys")) {
                ++newRating;
            }
            try {
                String opengl = GLES20.glGetString((int)7937);
                if (opengl != null && (opengl.contains("Bluestacks") || opengl.contains("Translator"))) {
                    newRating += 10;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                File sharedFolder = new File(Environment.getExternalStorageDirectory().toString() + File.separatorChar + "windows" + File.separatorChar + "BstSharedFolder");
                if (sharedFolder.exists()) {
                    newRating += 10;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            rating = newRating;
        }
        return rating > 3;
    }

    static class Size {
        int width;
        int height;

        Size(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }
    }

    public static interface Listener {
        public void contextReady();
    }

    static enum ContextType {
        NONE,
        CANVAS,
        WEBGL;

    }

    public static interface DataURLListener {
        public void onResult(String var1);
    }
}

