/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.content.Context;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.AttributeSet;
import android.view.Choreographer;
import androidx.annotation.Nullable;
import com.github.triniwiz.canvas.CanvasRenderingContext;
import com.github.triniwiz.canvas.CanvasRenderingContext2D;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class CanvasView
extends GLSurfaceView
implements GLSurfaceView.Renderer,
Choreographer.FrameCallback {
    private HandlerThread handlerThread = new HandlerThread("CanvasViewThread");
    private Handler handler;
    long canvas = 0L;
    CanvasRenderingContext renderingContext2d = null;
    float scale = 0.0f;
    Context ctx;
    boolean pendingInvalidate;
    static final Object lock;
    long lastCall = 0L;
    int mWidth = -1;
    int mHeight = -1;

    private static native long nativeInit(long var0, int var2, int var3, int var4, float var5);

    private static native long nativeDeInit(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFrame(long frameTimeNanos) {
        Object object = lock;
        synchronized (object) {
            long dt = frameTimeNanos - this.lastCall;
            if (this.pendingInvalidate) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        CanvasView.this.requestRender();
                        CanvasView.this.pendingInvalidate = false;
                    }
                });
            }
            this.lastCall = frameTimeNanos;
        }
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
    }

    public CanvasView(Context context) {
        super(context, null);
    }

    public CanvasView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.handlerThread.start();
        this.handler = new Handler(this.handlerThread.getLooper());
        this.ctx = context;
        this.scale = context.getResources().getDisplayMetrics().density;
        this.setEGLConfigChooser(8, 8, 8, 8, 24, 0);
        this.setEGLContextClientVersion(2);
        this.setPreserveEGLContextOnPause(true);
        this.getHolder().setFormat(1);
        this.setRenderer(this);
        this.setRenderMode(0);
        this.setZOrderOnTop(true);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
    }

    @Nullable
    public CanvasRenderingContext getContext(String type) {
        if (type.equals("2d")) {
            if (this.renderingContext2d == null) {
                this.renderingContext2d = new CanvasRenderingContext2D(this);
            }
            return this.renderingContext2d;
        }
        return null;
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)17664);
    }

    public void onSurfaceChanged(GL10 gl, final int width, final int height) {
        if (width != this.mWidth && height != this.mHeight) {
            this.mWidth = width;
            this.mHeight = height;
        }
        if (this.canvas == 0L) {
            this.queueEvent(new Runnable(){

                @Override
                public void run() {
                    CanvasView.this.canvas = CanvasView.nativeInit(CanvasView.this.canvas, 0, width, height, CanvasView.this.scale);
                }
            });
        }
    }

    public void onDrawFrame(GL10 gl) {
    }

    static {
        System.loadLibrary("canvasnative");
        lock = new Object();
    }
}

