/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.google.common.base.Charsets;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LoggedRequest
implements Request {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private final String url;
    private final String absoluteUrl;
    private final RequestMethod method;
    private final HttpHeaders headers;
    private final Map<String, QueryParameter> queryParams;
    private final byte[] body;
    private final boolean isBrowserProxyRequest;
    private final Date loggedDate;

    public static LoggedRequest createFrom(Request request) {
        return new LoggedRequest(request.getUrl(), request.getAbsoluteUrl(), request.getMethod(), HttpHeaders.copyOf(request.getHeaders()), request.getBody(), request.isBrowserProxyRequest(), new Date());
    }

    public LoggedRequest(String url, String absoluteUrl, RequestMethod method, HttpHeaders headers, byte[] body, boolean isBrowserProxyRequest, Date loggedDate) {
        this.url = url;
        this.absoluteUrl = absoluteUrl;
        this.method = method;
        this.body = body;
        this.headers = headers;
        this.queryParams = Urls.splitQuery(URI.create(url));
        this.isBrowserProxyRequest = isBrowserProxyRequest;
        this.loggedDate = loggedDate;
    }

    @JsonCreator
    public LoggedRequest(@JsonProperty(value="url") String url, @JsonProperty(value="absoluteUrl") String absoluteUrl, @JsonProperty(value="method") RequestMethod method, @JsonProperty(value="headers") HttpHeaders headers, @JsonProperty(value="body") String body, @JsonProperty(value="browserProxyRequest") boolean isBrowserProxyRequest, @JsonProperty(value="loggedDate") Date loggedDate) {
        this(url, absoluteUrl, method, headers, body.getBytes(Charsets.UTF_8), isBrowserProxyRequest, loggedDate);
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getAbsoluteUrl() {
        return this.absoluteUrl;
    }

    @Override
    public RequestMethod getMethod() {
        return this.method;
    }

    @Override
    @JsonIgnore
    public String getHeader(String key) {
        HttpHeader header = this.header(key);
        if (header.isPresent()) {
            return header.firstValue();
        }
        return null;
    }

    @Override
    public HttpHeader header(String key) {
        return this.headers.getHeader(key);
    }

    @Override
    public ContentTypeHeader contentTypeHeader() {
        return this.headers.getContentTypeHeader();
    }

    @Override
    public boolean containsHeader(String key) {
        return this.getHeader(key) != null;
    }

    @Override
    public byte[] getBody() {
        return this.body;
    }

    @Override
    @JsonProperty(value="body")
    public String getBodyAsString() {
        return new String(this.body, Charsets.UTF_8);
    }

    @Override
    @JsonIgnore
    public Set<String> getAllHeaderKeys() {
        return this.headers.keys();
    }

    @Override
    public QueryParameter queryParameter(String key) {
        return this.queryParams.get(key);
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public boolean isBrowserProxyRequest() {
        return this.isBrowserProxyRequest;
    }

    public Date getLoggedDate() {
        return this.loggedDate;
    }

    public String getLoggedDateString() {
        return this.format(this.loggedDate);
    }

    private String format(Date date) {
        return new SimpleDateFormat(DATE_FORMAT).format(date);
    }
}

