/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.json.JSONException;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class ValuePattern {
    private String equalToJson;
    private String equalToXml;
    private String matchesXPath;
    private Map<String, String> xpathNamespaces;
    private JSONCompareMode jsonCompareMode;
    private String equalTo;
    private String contains;
    private String matches;
    private String doesNotMatch;
    private Boolean absent;
    private String matchesJsonPath;

    public static ValuePattern equalTo(String value) {
        ValuePattern valuePattern = new ValuePattern();
        valuePattern.setEqualTo(value);
        return valuePattern;
    }

    public static ValuePattern equalToJson(String value) {
        ValuePattern valuePattern = new ValuePattern();
        valuePattern.setEqualToJson(value);
        return valuePattern;
    }

    public static ValuePattern equalToXml(String value) {
        ValuePattern valuePattern = new ValuePattern();
        valuePattern.setEqualToXml(value);
        return valuePattern;
    }

    public static ValuePattern equalToXPath(String value) {
        ValuePattern valuePattern = new ValuePattern();
        valuePattern.setMatchesXPath(value);
        return valuePattern;
    }

    public static ValuePattern equalToJson(String value, JSONCompareMode jsonCompareMode) {
        ValuePattern valuePattern = new ValuePattern();
        valuePattern.setEqualToJson(value);
        valuePattern.setJsonCompareMode(jsonCompareMode);
        return valuePattern;
    }

    public static ValuePattern containing(String value) {
        ValuePattern valuePattern = new ValuePattern();
        valuePattern.setContains(value);
        return valuePattern;
    }

    public static ValuePattern matches(String value) {
        ValuePattern valuePattern = new ValuePattern();
        valuePattern.setMatches(value);
        return valuePattern;
    }

    public static ValuePattern absent() {
        ValuePattern valuePattern = new ValuePattern();
        valuePattern.absent = true;
        return valuePattern;
    }

    public boolean isMatchFor(String value) {
        this.checkOneMatchTypeSpecified();
        if (this.absent != null) {
            return this.absent != false && value == null;
        }
        if (this.equalToJson != null) {
            return this.isEqualJson(value);
        }
        if (this.equalToXml != null) {
            return this.isEqualXml(value);
        }
        if (this.matchesXPath != null) {
            return this.isXPathMatch(value);
        }
        if (this.equalTo != null) {
            return value.equals(this.equalTo);
        }
        if (this.contains != null) {
            return value.contains(this.contains);
        }
        if (this.matches != null) {
            return this.isMatch(this.matches, value);
        }
        if (this.doesNotMatch != null) {
            return !this.isMatch(this.doesNotMatch, value);
        }
        if (this.matchesJsonPath != null) {
            return this.isJsonPathMatch(value);
        }
        return false;
    }

    public static Predicate<ValuePattern> matching(final String value) {
        return new Predicate<ValuePattern>(){

            public boolean apply(ValuePattern input) {
                return input.isMatchFor(value);
            }
        };
    }

    private boolean isEqualJson(String value) {
        JSONCompareResult result;
        try {
            result = JSONCompare.compareJSON((String)this.equalToJson, (String)value, (JSONCompareMode)((JSONCompareMode)Optional.fromNullable((Object)this.jsonCompareMode).or((Object)JSONCompareMode.NON_EXTENSIBLE)));
        }
        catch (JSONException e) {
            return false;
        }
        return result.passed();
    }

    private boolean isEqualXml(String value) {
        try {
            Diff diff = XMLUnit.compareXML((String)this.equalToXml, (String)value);
            return diff.similar();
        }
        catch (SAXException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean isXPathMatch(String value) {
        try {
            NodeList nodeList;
            Document inDocument = XMLUnit.buildControlDocument((String)value);
            XpathEngine simpleXpathEngine = XMLUnit.newXpathEngine();
            if (this.xpathNamespaces != null) {
                SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext(this.xpathNamespaces);
                simpleXpathEngine.setNamespaceContext((NamespaceContext)namespaceContext);
            }
            return (nodeList = simpleXpathEngine.getMatchingNodes(this.matchesXPath, inDocument)).getLength() > 0;
        }
        catch (SAXException e) {
            LocalNotifier.notifier().info(String.format("Warning: failed to parse the XML document. Reason: %s\nXML: %s", e.getMessage(), value));
            return false;
        }
        catch (IOException e) {
            LocalNotifier.notifier().info(e.getMessage());
            return false;
        }
        catch (XpathException e) {
            LocalNotifier.notifier().info("Warning: failed to evaluate the XPath expression " + this.matchesXPath);
            return false;
        }
    }

    private boolean isMatch(String regex, String value) {
        Pattern pattern = Pattern.compile(regex, 32);
        return pattern.matcher(value).matches();
    }

    private boolean isJsonPathMatch(String value) {
        try {
            Object obj = JsonPath.read((String)value, (String)this.matchesJsonPath, (Filter[])new Filter[0]);
            if (obj instanceof JSONArray) {
                return ((JSONArray)obj).size() > 0;
            }
            if (obj instanceof JSONObject) {
                return ((JSONObject)obj).size() > 0;
            }
            return obj != null;
        }
        catch (Exception e) {
            String error = e.getMessage().equalsIgnoreCase("invalid path") ? "the JSON path didn't match the document structure" : (e.getMessage().equalsIgnoreCase("invalid container object") ? "the JSON document couldn't be parsed" : "of error '" + e.getMessage() + "'");
            String message = String.format("Warning: JSON path expression '%s' failed to match document '%s' because %s", this.matchesJsonPath, value, error);
            LocalNotifier.notifier().info(message);
            return false;
        }
    }

    private void checkNoMoreThanOneMatchTypeSpecified() {
        if (this.countAllAttributes() > 1) {
            throw new IllegalStateException("Only one type of match may be specified");
        }
    }

    private void checkOneMatchTypeSpecified() {
        if (this.countAllAttributes() == 0) {
            throw new IllegalStateException("One match type must be specified");
        }
    }

    private void checkMatchesXPath() {
        if (this.matchesXPath == null) {
            throw new IllegalStateException("XPathNamespace can only be set for matchesXPath");
        }
    }

    private int countAllAttributes() {
        return ValuePattern.count(this.equalToJson, this.equalToXml, this.matchesXPath, this.equalTo, this.contains, this.matches, this.doesNotMatch, this.absent, this.matchesJsonPath);
    }

    public static int count(Object ... objects) {
        int counter = 0;
        for (Object obj : objects) {
            if (obj == null) continue;
            ++counter;
        }
        return counter;
    }

    public void setEqualTo(String equalTo) {
        this.equalTo = equalTo;
        this.checkNoMoreThanOneMatchTypeSpecified();
    }

    public void setEqualToJson(String equalToJson) {
        this.equalToJson = equalToJson;
        this.checkNoMoreThanOneMatchTypeSpecified();
    }

    public void setEqualToXml(String equalToXml) {
        this.equalToXml = equalToXml;
        this.checkNoMoreThanOneMatchTypeSpecified();
    }

    public void setMatchesXPath(String matchesXPath) {
        this.matchesXPath = matchesXPath;
        this.checkNoMoreThanOneMatchTypeSpecified();
    }

    public void setWithXPathNamespaces(Map<String, String> xpathNamespaceMap) {
        if (xpathNamespaceMap != null) {
            this.checkMatchesXPath();
        }
        this.xpathNamespaces = xpathNamespaceMap;
    }

    public void setWithXPathNamespace(String namespace, String namespaceUri) {
        this.checkMatchesXPath();
        if (this.xpathNamespaces == null) {
            this.xpathNamespaces = new HashMap<String, String>();
        }
        this.xpathNamespaces.put(namespace, namespaceUri);
    }

    public void setContains(String contains) {
        this.contains = contains;
        this.checkNoMoreThanOneMatchTypeSpecified();
    }

    public void setMatches(String matches) {
        this.matches = matches;
        this.checkNoMoreThanOneMatchTypeSpecified();
    }

    public void setDoesNotMatch(String doesNotMatch) {
        this.doesNotMatch = doesNotMatch;
        this.checkNoMoreThanOneMatchTypeSpecified();
    }

    public void setAbsent(Boolean absent) {
        this.absent = absent;
        this.checkNoMoreThanOneMatchTypeSpecified();
    }

    public void setMatchesJsonPaths(String matchesJsonPath) {
        this.matchesJsonPath = matchesJsonPath;
        this.checkNoMoreThanOneMatchTypeSpecified();
    }

    public String getEqualTo() {
        return this.equalTo;
    }

    public String getEqualToJson() {
        return this.equalToJson;
    }

    public String getEqualToXml() {
        return this.equalToXml;
    }

    public String getMatchesXPath() {
        return this.matchesXPath;
    }

    public Map getWithXPathNamespaces() {
        return this.xpathNamespaces;
    }

    public JSONCompareMode getJsonCompareMode() {
        return this.jsonCompareMode;
    }

    public void setJsonCompareMode(JSONCompareMode jsonCompareMode) {
        this.jsonCompareMode = jsonCompareMode;
    }

    public String getContains() {
        return this.contains;
    }

    public String getMatches() {
        return this.matches;
    }

    public String getDoesNotMatch() {
        return this.doesNotMatch;
    }

    public Boolean isAbsent() {
        return this.absent;
    }

    public String getMatchesJsonPath() {
        return this.matchesJsonPath;
    }

    public boolean nullSafeIsAbsent() {
        return this.absent != null && this.absent != false;
    }

    public String toString() {
        if (this.equalToJson != null) {
            return "equalJson " + this.equalToJson;
        }
        if (this.equalToXml != null) {
            return "equalXml " + this.equalToXml;
        }
        if (this.matchesXPath != null) {
            if (this.xpathNamespaces != null) {
                return "equalXPath " + this.matchesXPath + " " + this.namespacesToString();
            }
            return "equalXPath " + this.matchesXPath;
        }
        if (this.equalTo != null) {
            return "equal " + this.equalTo;
        }
        if (this.contains != null) {
            return "contains " + this.contains;
        }
        if (this.matches != null) {
            return "matches " + this.matches;
        }
        if (this.doesNotMatch != null) {
            return "not match " + this.doesNotMatch;
        }
        if (this.matchesJsonPath != null) {
            return "matches JSON path " + this.matchesJsonPath;
        }
        return "is absent";
    }

    private String namespacesToString() {
        StringBuilder sb = new StringBuilder(" with namespaces ");
        for (String namespacePrefix : this.xpathNamespaces.keySet()) {
            sb.append(namespacePrefix);
            sb.append("=\"");
            sb.append(this.xpathNamespaces.get(namespacePrefix));
            sb.append("\" ");
        }
        return sb.toString().trim();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValuePattern that = (ValuePattern)o;
        if (this.absent != null ? !this.absent.equals(that.absent) : that.absent != null) {
            return false;
        }
        if (this.contains != null ? !this.contains.equals(that.contains) : that.contains != null) {
            return false;
        }
        if (this.doesNotMatch != null ? !this.doesNotMatch.equals(that.doesNotMatch) : that.doesNotMatch != null) {
            return false;
        }
        if (this.equalTo != null ? !this.equalTo.equals(that.equalTo) : that.equalTo != null) {
            return false;
        }
        if (this.equalToJson != null ? !this.equalToJson.equals(that.equalToJson) : that.equalToJson != null) {
            return false;
        }
        if (this.equalToXml != null ? !this.equalToXml.equals(that.equalToXml) : that.equalToXml != null) {
            return false;
        }
        if (this.matchesXPath != null ? !this.matchesXPath.equals(that.matchesXPath) : that.matchesXPath != null) {
            return false;
        }
        if (this.xpathNamespaces != null ? !this.xpathNamespaces.equals(that.xpathNamespaces) : that.xpathNamespaces != null) {
            return false;
        }
        if (this.matches != null ? !this.matches.equals(that.matches) : that.matches != null) {
            return false;
        }
        return !(this.matchesJsonPath != null ? !this.matchesJsonPath.equals(that.matchesJsonPath) : that.matchesJsonPath != null);
    }

    public int hashCode() {
        int result = this.equalTo != null ? this.equalTo.hashCode() : 0;
        result = 31 * result + (this.equalToJson != null ? this.equalToJson.hashCode() : 0);
        result = 31 * result + (this.equalToXml != null ? this.equalToXml.hashCode() : 0);
        result = 31 * result + (this.matchesXPath != null ? this.matchesXPath.hashCode() : 0);
        result = 31 * result + (this.xpathNamespaces != null ? this.xpathNamespaces.hashCode() : 0);
        result = 31 * result + (this.contains != null ? this.contains.hashCode() : 0);
        result = 31 * result + (this.matches != null ? this.matches.hashCode() : 0);
        result = 31 * result + (this.doesNotMatch != null ? this.doesNotMatch.hashCode() : 0);
        result = 31 * result + (this.absent != null ? this.absent.hashCode() : 0);
        result = 31 * result + (this.matchesJsonPath != null ? this.matchesJsonPath.hashCode() : 0);
        return result;
    }

    static {
        XMLUnit.setIgnoreWhitespace((boolean)true);
    }
}

