/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty6;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.global.RequestDelayControl;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.HttpServer;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.jetty6.DelayableSocketConnector;
import com.github.tomakehurst.wiremock.jetty6.DelayableSslSocketConnector;
import com.github.tomakehurst.wiremock.jetty6.Jetty6HandlerDispatchingServlet;
import com.github.tomakehurst.wiremock.servlet.ContentTypeSettingFilter;
import com.github.tomakehurst.wiremock.servlet.TrailingSlashFilter;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.ServletHolder;

class Jetty6HttpServer
implements HttpServer {
    private static final String FILES_URL_MATCH = String.format("/%s/*", "__files");
    private final Server jettyServer = new Server();
    private final DelayableSocketConnector httpConnector;
    private final DelayableSslSocketConnector httpsConnector;

    Jetty6HttpServer(Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler, RequestDelayControl requestDelayControl) {
        this.httpConnector = this.createHttpConnector(requestDelayControl, options.bindAddress(), options.portNumber());
        this.jettyServer.addConnector((Connector)this.httpConnector);
        if (options.httpsSettings().enabled()) {
            this.httpsConnector = this.createHttpsConnector(requestDelayControl, options.httpsSettings().port(), options.httpsSettings().keyStorePath());
            this.jettyServer.addConnector((Connector)this.httpsConnector);
        } else {
            this.httpsConnector = null;
        }
        Notifier notifier = options.notifier();
        this.addAdminContext(adminRequestHandler, notifier);
        this.addMockServiceContext(stubRequestHandler, options.filesRoot(), notifier);
    }

    @Override
    public void start() {
        try {
            this.jettyServer.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
        try {
            this.jettyServer.stop();
            this.jettyServer.join();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isRunning() {
        return this.jettyServer != null && this.jettyServer.isRunning();
    }

    @Override
    public int port() {
        return this.httpConnector.getLocalPort();
    }

    @Override
    public int httpsPort() {
        return this.httpsConnector.getLocalPort();
    }

    private DelayableSocketConnector createHttpConnector(RequestDelayControl requestDelayControl, String bindAddress, int port) {
        DelayableSocketConnector connector = new DelayableSocketConnector(requestDelayControl);
        connector.setHost(bindAddress);
        connector.setPort(port);
        connector.setHeaderBufferSize(8192);
        return connector;
    }

    private DelayableSslSocketConnector createHttpsConnector(RequestDelayControl requestDelayControl, int httpsPort, String keystorePath) {
        DelayableSslSocketConnector connector = new DelayableSslSocketConnector(requestDelayControl);
        connector.setPort(httpsPort);
        connector.setHeaderBufferSize(8192);
        connector.setKeystore(keystorePath);
        connector.setKeyPassword("password");
        return connector;
    }

    private void addMockServiceContext(StubRequestHandler stubRequestHandler, FileSource fileSource, Notifier notifier) {
        Context mockServiceContext = new Context((HandlerContainer)this.jettyServer, "/");
        HashMap initParams = Maps.newHashMap();
        initParams.put("org.mortbay.jetty.servlet.Default.maxCacheSize", "0");
        initParams.put("org.mortbay.jetty.servlet.Default.resourceBase", fileSource.getPath());
        initParams.put("org.mortbay.jetty.servlet.Default.dirAllowed", "false");
        mockServiceContext.setInitParams((Map)initParams);
        mockServiceContext.addServlet(DefaultServlet.class, FILES_URL_MATCH);
        mockServiceContext.setAttribute(StubRequestHandler.class.getName(), (Object)stubRequestHandler);
        mockServiceContext.setAttribute("Notifier", (Object)notifier);
        ServletHolder servletHolder = mockServiceContext.addServlet(Jetty6HandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", StubRequestHandler.class.getName());
        servletHolder.setInitParameter("shouldForwardToFilesContext", "true");
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.addMimeMapping("json", "application/json");
        mimeTypes.addMimeMapping("html", "text/html");
        mimeTypes.addMimeMapping("xml", "application/xml");
        mimeTypes.addMimeMapping("txt", "text/plain");
        mockServiceContext.setMimeTypes(mimeTypes);
        mockServiceContext.setWelcomeFiles(new String[]{"index.json", "index.html", "index.xml", "index.txt"});
        mockServiceContext.addFilter(ContentTypeSettingFilter.class, FILES_URL_MATCH, 2);
        mockServiceContext.addFilter(TrailingSlashFilter.class, FILES_URL_MATCH, 15);
        this.jettyServer.addHandler((Handler)mockServiceContext);
    }

    private void addAdminContext(AdminRequestHandler adminRequestHandler, Notifier notifier) {
        Context adminContext = new Context((HandlerContainer)this.jettyServer, "/__admin");
        ServletHolder servletHolder = adminContext.addServlet(Jetty6HandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", AdminRequestHandler.class.getName());
        adminContext.setAttribute(AdminRequestHandler.class.getName(), (Object)adminRequestHandler);
        adminContext.setAttribute("Notifier", (Object)notifier);
        this.jettyServer.addHandler((Handler)adminContext);
    }
}

