/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.BinaryFile;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.extension.ResponseTransformer;
import com.github.tomakehurst.wiremock.global.GlobalSettingsHolder;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.ProxyResponseRenderer;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.List;
import wiremock.com.google.common.base.MoreObjects;

public class StubResponseRenderer
implements ResponseRenderer {
    private final FileSource fileSource;
    private final GlobalSettingsHolder globalSettingsHolder;
    private final ProxyResponseRenderer proxyResponseRenderer;
    private final List<ResponseTransformer> responseTransformers;

    public StubResponseRenderer(FileSource fileSource, GlobalSettingsHolder globalSettingsHolder, ProxyResponseRenderer proxyResponseRenderer, List<ResponseTransformer> responseTransformers) {
        this.fileSource = fileSource;
        this.globalSettingsHolder = globalSettingsHolder;
        this.proxyResponseRenderer = proxyResponseRenderer;
        this.responseTransformers = responseTransformers;
    }

    @Override
    public Response render(ServeEvent serveEvent) {
        ResponseDefinition responseDefinition = serveEvent.getResponseDefinition();
        if (!responseDefinition.wasConfigured()) {
            return Response.notConfigured();
        }
        Response response = this.buildResponse(serveEvent);
        return this.applyTransformations(responseDefinition.getOriginalRequest(), responseDefinition, response, this.responseTransformers);
    }

    private Response buildResponse(ServeEvent serveEvent) {
        if (serveEvent.getResponseDefinition().isProxyResponse()) {
            return this.proxyResponseRenderer.render(serveEvent);
        }
        Response.Builder responseBuilder = this.renderDirectly(serveEvent);
        return responseBuilder.build();
    }

    private Response applyTransformations(Request request, ResponseDefinition responseDefinition, Response response, List<ResponseTransformer> transformers) {
        if (transformers.isEmpty()) {
            return response;
        }
        ResponseTransformer transformer = transformers.get(0);
        Response newResponse = transformer.applyGlobally() || responseDefinition.hasTransformer(transformer) ? transformer.transform(request, response, this.fileSource.child("__files"), responseDefinition.getTransformerParameters()) : response;
        return this.applyTransformations(request, responseDefinition, newResponse, transformers.subList(1, transformers.size()));
    }

    private Response.Builder renderDirectly(ServeEvent serveEvent) {
        ResponseDefinition responseDefinition = serveEvent.getResponseDefinition();
        HttpHeaders headers = responseDefinition.getHeaders();
        StubMapping stubMapping = serveEvent.getStubMapping();
        if (serveEvent.getWasMatched() && stubMapping != null) {
            headers = MoreObjects.firstNonNull(headers, new HttpHeaders()).plus(new HttpHeader("Matched-Stub-Id", stubMapping.getId().toString()));
            if (stubMapping.getName() != null) {
                headers = headers.plus(new HttpHeader("Matched-Stub-Name", stubMapping.getName()));
            }
        }
        Response.Builder responseBuilder = Response.response().status(responseDefinition.getStatus()).statusMessage(responseDefinition.getStatusMessage()).headers(headers).fault(responseDefinition.getFault()).configureDelay(this.globalSettingsHolder.get().getFixedDelay(), this.globalSettingsHolder.get().getDelayDistribution(), responseDefinition.getFixedDelayMilliseconds(), responseDefinition.getDelayDistribution()).chunkedDribbleDelay(responseDefinition.getChunkedDribbleDelay());
        if (responseDefinition.specifiesBodyFile()) {
            BinaryFile bodyFile = this.fileSource.getBinaryFileNamed(responseDefinition.getBodyFileName());
            responseBuilder.body(bodyFile);
        } else if (responseDefinition.specifiesBodyContent()) {
            if (responseDefinition.specifiesBinaryBodyContent()) {
                responseBuilder.body(responseDefinition.getByteBody());
            } else {
                responseBuilder.body(responseDefinition.getByteBody());
            }
        }
        return responseBuilder;
    }
}

