/*
 * Decompiled with CFR 0.152.
 */
package toan.android.floatingactionmenu;

import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.view.ViewPropertyAnimator;

public class FabAnimationUtils {
    public static final int ANIM_NONE = 0;
    public static final int ANIM_TRANSLATION_Y = 1;
    public static final int ANIM_SCALE = 2;
    private static final int TRANSLATE_DURATION_MILLIS = 250;
    private static final Interpolator mInterpolator = new AccelerateDecelerateInterpolator();

    static void scale(View group, View view, boolean visible) {
        AnimListener animListener = new AnimListener(group, visible);
        float scale = visible ? 1.0f : 0.0f;
        ViewPropertyAnimator.animate((View)view).setInterpolator(mInterpolator).setDuration(250L).scaleX(scale);
        ViewPropertyAnimator.animate((View)view).setInterpolator(mInterpolator).setDuration(250L).scaleY(scale).setListener((Animator.AnimatorListener)animListener);
    }

    static void translationY(View view, boolean visible, int height, int marginBottom) {
        int translationY = visible ? 0 : height + marginBottom;
        ViewPropertyAnimator.animate((View)view).setInterpolator(mInterpolator).setDuration(250L).translationY((float)translationY);
    }

    static void rotate(View view, boolean visible, int height, int marginBottom) {
        float rotateXBy = visible ? 500.0f : -500.0f;
        float rotateX = visible ? -30.0f : -30.0f;
        float rotateYBy = visible ? 0.0f : 0.0f;
        float rotateY = visible ? 30.0f : 390.0f;
        FabAnimationUtils.translationY(view, visible, height, marginBottom);
    }

    static class AnimListener
    implements Animator.AnimatorListener {
        private View view;
        private boolean visible;

        public AnimListener(View view, boolean visible) {
            this.view = view;
            this.visible = visible;
        }

        public void onAnimationStart(Animator animation) {
            this.view.setVisibility(0);
        }

        public void onAnimationEnd(Animator animation) {
            this.view.setVisibility(this.visible ? 0 : 8);
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }
}

