/*
 * Decompiled with CFR 0.152.
 */
package me.tittojose.www.timerangepicker_library;

import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TabHost;
import android.widget.TimePicker;
import me.tittojose.www.timerangepicker_library.R;

public class TimeRangePickerDialog
extends DialogFragment
implements View.OnClickListener {
    TabHost tabs;
    Button setTimeRange;
    TimePicker startTimePicker;
    TimePicker endTimePicker;
    OnTimeRangeSelectedListener onTimeRangeSelectedListener;
    boolean is24HourMode;

    public static TimeRangePickerDialog newInstance(OnTimeRangeSelectedListener callback, boolean is24HourMode) {
        TimeRangePickerDialog ret = new TimeRangePickerDialog();
        ret.initialize(callback, is24HourMode);
        return ret;
    }

    public void initialize(OnTimeRangeSelectedListener callback, boolean is24HourMode) {
        this.onTimeRangeSelectedListener = callback;
        this.is24HourMode = is24HourMode;
    }

    public void setOnTimeRangeSetListener(OnTimeRangeSelectedListener callback) {
        this.onTimeRangeSelectedListener = callback;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View root = inflater.inflate(R.layout.timerange_picker_dialog, container, false);
        this.getDialog().getWindow().requestFeature(1);
        this.tabs = (TabHost)root.findViewById(R.id.tabHost);
        this.setTimeRange = (Button)root.findViewById(R.id.bSetTimeRange);
        this.startTimePicker = (TimePicker)root.findViewById(R.id.startTimePicker);
        this.endTimePicker = (TimePicker)root.findViewById(R.id.endTimePicker);
        this.setTimeRange.setOnClickListener((View.OnClickListener)this);
        this.tabs.findViewById(R.id.tabHost);
        this.tabs.setup();
        TabHost.TabSpec tabpage1 = this.tabs.newTabSpec("one");
        tabpage1.setContent(R.id.startTimeGroup);
        tabpage1.setIndicator((CharSequence)"Start Time");
        TabHost.TabSpec tabpage2 = this.tabs.newTabSpec("two");
        tabpage2.setContent(R.id.endTimeGroup);
        tabpage2.setIndicator((CharSequence)"End Time");
        this.tabs.addTab(tabpage1);
        this.tabs.addTab(tabpage2);
        return root;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    public void onStart() {
        super.onStart();
        if (this.getDialog() == null) {
            return;
        }
        this.getDialog().getWindow().setLayout(-1, -2);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.bSetTimeRange) {
            this.dismiss();
            int startHour = this.startTimePicker.getCurrentHour();
            int startMin = this.startTimePicker.getCurrentMinute();
            int endHour = this.endTimePicker.getCurrentHour();
            int endMin = this.endTimePicker.getCurrentMinute();
            this.onTimeRangeSelectedListener.onTimeRangeSelected(startHour, startMin, endHour, endMin);
        }
    }

    public static interface OnTimeRangeSelectedListener {
        public void onTimeRangeSelected(int var1, int var2, int var3, int var4);
    }
}

