/*
 * Decompiled with CFR 0.152.
 */
package com.thekhaeng.library.uiadjustment.debug;

import android.content.Context;
import com.thekhaeng.library.uiadjustment.core.UIAdjustmentInterface;
import com.thekhaeng.library.uiadjustment.debug.DefaultLocalStorage;
import com.thekhaeng.library.uiadjustment.debug.adapter.item.BaseAdjustItem;
import com.thekhaeng.library.uiadjustment.debug.adapter.item.BooleanAdjustment;
import com.thekhaeng.library.uiadjustment.debug.adapter.item.ColorAdjustment;
import com.thekhaeng.library.uiadjustment.debug.adapter.item.IntegerAdjustment;
import com.thekhaeng.library.uiadjustment.debug.adapter.item.RangeFloatAdjustment;
import com.thekhaeng.library.uiadjustment.debug.adapter.item.StringAdjustment;
import com.thekhaeng.library.uiadjustment.debug.adapter.model.AdjustColor;
import com.thekhaeng.library.uiadjustment.debug.adapter.model.AdjustInteger;
import com.thekhaeng.library.uiadjustment.debug.adapter.model.AdjustString;
import java.util.ArrayList;
import java.util.List;

class UIAdjustmentDelegate {
    private final DefaultLocalStorage storage;
    private final UIAdjustmentInterface adjustInterface;
    private final Context context;
    private long delay = 0L;
    private boolean isUseLocalStorage = false;
    private boolean bindDataImmediately = false;
    private String title;

    UIAdjustmentDelegate(Context context, UIAdjustmentInterface adjustInterface) {
        this.context = context;
        this.storage = DefaultLocalStorage.getInstance(context);
        this.adjustInterface = adjustInterface;
    }

    void setTitle(String title) {
        this.title = title;
    }

    void setDelay(long delay) {
        this.delay = delay;
    }

    void setUseLocalStorage(boolean useLocalStorage) {
        this.isUseLocalStorage = useLocalStorage;
    }

    void setBindDataImmediately(boolean bindDataImmediately) {
        this.bindDataImmediately = bindDataImmediately;
    }

    List<BaseAdjustItem> copyItemList(List<BaseAdjustItem> itemList) {
        ArrayList<BaseAdjustItem> copyItemList = new ArrayList<BaseAdjustItem>();
        for (BaseAdjustItem item : itemList) {
            copyItemList.add(item.copy());
        }
        return copyItemList;
    }

    List<BaseAdjustItem> getItemList(List<BaseAdjustItem> defaultItemList) {
        if (this.isUseLocalStorage) {
            for (BaseAdjustItem item : defaultItemList) {
                Object data = item.isCommon() ? this.storage.load(item.getId() + "", item.getStorageClass()) : this.storage.load(this.getStorageKey(item.getId(), item.getType()), item.getStorageClass());
                if (data == null) continue;
                item.selectValue(data);
            }
        }
        return defaultItemList;
    }

    String getStorageKey(int id2, int type) {
        return this.getClass().getSimpleName() + "_" + id2 + "_" + type;
    }

    void bindData(List<BaseAdjustItem> itemList) {
        if (itemList != null) {
            for (BaseAdjustItem item : itemList) {
                AdjustString value;
                int id2 = item.getId();
                if (item instanceof BooleanAdjustment) {
                    boolean value2 = ((BooleanAdjustment)item).getValue();
                    if (this.isUseLocalStorage) {
                        if (item.isCommon()) {
                            this.storage.save(id2 + "", value2);
                        } else {
                            this.storage.save(this.getStorageKey(id2, 1), value2);
                        }
                    }
                    if (this.adjustInterface == null) continue;
                    this.adjustInterface.onBoolean(id2, value2);
                    continue;
                }
                if (item instanceof ColorAdjustment) {
                    AdjustColor value3 = ((ColorAdjustment)item).getValue();
                    if (value3 == null) continue;
                    int color = value3.getColor();
                    if (this.isUseLocalStorage) {
                        if (item.isCommon()) {
                            this.storage.save(id2 + "", color);
                        } else {
                            this.storage.save(this.getStorageKey(id2, 2), color);
                        }
                    }
                    if (this.adjustInterface == null) continue;
                    this.adjustInterface.onColor(id2, color);
                    continue;
                }
                if (item instanceof IntegerAdjustment) {
                    AdjustInteger value4 = ((IntegerAdjustment)item).getValue();
                    if (value4 == null) continue;
                    int intValue = value4.getValue();
                    if (this.isUseLocalStorage) {
                        if (item.isCommon()) {
                            this.storage.save(id2 + "", intValue);
                        } else {
                            this.storage.save(this.getStorageKey(id2, 3), intValue);
                        }
                    }
                    if (this.adjustInterface == null) continue;
                    this.adjustInterface.onInteger(id2, intValue);
                    continue;
                }
                if (item instanceof RangeFloatAdjustment) {
                    float currentValue = ((RangeFloatAdjustment)item).getValue().getCurrentValue();
                    if (this.isUseLocalStorage) {
                        if (item.isCommon()) {
                            this.storage.save(id2 + "", Float.valueOf(currentValue));
                        } else {
                            this.storage.save(this.getStorageKey(id2, 4), Float.valueOf(currentValue));
                        }
                    }
                    if (this.adjustInterface == null) continue;
                    this.adjustInterface.onRangeFloat(id2, currentValue);
                    continue;
                }
                if (!(item instanceof StringAdjustment) || (value = ((StringAdjustment)item).getValue()) == null) continue;
                String stringValue = value.getValue();
                if (this.isUseLocalStorage) {
                    if (item.isCommon()) {
                        this.storage.save(id2 + "", stringValue);
                    } else {
                        this.storage.save(this.getStorageKey(id2, 5), stringValue);
                    }
                }
                if (this.adjustInterface == null) continue;
                this.adjustInterface.onString(id2, stringValue);
            }
        }
    }

    String getTitle() {
        return this.title;
    }

    long getDelay() {
        return this.delay;
    }

    boolean isUseLocalStorage() {
        return this.isUseLocalStorage;
    }

    boolean isBindDataImmediately() {
        return this.bindDataImmediately;
    }
}

