/*
 * Decompiled with CFR 0.152.
 */
package com.thekhaeng.library.uiadjustment.debug.adapter.item;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.view.View;
import com.thekhaeng.library.uiadjustment.debug.adapter.item.BaseAdjustItem;
import com.thekhaeng.library.uiadjustment.debug.adapter.model.AdjustColor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ColorAdjustment
extends BaseAdjustItem<AdjustColor> {
    private Map<String, AdjustColor> mapColor = new LinkedHashMap<String, AdjustColor>();
    public static final Parcelable.Creator<ColorAdjustment> CREATOR = new Parcelable.Creator<ColorAdjustment>(){

        public ColorAdjustment createFromParcel(Parcel source) {
            return new ColorAdjustment(source);
        }

        public ColorAdjustment[] newArray(int size) {
            return new ColorAdjustment[size];
        }
    };

    public static ColorAdjustment create(@NonNull View view, String title, Map<String, AdjustColor> map) {
        return ColorAdjustment.create(view.getId(), title, map, false);
    }

    public static ColorAdjustment create(@IdRes int id2, String title, Map<String, AdjustColor> map) {
        return ColorAdjustment.create(id2, title, map, false);
    }

    public static ColorAdjustment create(@NonNull View view, String title, Map<String, AdjustColor> map, boolean isCommon) {
        return ColorAdjustment.create(view.getId(), title, map, isCommon);
    }

    public static ColorAdjustment create(@IdRes int id2, String title, Map<String, AdjustColor> map, boolean isCommon) {
        if (map == null || map.isEmpty()) {
            return new ColorAdjustment(id2);
        }
        return new ColorAdjustment(id2, title, map, isCommon);
    }

    private ColorAdjustment(int id2) {
        super(id2, "EMPTY", 2, false);
    }

    private ColorAdjustment(int id2, String title, Map<String, AdjustColor> map, boolean isCommon) {
        super(id2, title, 2, isCommon);
        this.mapColor = map;
    }

    public void setMapColor(Map<String, AdjustColor> mapColor) {
        this.mapColor = mapColor;
    }

    public Map<String, AdjustColor> getMapColor() {
        return this.mapColor;
    }

    public AdjustColor getValue() {
        for (Map.Entry<String, AdjustColor> entry : this.mapColor.entrySet()) {
            AdjustColor value = entry.getValue();
            if (!value.isSelected()) continue;
            return value;
        }
        return null;
    }

    private void unSelectAll() {
        for (Map.Entry<String, AdjustColor> entry : this.mapColor.entrySet()) {
            entry.getValue().setSelected(false);
        }
    }

    @Override
    public Class<AdjustColor> getStorageClass() {
        return AdjustColor.class;
    }

    @Override
    public ColorAdjustment copy() {
        LinkedHashMap<String, AdjustColor> copyMapColor = new LinkedHashMap<String, AdjustColor>();
        for (Map.Entry<String, AdjustColor> entry : this.mapColor.entrySet()) {
            copyMapColor.put(entry.getKey(), entry.getValue().copy());
        }
        return new ColorAdjustment(this.getId(), this.getTitle(), copyMapColor, this.isCommon());
    }

    @Override
    public void selectValue(Object object) {
        if (object instanceof AdjustColor) {
            AdjustColor adjustColor = (AdjustColor)object;
            for (Map.Entry<String, AdjustColor> entry : this.mapColor.entrySet()) {
                if (!entry.getValue().equals(adjustColor)) continue;
                this.unSelectAll();
                entry.getValue().setSelected(true);
                return;
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.mapColor.size());
        for (Map.Entry<String, AdjustColor> entry : this.mapColor.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeParcelable((Parcelable)entry.getValue(), flags);
        }
    }

    protected ColorAdjustment(Parcel in) {
        super(in);
        int mapColorSize = in.readInt();
        this.mapColor = new HashMap<String, AdjustColor>(mapColorSize);
        for (int i = 0; i < mapColorSize; ++i) {
            String key = in.readString();
            AdjustColor value = (AdjustColor)in.readParcelable(AdjustColor.class.getClassLoader());
            this.mapColor.put(key, value);
        }
    }
}

