/*
 * Decompiled with CFR 0.152.
 */
package com.thekhaeng.library.uiadjustment.debug.adapter.holder;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.v7.widget.AppCompatTextView;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.thekhaeng.library.uiadjustment.debug.R;
import com.thekhaeng.library.uiadjustment.debug.adapter.holder.BaseAdjustViewHolder;
import com.thekhaeng.library.uiadjustment.debug.adapter.item.ColorAdjustment;
import com.thekhaeng.library.uiadjustment.debug.adapter.layout.CenterLayoutManager;
import com.thekhaeng.library.uiadjustment.debug.adapter.model.AdjustColor;
import com.thekhaeng.library.uiadjustment.debug.widget.SingleColorDrawable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ColorAdjustHolder
extends BaseAdjustViewHolder<ColorAdjustment> {
    private AppCompatTextView tvCommon;
    private AppCompatTextView tvTitle;
    private ColorAdapter adapter;
    private RecyclerView rvColor;

    public ColorAdjustHolder(ViewGroup parent) {
        super(parent, R.layout.library_holder_adjust_color);
    }

    @Override
    public void onBindView(View view) {
        this.tvCommon = (AppCompatTextView)view.findViewById(R.id.library_holder_tv_common);
        this.tvTitle = (AppCompatTextView)view.findViewById(R.id.library_holder_tv_title);
        this.rvColor = (RecyclerView)view.findViewById(R.id.library_holder_rv_color);
        this.rvColor.setLayoutManager((RecyclerView.LayoutManager)new CenterLayoutManager(this.getContext(), 0, false));
        this.adapter = new ColorAdapter(view.getContext());
        this.rvColor.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    @Override
    public void onBind(ColorAdjustment item) {
        super.onBind(item);
        if (item.isCommon()) {
            this.tvCommon.setVisibility(0);
        } else {
            this.tvCommon.setVisibility(8);
        }
        ArrayList<AdjustColor> colorList = new ArrayList<AdjustColor>();
        for (Map.Entry<String, AdjustColor> entry : item.getMapColor().entrySet()) {
            colorList.add(entry.getValue());
        }
        this.tvTitle.setText((CharSequence)item.getTitle());
        this.adapter.setColorList(colorList);
        this.rvColor.scrollToPosition(this.adapter.getCheckPosition());
    }

    private static class ColorViewHolder
    extends RecyclerView.ViewHolder {
        private final ImageView imageView;
        private final SingleColorDrawable drawable;
        private AdjustColor color;

        ColorViewHolder(ViewGroup parent) {
            super(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.library_holder_widget_color, parent, false));
            this.imageView = (ImageView)this.itemView;
            this.drawable = new SingleColorDrawable(parent.getContext());
            this.imageView.setImageDrawable((Drawable)this.drawable);
        }

        void setAdjustColor(AdjustColor colorItem) {
            this.color = colorItem;
            this.drawable.setColorItem(this.itemView.getContext(), colorItem);
            this.imageView.invalidate();
        }

        void setOnClickColorViewHolder(final OnClickColorViewHolder listener) {
            this.imageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (listener != null) {
                        listener.onClick(ColorViewHolder.this, ColorViewHolder.this.color.getColor());
                    }
                }
            });
        }

        static interface OnClickColorViewHolder {
            public void onClick(ColorViewHolder var1, @ColorInt int var2);
        }
    }

    private static class ColorAdapter
    extends RecyclerView.Adapter<ColorViewHolder> {
        private List<AdjustColor> colorList = new ArrayList<AdjustColor>();
        private Context context;

        public ColorAdapter(Context context) {
            this.context = context;
        }

        public void setColorList(List<AdjustColor> colorList) {
            this.colorList = colorList;
            this.notifyDataSetChanged();
        }

        void selectColor(@ColorInt int color) {
            for (AdjustColor item : this.colorList) {
                item.setSelected(item.getColor() == color);
            }
            this.notifyDataSetChanged();
        }

        public ColorViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            ColorViewHolder viewHolder = new ColorViewHolder(parent);
            viewHolder.setOnClickColorViewHolder(this.setOnClickColorViewHolderListener());
            return viewHolder;
        }

        public void onBindViewHolder(ColorViewHolder holder, int position) {
            holder.setAdjustColor(this.colorList.get(position));
        }

        public int getItemCount() {
            return this.colorList.size();
        }

        List<AdjustColor> getColorList() {
            return this.colorList;
        }

        int getCheckPosition() {
            for (int i = 0; i < this.getColorList().size(); ++i) {
                if (!this.getColorList().get(i).isSelected()) continue;
                return i;
            }
            return -1;
        }

        @NonNull
        private ColorViewHolder.OnClickColorViewHolder setOnClickColorViewHolderListener() {
            return new ColorViewHolder.OnClickColorViewHolder(){

                @Override
                public void onClick(ColorViewHolder vh, int color) {
                    ColorAdapter.this.selectColor(color);
                }
            };
        }
    }
}

