/*
 * Decompiled with CFR 0.152.
 */
package com.thekhaeng.materialdesign.metric;

import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0004\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u000e\u0010\b\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004\u00a8\u0006\r"}, d2={"dpToPx", "", "dp", "px", "", "dpToPxInt", "pxToDp", "pxToDpInt", "pxToSp", "pxToSpInt", "spToPx", "sp", "spToPxInt", "material-design-metric_release"})
@JvmName(name="Density")
public final class Density {
    public static final float spToPx(float sp) {
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        return TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public static final float spToPx(int px) {
        return Density.spToPx((float)px);
    }

    public static final int spToPxInt(float sp) {
        return Math.round(Density.spToPx(sp));
    }

    public static final int spToPxInt(int sp) {
        return Math.round(Density.spToPx(sp));
    }

    public static final float dpToPx(float dp) {
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public static final float dpToPx(int px) {
        return Density.dpToPx((float)px);
    }

    public static final int dpToPxInt(float dp) {
        return Math.round(Density.dpToPx(dp));
    }

    public static final int dpToPxInt(int dp) {
        return Math.round(Density.dpToPx(dp));
    }

    public static final float pxToDp(float px) {
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        return px / resources.getDisplayMetrics().density;
    }

    public static final float pxToDp(int px) {
        return Density.pxToDp((float)px);
    }

    public static final int pxToDpInt(float px) {
        return Math.round(Density.pxToDp(px));
    }

    public static final int pxToDpInt(int px) {
        return Math.round(Density.pxToDp(px));
    }

    public static final float pxToSp(float px) {
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        return px / resources.getDisplayMetrics().scaledDensity;
    }

    public static final float pxToSp(int px) {
        return Density.pxToSp((float)px);
    }

    public static final int pxToSpInt(float px) {
        return Math.round(Density.pxToSp(px));
    }

    public static final int pxToSpInt(int px) {
        return Math.round(Density.pxToSp(px));
    }
}

