/*
 * Decompiled with CFR 0.152.
 */
package com.github.testpress.mikephil.charting.data;

import com.github.testpress.mikephil.charting.data.BarEntry;
import com.github.testpress.mikephil.charting.data.BarLineScatterCandleBubbleData;
import com.github.testpress.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.testpress.mikephil.charting.interfaces.datasets.IBarLineScatterCandleBubbleDataSet;
import java.util.List;

public class BarData
extends BarLineScatterCandleBubbleData<IBarDataSet> {
    private float mBarWidth = 1.0f;

    public BarData() {
    }

    public BarData(IBarDataSet ... dataSets) {
        super((IBarLineScatterCandleBubbleDataSet[])dataSets);
    }

    public BarData(List<IBarDataSet> dataSets) {
        super(dataSets);
    }

    public void setBarWidth(float mBarWidth) {
        this.mBarWidth = mBarWidth;
    }

    public float getBarWidth() {
        return this.mBarWidth;
    }

    public void groupBars(float fromX, float groupSpace, float barSpace) {
        int setCount = this.mDataSets.size();
        if (setCount <= 1) {
            throw new RuntimeException("BarData needs to hold at least 2 BarDataSets to allow grouping.");
        }
        IBarDataSet max = (IBarDataSet)this.getMaxEntryCountSet();
        int maxEntryCount = max.getEntryCount();
        float groupSpaceWidthHalf = groupSpace / 2.0f;
        float barSpaceHalf = barSpace / 2.0f;
        float barWidthHalf = this.mBarWidth / 2.0f;
        float interval = this.getGroupWidth(groupSpace, barSpace);
        for (int i = 0; i < maxEntryCount; ++i) {
            float start = fromX;
            fromX += groupSpaceWidthHalf;
            int setCountJ = this.mDataSets.size();
            for (int j = 0; j < setCountJ; ++j) {
                BarEntry entry;
                IBarDataSet set = (IBarDataSet)this.mDataSets.get(j);
                fromX += barSpaceHalf;
                fromX += barWidthHalf;
                if (i < set.getEntryCount() && (entry = (BarEntry)set.getEntryForIndex(i)) != null) {
                    entry.setX(fromX);
                }
                fromX += barWidthHalf;
                fromX += barSpaceHalf;
            }
            float end = fromX += groupSpaceWidthHalf;
            float innerInterval = end - start;
            float diff = interval - innerInterval;
            if (!(diff > 0.0f) && !(diff < 0.0f)) continue;
            fromX += diff;
        }
        this.notifyDataChanged();
    }

    public float getGroupWidth(float groupSpace, float barSpace) {
        return (float)this.mDataSets.size() * (this.mBarWidth + barSpace) + groupSpace;
    }
}

