/*
 * Decompiled with CFR 0.152.
 */
package com.github.testpress.mikephil.charting.charts;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.github.testpress.mikephil.charting.charts.Chart;
import com.github.testpress.mikephil.charting.components.XAxis;
import com.github.testpress.mikephil.charting.components.YAxis;
import com.github.testpress.mikephil.charting.data.BarLineScatterCandleBubbleData;
import com.github.testpress.mikephil.charting.data.Entry;
import com.github.testpress.mikephil.charting.highlight.ChartHighlighter;
import com.github.testpress.mikephil.charting.highlight.Highlight;
import com.github.testpress.mikephil.charting.interfaces.dataprovider.BarLineScatterCandleBubbleDataProvider;
import com.github.testpress.mikephil.charting.interfaces.datasets.IBarLineScatterCandleBubbleDataSet;
import com.github.testpress.mikephil.charting.jobs.AnimatedMoveViewJob;
import com.github.testpress.mikephil.charting.jobs.AnimatedZoomJob;
import com.github.testpress.mikephil.charting.jobs.MoveViewJob;
import com.github.testpress.mikephil.charting.jobs.ZoomJob;
import com.github.testpress.mikephil.charting.listener.BarLineChartTouchListener;
import com.github.testpress.mikephil.charting.listener.OnDrawListener;
import com.github.testpress.mikephil.charting.renderer.XAxisRenderer;
import com.github.testpress.mikephil.charting.renderer.YAxisRenderer;
import com.github.testpress.mikephil.charting.utils.MPPointD;
import com.github.testpress.mikephil.charting.utils.MPPointF;
import com.github.testpress.mikephil.charting.utils.Transformer;
import com.github.testpress.mikephil.charting.utils.Utils;

@SuppressLint(value={"RtlHardcoded"})
public abstract class BarLineChartBase<T extends BarLineScatterCandleBubbleData<? extends IBarLineScatterCandleBubbleDataSet<? extends Entry>>>
extends Chart<T>
implements BarLineScatterCandleBubbleDataProvider {
    protected int mMaxVisibleCount = 100;
    protected boolean mAutoScaleMinMaxEnabled = false;
    private Float mAutoScaleLastLowestVisibleXIndex = null;
    private Float mAutoScaleLastHighestVisibleXIndex = null;
    protected boolean mPinchZoomEnabled = false;
    protected boolean mDoubleTapToZoomEnabled = true;
    protected boolean mHighlightPerDragEnabled = true;
    private boolean mDragEnabled = true;
    private boolean mScaleXEnabled = true;
    private boolean mScaleYEnabled = true;
    protected Paint mGridBackgroundPaint;
    protected Paint mBorderPaint;
    protected boolean mDrawGridBackground = false;
    protected boolean mDrawBorders = false;
    protected float mMinOffset = 15.0f;
    protected boolean mKeepPositionOnRotation = false;
    protected OnDrawListener mDrawListener;
    protected YAxis mAxisLeft;
    protected YAxis mAxisRight;
    protected YAxisRenderer mAxisRendererLeft;
    protected YAxisRenderer mAxisRendererRight;
    protected Transformer mLeftAxisTransformer;
    protected Transformer mRightAxisTransformer;
    protected XAxisRenderer mXAxisRenderer;
    private long totalTime = 0L;
    private long drawCycles = 0L;
    private RectF mOffsetsBuffer = new RectF();
    protected Matrix mZoomInMatrixBuffer = new Matrix();
    protected Matrix mZoomOutMatrixBuffer = new Matrix();
    protected Matrix mZoomMatrixBuffer = new Matrix();
    protected Matrix mFitScreenMatrixBuffer = new Matrix();
    private boolean mCustomViewPortEnabled = false;
    protected float[] mGetPositionBuffer = new float[2];
    MPPointD pointForGetYValueByTouchPoint = MPPointD.getInstance(0.0, 0.0);
    protected MPPointD posForGetLowestVisibleX = MPPointD.getInstance(0.0, 0.0);
    protected MPPointD posForGetHighestVisibleX = MPPointD.getInstance(0.0, 0.0);
    protected float[] mOnSizeChangedBuffer = new float[2];

    public BarLineChartBase(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public BarLineChartBase(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BarLineChartBase(Context context) {
        super(context);
    }

    @Override
    protected void init() {
        super.init();
        this.mAxisLeft = new YAxis(YAxis.AxisDependency.LEFT);
        this.mAxisRight = new YAxis(YAxis.AxisDependency.RIGHT);
        this.mLeftAxisTransformer = new Transformer(this.mViewPortHandler);
        this.mRightAxisTransformer = new Transformer(this.mViewPortHandler);
        this.mAxisRendererLeft = new YAxisRenderer(this.mViewPortHandler, this.mAxisLeft, this.mLeftAxisTransformer);
        this.mAxisRendererRight = new YAxisRenderer(this.mViewPortHandler, this.mAxisRight, this.mRightAxisTransformer);
        this.mXAxisRenderer = new XAxisRenderer(this.mViewPortHandler, this.mXAxis, this.mLeftAxisTransformer);
        this.setHighlighter(new ChartHighlighter<BarLineChartBase>(this));
        this.mChartTouchListener = new BarLineChartTouchListener(this, this.mViewPortHandler.getMatrixTouch(), 3.0f);
        this.mGridBackgroundPaint = new Paint();
        this.mGridBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mGridBackgroundPaint.setColor(Color.rgb((int)240, (int)240, (int)240));
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setColor(-16777216);
        this.mBorderPaint.setStrokeWidth(Utils.convertDpToPixel(1.0f));
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mData == null) {
            return;
        }
        long starttime = System.currentTimeMillis();
        this.drawGridBackground(canvas);
        if (this.mAxisLeft.isEnabled()) {
            this.mAxisRendererLeft.computeAxis(this.mAxisLeft.mAxisMinimum, this.mAxisLeft.mAxisMaximum, this.mAxisLeft.isInverted());
        }
        if (this.mAxisRight.isEnabled()) {
            this.mAxisRendererRight.computeAxis(this.mAxisRight.mAxisMinimum, this.mAxisRight.mAxisMaximum, this.mAxisRight.isInverted());
        }
        if (this.mXAxis.isEnabled()) {
            this.mXAxisRenderer.computeAxis(this.mXAxis.mAxisMinimum, this.mXAxis.mAxisMaximum, false);
        }
        this.mXAxisRenderer.renderAxisLine(canvas);
        this.mAxisRendererLeft.renderAxisLine(canvas);
        this.mAxisRendererRight.renderAxisLine(canvas);
        if (this.mAutoScaleMinMaxEnabled) {
            float lowestVisibleXIndex = this.getLowestVisibleX();
            float highestVisibleXIndex = this.getHighestVisibleX();
            if (this.mAutoScaleLastLowestVisibleXIndex == null || this.mAutoScaleLastLowestVisibleXIndex.floatValue() != lowestVisibleXIndex || this.mAutoScaleLastHighestVisibleXIndex == null || this.mAutoScaleLastHighestVisibleXIndex.floatValue() != highestVisibleXIndex) {
                this.calcMinMax();
                this.calculateOffsets();
                this.mAutoScaleLastLowestVisibleXIndex = Float.valueOf(lowestVisibleXIndex);
                this.mAutoScaleLastHighestVisibleXIndex = Float.valueOf(highestVisibleXIndex);
            }
        }
        int clipRestoreCount = canvas.save();
        canvas.clipRect(this.mViewPortHandler.getContentRect());
        this.mXAxisRenderer.renderGridLines(canvas);
        this.mAxisRendererLeft.renderGridLines(canvas);
        this.mAxisRendererRight.renderGridLines(canvas);
        if (this.mXAxis.isDrawLimitLinesBehindDataEnabled()) {
            this.mXAxisRenderer.renderLimitLines(canvas);
        }
        if (this.mAxisLeft.isDrawLimitLinesBehindDataEnabled()) {
            this.mAxisRendererLeft.renderLimitLines(canvas);
        }
        if (this.mAxisRight.isDrawLimitLinesBehindDataEnabled()) {
            this.mAxisRendererRight.renderLimitLines(canvas);
        }
        this.mRenderer.drawData(canvas);
        if (this.valuesToHighlight()) {
            this.mRenderer.drawHighlighted(canvas, this.mIndicesToHighlight);
        }
        canvas.restoreToCount(clipRestoreCount);
        this.mRenderer.drawExtras(canvas);
        clipRestoreCount = canvas.save();
        canvas.clipRect(this.mViewPortHandler.getContentRect());
        if (!this.mXAxis.isDrawLimitLinesBehindDataEnabled()) {
            this.mXAxisRenderer.renderLimitLines(canvas);
        }
        if (!this.mAxisLeft.isDrawLimitLinesBehindDataEnabled()) {
            this.mAxisRendererLeft.renderLimitLines(canvas);
        }
        if (!this.mAxisRight.isDrawLimitLinesBehindDataEnabled()) {
            this.mAxisRendererRight.renderLimitLines(canvas);
        }
        canvas.restoreToCount(clipRestoreCount);
        this.mXAxisRenderer.renderAxisLabels(canvas);
        this.mAxisRendererLeft.renderAxisLabels(canvas);
        this.mAxisRendererRight.renderAxisLabels(canvas);
        this.mRenderer.drawValues(canvas);
        this.mLegendRenderer.renderLegend(canvas);
        this.drawMarkers(canvas);
        this.drawDescription(canvas);
        if (this.mLogEnabled) {
            long drawtime = System.currentTimeMillis() - starttime;
            this.totalTime += drawtime;
            ++this.drawCycles;
            long average = this.totalTime / this.drawCycles;
            Log.i((String)"MPAndroidChart", (String)("Drawtime: " + drawtime + " ms, average: " + average + " ms, cycles: " + this.drawCycles));
        }
    }

    public void resetTracking() {
        this.totalTime = 0L;
        this.drawCycles = 0L;
    }

    protected void prepareValuePxMatrix() {
        if (this.mLogEnabled) {
            Log.i((String)"MPAndroidChart", (String)("Preparing Value-Px Matrix, xmin: " + this.mXAxis.mAxisMinimum + ", xmax: " + this.mXAxis.mAxisMaximum + ", xdelta: " + this.mXAxis.mAxisRange));
        }
        this.mRightAxisTransformer.prepareMatrixValuePx(this.mXAxis.mAxisMinimum, this.mXAxis.mAxisRange, this.mAxisRight.mAxisRange, this.mAxisRight.mAxisMinimum);
        this.mLeftAxisTransformer.prepareMatrixValuePx(this.mXAxis.mAxisMinimum, this.mXAxis.mAxisRange, this.mAxisLeft.mAxisRange, this.mAxisLeft.mAxisMinimum);
    }

    protected void prepareOffsetMatrix() {
        this.mRightAxisTransformer.prepareMatrixOffset(this.mAxisRight.isInverted());
        this.mLeftAxisTransformer.prepareMatrixOffset(this.mAxisLeft.isInverted());
    }

    @Override
    public void notifyDataSetChanged() {
        if (this.mData == null) {
            if (this.mLogEnabled) {
                Log.i((String)"MPAndroidChart", (String)"Preparing... DATA NOT SET.");
            }
            return;
        }
        if (this.mLogEnabled) {
            Log.i((String)"MPAndroidChart", (String)"Preparing...");
        }
        if (this.mRenderer != null) {
            this.mRenderer.initBuffers();
        }
        this.calcMinMax();
        this.mAxisRendererLeft.computeAxis(this.mAxisLeft.mAxisMinimum, this.mAxisLeft.mAxisMaximum, this.mAxisLeft.isInverted());
        this.mAxisRendererRight.computeAxis(this.mAxisRight.mAxisMinimum, this.mAxisRight.mAxisMaximum, this.mAxisRight.isInverted());
        this.mXAxisRenderer.computeAxis(this.mXAxis.mAxisMinimum, this.mXAxis.mAxisMaximum, false);
        if (this.mLegend != null) {
            this.mLegendRenderer.computeLegend(this.mData);
        }
        this.calculateOffsets();
    }

    @Override
    protected void calcMinMax() {
        if (this.mAutoScaleMinMaxEnabled) {
            ((BarLineScatterCandleBubbleData)this.mData).calcMinMax();
        }
        this.mXAxis.calculate(((BarLineScatterCandleBubbleData)this.mData).getXMin(), ((BarLineScatterCandleBubbleData)this.mData).getXMax());
        this.mAxisLeft.calculate(((BarLineScatterCandleBubbleData)this.mData).getYMin(YAxis.AxisDependency.LEFT), ((BarLineScatterCandleBubbleData)this.mData).getYMax(YAxis.AxisDependency.LEFT));
        this.mAxisRight.calculate(((BarLineScatterCandleBubbleData)this.mData).getYMin(YAxis.AxisDependency.RIGHT), ((BarLineScatterCandleBubbleData)this.mData).getYMax(YAxis.AxisDependency.RIGHT));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void calculateLegendOffsets(RectF offsets) {
        offsets.left = 0.0f;
        offsets.right = 0.0f;
        offsets.top = 0.0f;
        offsets.bottom = 0.0f;
        if (this.mLegend == null) return;
        if (!this.mLegend.isEnabled()) return;
        if (this.mLegend.isDrawInsideEnabled()) return;
        switch (this.mLegend.getOrientation()) {
            case VERTICAL: {
                switch (this.mLegend.getHorizontalAlignment()) {
                    case LEFT: {
                        offsets.left += Math.min(this.mLegend.mNeededWidth, this.mViewPortHandler.getChartWidth() * this.mLegend.getMaxSizePercent()) + this.mLegend.getXOffset();
                        return;
                    }
                    case RIGHT: {
                        offsets.right += Math.min(this.mLegend.mNeededWidth, this.mViewPortHandler.getChartWidth() * this.mLegend.getMaxSizePercent()) + this.mLegend.getXOffset();
                        return;
                    }
                    case CENTER: {
                        switch (this.mLegend.getVerticalAlignment()) {
                            case TOP: {
                                offsets.top += Math.min(this.mLegend.mNeededHeight, this.mViewPortHandler.getChartHeight() * this.mLegend.getMaxSizePercent()) + this.mLegend.getYOffset();
                                if (!this.getXAxis().isEnabled() || !this.getXAxis().isDrawLabelsEnabled()) return;
                                offsets.top += (float)this.getXAxis().mLabelRotatedHeight;
                                break;
                            }
                            case BOTTOM: {
                                offsets.bottom += Math.min(this.mLegend.mNeededHeight, this.mViewPortHandler.getChartHeight() * this.mLegend.getMaxSizePercent()) + this.mLegend.getYOffset();
                                if (!this.getXAxis().isEnabled() || !this.getXAxis().isDrawLabelsEnabled()) return;
                                offsets.bottom += (float)this.getXAxis().mLabelRotatedHeight;
                                break;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            case HORIZONTAL: {
                switch (this.mLegend.getVerticalAlignment()) {
                    case TOP: {
                        offsets.top += Math.min(this.mLegend.mNeededHeight, this.mViewPortHandler.getChartHeight() * this.mLegend.getMaxSizePercent()) + this.mLegend.getYOffset();
                        if (!this.getXAxis().isEnabled()) return;
                        if (!this.getXAxis().isDrawLabelsEnabled()) return;
                        offsets.top += (float)this.getXAxis().mLabelRotatedHeight;
                        return;
                    }
                    case BOTTOM: {
                        offsets.bottom += Math.min(this.mLegend.mNeededHeight, this.mViewPortHandler.getChartHeight() * this.mLegend.getMaxSizePercent()) + this.mLegend.getYOffset();
                        if (!this.getXAxis().isEnabled()) return;
                        if (!this.getXAxis().isDrawLabelsEnabled()) return;
                        offsets.bottom += (float)this.getXAxis().mLabelRotatedHeight;
                        return;
                    }
                }
                return;
            }
        }
    }

    @Override
    public void calculateOffsets() {
        if (!this.mCustomViewPortEnabled) {
            float offsetLeft = 0.0f;
            float offsetRight = 0.0f;
            float offsetTop = 0.0f;
            float offsetBottom = 0.0f;
            this.calculateLegendOffsets(this.mOffsetsBuffer);
            offsetLeft += this.mOffsetsBuffer.left;
            offsetTop += this.mOffsetsBuffer.top;
            offsetRight += this.mOffsetsBuffer.right;
            offsetBottom += this.mOffsetsBuffer.bottom;
            if (this.mAxisLeft.needsOffset()) {
                offsetLeft += this.mAxisLeft.getRequiredWidthSpace(this.mAxisRendererLeft.getPaintAxisLabels());
            }
            if (this.mAxisRight.needsOffset()) {
                offsetRight += this.mAxisRight.getRequiredWidthSpace(this.mAxisRendererRight.getPaintAxisLabels());
            }
            if (this.mXAxis.isEnabled() && this.mXAxis.isDrawLabelsEnabled()) {
                float xlabelheight = (float)this.mXAxis.mLabelRotatedHeight + this.mXAxis.getYOffset();
                if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTTOM) {
                    offsetBottom += xlabelheight;
                } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.TOP) {
                    offsetTop += xlabelheight;
                } else if (this.mXAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
                    offsetBottom += xlabelheight;
                    offsetTop += xlabelheight;
                }
            }
            float minOffset = Utils.convertDpToPixel(this.mMinOffset);
            this.mViewPortHandler.restrainViewPort(Math.max(minOffset, offsetLeft += this.getExtraLeftOffset()), Math.max(minOffset, offsetTop += this.getExtraTopOffset()), Math.max(minOffset, offsetRight += this.getExtraRightOffset()), Math.max(minOffset, offsetBottom += this.getExtraBottomOffset()));
            if (this.mLogEnabled) {
                Log.i((String)"MPAndroidChart", (String)("offsetLeft: " + offsetLeft + ", offsetTop: " + offsetTop + ", offsetRight: " + offsetRight + ", offsetBottom: " + offsetBottom));
                Log.i((String)"MPAndroidChart", (String)("Content: " + this.mViewPortHandler.getContentRect().toString()));
            }
        }
        this.prepareOffsetMatrix();
        this.prepareValuePxMatrix();
    }

    protected void drawGridBackground(Canvas c) {
        if (this.mDrawGridBackground) {
            c.drawRect(this.mViewPortHandler.getContentRect(), this.mGridBackgroundPaint);
        }
        if (this.mDrawBorders) {
            c.drawRect(this.mViewPortHandler.getContentRect(), this.mBorderPaint);
        }
    }

    @Override
    public Transformer getTransformer(YAxis.AxisDependency which) {
        if (which == YAxis.AxisDependency.LEFT) {
            return this.mLeftAxisTransformer;
        }
        return this.mRightAxisTransformer;
    }

    public boolean onTouchEvent(MotionEvent event) {
        super.onTouchEvent(event);
        if (this.mChartTouchListener == null || this.mData == null) {
            return false;
        }
        if (!this.mTouchEnabled) {
            return false;
        }
        return this.mChartTouchListener.onTouch((View)this, event);
    }

    public void computeScroll() {
        if (this.mChartTouchListener instanceof BarLineChartTouchListener) {
            ((BarLineChartTouchListener)this.mChartTouchListener).computeScroll();
        }
    }

    public void zoomIn() {
        MPPointF center = this.mViewPortHandler.getContentCenter();
        this.mViewPortHandler.zoomIn(center.x, -center.y, this.mZoomInMatrixBuffer);
        this.mViewPortHandler.refresh(this.mZoomInMatrixBuffer, (View)this, false);
        MPPointF.recycleInstance(center);
        this.calculateOffsets();
        this.postInvalidate();
    }

    public void zoomOut() {
        MPPointF center = this.mViewPortHandler.getContentCenter();
        this.mViewPortHandler.zoomOut(center.x, -center.y, this.mZoomOutMatrixBuffer);
        this.mViewPortHandler.refresh(this.mZoomOutMatrixBuffer, (View)this, false);
        MPPointF.recycleInstance(center);
        this.calculateOffsets();
        this.postInvalidate();
    }

    public void zoom(float scaleX, float scaleY, float x, float y) {
        Matrix save = this.mZoomMatrixBuffer;
        this.mViewPortHandler.zoom(scaleX, scaleY, x, y, save);
        this.mViewPortHandler.refresh(save, (View)this, false);
        this.calculateOffsets();
        this.postInvalidate();
    }

    public void zoomAndCenter(float scaleX, float scaleY, float xValue, float yValue, YAxis.AxisDependency axis) {
        ZoomJob job = ZoomJob.getInstance(this.mViewPortHandler, scaleX, scaleY, xValue, yValue, this.getTransformer(axis), axis, (View)this);
        this.addViewportJob(job);
    }

    @TargetApi(value=11)
    public void zoomAndCenterAnimated(float scaleX, float scaleY, float xValue, float yValue, YAxis.AxisDependency axis, long duration) {
        if (Build.VERSION.SDK_INT >= 11) {
            MPPointD origin = this.getValuesByTouchPoint(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop(), axis);
            AnimatedZoomJob job = AnimatedZoomJob.getInstance(this.mViewPortHandler, (View)this, this.getTransformer(axis), this.getAxis(axis), this.mXAxis.mAxisRange, scaleX, scaleY, this.mViewPortHandler.getScaleX(), this.mViewPortHandler.getScaleY(), xValue, yValue, (float)origin.x, (float)origin.y, duration);
            this.addViewportJob(job);
            MPPointD.recycleInstance(origin);
        } else {
            Log.e((String)"MPAndroidChart", (String)"Unable to execute zoomAndCenterAnimated(...) on API level < 11");
        }
    }

    public void fitScreen() {
        Matrix save = this.mFitScreenMatrixBuffer;
        this.mViewPortHandler.fitScreen(save);
        this.mViewPortHandler.refresh(save, (View)this, false);
        this.calculateOffsets();
        this.postInvalidate();
    }

    public void setScaleMinima(float scaleX, float scaleY) {
        this.mViewPortHandler.setMinimumScaleX(scaleX);
        this.mViewPortHandler.setMinimumScaleY(scaleY);
    }

    public void setVisibleXRangeMaximum(float maxXRange) {
        float xScale = this.mXAxis.mAxisRange / maxXRange;
        this.mViewPortHandler.setMinimumScaleX(xScale);
    }

    public void setVisibleXRangeMinimum(float minXRange) {
        float xScale = this.mXAxis.mAxisRange / minXRange;
        this.mViewPortHandler.setMaximumScaleX(xScale);
    }

    public void setVisibleXRange(float minXRange, float maxXRange) {
        float minScale = this.mXAxis.mAxisRange / minXRange;
        float maxScale = this.mXAxis.mAxisRange / maxXRange;
        this.mViewPortHandler.setMinMaxScaleX(minScale, maxScale);
    }

    public void setVisibleYRangeMaximum(float maxYRange, YAxis.AxisDependency axis) {
        float yScale = this.getDeltaY(axis) / maxYRange;
        this.mViewPortHandler.setMinimumScaleY(yScale);
    }

    public void setVisibleYRangeMinimum(float minYRange, YAxis.AxisDependency axis) {
        float yScale = this.getDeltaY(axis) / minYRange;
        this.mViewPortHandler.setMaximumScaleY(yScale);
    }

    public void setVisibleYRange(float minYRange, float maxYRange, YAxis.AxisDependency axis) {
        float minScale = this.getDeltaY(axis) / minYRange;
        float maxScale = this.getDeltaY(axis) / maxYRange;
        this.mViewPortHandler.setMinMaxScaleY(minScale, maxScale);
    }

    public void moveViewToX(float xValue) {
        MoveViewJob job = MoveViewJob.getInstance(this.mViewPortHandler, xValue, 0.0f, this.getTransformer(YAxis.AxisDependency.LEFT), (View)this);
        this.addViewportJob(job);
    }

    public void moveViewTo(float xValue, float yValue, YAxis.AxisDependency axis) {
        float yInView = this.getDeltaY(axis) / this.mViewPortHandler.getScaleY();
        MoveViewJob job = MoveViewJob.getInstance(this.mViewPortHandler, xValue, yValue + yInView / 2.0f, this.getTransformer(axis), (View)this);
        this.addViewportJob(job);
    }

    @TargetApi(value=11)
    public void moveViewToAnimated(float xValue, float yValue, YAxis.AxisDependency axis, long duration) {
        if (Build.VERSION.SDK_INT >= 11) {
            MPPointD bounds = this.getValuesByTouchPoint(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop(), axis);
            float yInView = this.getDeltaY(axis) / this.mViewPortHandler.getScaleY();
            AnimatedMoveViewJob job = AnimatedMoveViewJob.getInstance(this.mViewPortHandler, xValue, yValue + yInView / 2.0f, this.getTransformer(axis), (View)this, (float)bounds.x, (float)bounds.y, duration);
            this.addViewportJob(job);
            MPPointD.recycleInstance(bounds);
        } else {
            Log.e((String)"MPAndroidChart", (String)"Unable to execute moveViewToAnimated(...) on API level < 11");
        }
    }

    public void centerViewToY(float yValue, YAxis.AxisDependency axis) {
        float valsInView = this.getDeltaY(axis) / this.mViewPortHandler.getScaleY();
        MoveViewJob job = MoveViewJob.getInstance(this.mViewPortHandler, 0.0f, yValue + valsInView / 2.0f, this.getTransformer(axis), (View)this);
        this.addViewportJob(job);
    }

    public void centerViewTo(float xValue, float yValue, YAxis.AxisDependency axis) {
        float yInView = this.getDeltaY(axis) / this.mViewPortHandler.getScaleY();
        float xInView = this.getXAxis().mAxisRange / this.mViewPortHandler.getScaleX();
        MoveViewJob job = MoveViewJob.getInstance(this.mViewPortHandler, xValue - xInView / 2.0f, yValue + yInView / 2.0f, this.getTransformer(axis), (View)this);
        this.addViewportJob(job);
    }

    @TargetApi(value=11)
    public void centerViewToAnimated(float xValue, float yValue, YAxis.AxisDependency axis, long duration) {
        if (Build.VERSION.SDK_INT >= 11) {
            MPPointD bounds = this.getValuesByTouchPoint(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop(), axis);
            float yInView = this.getDeltaY(axis) / this.mViewPortHandler.getScaleY();
            float xInView = this.getXAxis().mAxisRange / this.mViewPortHandler.getScaleX();
            AnimatedMoveViewJob job = AnimatedMoveViewJob.getInstance(this.mViewPortHandler, xValue - xInView / 2.0f, yValue + yInView / 2.0f, this.getTransformer(axis), (View)this, (float)bounds.x, (float)bounds.y, duration);
            this.addViewportJob(job);
            MPPointD.recycleInstance(bounds);
        } else {
            Log.e((String)"MPAndroidChart", (String)"Unable to execute centerViewToAnimated(...) on API level < 11");
        }
    }

    public void setViewPortOffsets(final float left, final float top, final float right, final float bottom) {
        this.mCustomViewPortEnabled = true;
        this.post(new Runnable(){

            @Override
            public void run() {
                BarLineChartBase.this.mViewPortHandler.restrainViewPort(left, top, right, bottom);
                BarLineChartBase.this.prepareOffsetMatrix();
                BarLineChartBase.this.prepareValuePxMatrix();
            }
        });
    }

    public void resetViewPortOffsets() {
        this.mCustomViewPortEnabled = false;
        this.calculateOffsets();
    }

    public float getDeltaY(YAxis.AxisDependency axis) {
        if (axis == YAxis.AxisDependency.LEFT) {
            return this.mAxisLeft.mAxisRange;
        }
        return this.mAxisRight.mAxisRange;
    }

    public void setOnDrawListener(OnDrawListener drawListener) {
        this.mDrawListener = drawListener;
    }

    public OnDrawListener getDrawListener() {
        return this.mDrawListener;
    }

    public MPPointF getPosition(Entry e, YAxis.AxisDependency axis) {
        if (e == null) {
            return null;
        }
        float[] vals = this.mGetPositionBuffer;
        vals[0] = e.getX();
        vals[1] = e.getY();
        this.getTransformer(axis).pointValuesToPixel(vals);
        return MPPointF.getInstance(vals[0], vals[1]);
    }

    public void setMaxVisibleValueCount(int count) {
        this.mMaxVisibleCount = count;
    }

    @Override
    public int getMaxVisibleCount() {
        return this.mMaxVisibleCount;
    }

    public void setHighlightPerDragEnabled(boolean enabled) {
        this.mHighlightPerDragEnabled = enabled;
    }

    public boolean isHighlightPerDragEnabled() {
        return this.mHighlightPerDragEnabled;
    }

    public void setGridBackgroundColor(int color) {
        this.mGridBackgroundPaint.setColor(color);
    }

    public void setDragEnabled(boolean enabled) {
        this.mDragEnabled = enabled;
    }

    public boolean isDragEnabled() {
        return this.mDragEnabled;
    }

    public void setScaleEnabled(boolean enabled) {
        this.mScaleXEnabled = enabled;
        this.mScaleYEnabled = enabled;
    }

    public void setScaleXEnabled(boolean enabled) {
        this.mScaleXEnabled = enabled;
    }

    public void setScaleYEnabled(boolean enabled) {
        this.mScaleYEnabled = enabled;
    }

    public boolean isScaleXEnabled() {
        return this.mScaleXEnabled;
    }

    public boolean isScaleYEnabled() {
        return this.mScaleYEnabled;
    }

    public void setDoubleTapToZoomEnabled(boolean enabled) {
        this.mDoubleTapToZoomEnabled = enabled;
    }

    public boolean isDoubleTapToZoomEnabled() {
        return this.mDoubleTapToZoomEnabled;
    }

    public void setDrawGridBackground(boolean enabled) {
        this.mDrawGridBackground = enabled;
    }

    public void setDrawBorders(boolean enabled) {
        this.mDrawBorders = enabled;
    }

    public void setBorderWidth(float width) {
        this.mBorderPaint.setStrokeWidth(Utils.convertDpToPixel(width));
    }

    public void setBorderColor(int color) {
        this.mBorderPaint.setColor(color);
    }

    public float getMinOffset() {
        return this.mMinOffset;
    }

    public void setMinOffset(float minOffset) {
        this.mMinOffset = minOffset;
    }

    public boolean isKeepPositionOnRotation() {
        return this.mKeepPositionOnRotation;
    }

    public void setKeepPositionOnRotation(boolean keepPositionOnRotation) {
        this.mKeepPositionOnRotation = keepPositionOnRotation;
    }

    public MPPointD getValuesByTouchPoint(float x, float y, YAxis.AxisDependency axis) {
        MPPointD result = MPPointD.getInstance(0.0, 0.0);
        this.getValuesByTouchPoint(x, y, axis, result);
        return result;
    }

    public void getValuesByTouchPoint(float x, float y, YAxis.AxisDependency axis, MPPointD outputPoint) {
        this.getTransformer(axis).getValuesByTouchPoint(x, y, outputPoint);
    }

    public MPPointD getPixelsForValues(float x, float y, YAxis.AxisDependency axis) {
        return this.getTransformer(axis).getPixelsForValues(x, y);
    }

    public float getYValueByTouchPoint(float x, float y, YAxis.AxisDependency axis) {
        this.getValuesByTouchPoint(x, y, axis, this.pointForGetYValueByTouchPoint);
        float result = (float)this.pointForGetYValueByTouchPoint.y;
        return result;
    }

    public Entry getEntryByTouchPoint(float x, float y) {
        Highlight h = this.getHighlightByTouchPoint(x, y);
        if (h != null) {
            return ((BarLineScatterCandleBubbleData)this.mData).getEntryForHighlight(h);
        }
        return null;
    }

    public IBarLineScatterCandleBubbleDataSet getDataSetByTouchPoint(float x, float y) {
        Highlight h = this.getHighlightByTouchPoint(x, y);
        if (h != null) {
            return (IBarLineScatterCandleBubbleDataSet)((BarLineScatterCandleBubbleData)this.mData).getDataSetByIndex(h.getDataSetIndex());
        }
        return null;
    }

    @Override
    public float getLowestVisibleX() {
        this.getTransformer(YAxis.AxisDependency.LEFT).getValuesByTouchPoint(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom(), this.posForGetLowestVisibleX);
        float result = (float)Math.max((double)this.mXAxis.mAxisMinimum, this.posForGetLowestVisibleX.x);
        return result;
    }

    @Override
    public float getHighestVisibleX() {
        this.getTransformer(YAxis.AxisDependency.LEFT).getValuesByTouchPoint(this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentBottom(), this.posForGetHighestVisibleX);
        float result = (float)Math.min((double)this.mXAxis.mAxisMaximum, this.posForGetHighestVisibleX.x);
        return result;
    }

    public float getVisibleXRange() {
        return Math.abs(this.getHighestVisibleX() - this.getLowestVisibleX());
    }

    public float getScaleX() {
        if (this.mViewPortHandler == null) {
            return 1.0f;
        }
        return this.mViewPortHandler.getScaleX();
    }

    public float getScaleY() {
        if (this.mViewPortHandler == null) {
            return 1.0f;
        }
        return this.mViewPortHandler.getScaleY();
    }

    public boolean isFullyZoomedOut() {
        return this.mViewPortHandler.isFullyZoomedOut();
    }

    public YAxis getAxisLeft() {
        return this.mAxisLeft;
    }

    public YAxis getAxisRight() {
        return this.mAxisRight;
    }

    public YAxis getAxis(YAxis.AxisDependency axis) {
        if (axis == YAxis.AxisDependency.LEFT) {
            return this.mAxisLeft;
        }
        return this.mAxisRight;
    }

    @Override
    public boolean isInverted(YAxis.AxisDependency axis) {
        return this.getAxis(axis).isInverted();
    }

    public void setPinchZoom(boolean enabled) {
        this.mPinchZoomEnabled = enabled;
    }

    public boolean isPinchZoomEnabled() {
        return this.mPinchZoomEnabled;
    }

    public void setDragOffsetX(float offset) {
        this.mViewPortHandler.setDragOffsetX(offset);
    }

    public void setDragOffsetY(float offset) {
        this.mViewPortHandler.setDragOffsetY(offset);
    }

    public boolean hasNoDragOffset() {
        return this.mViewPortHandler.hasNoDragOffset();
    }

    public XAxisRenderer getRendererXAxis() {
        return this.mXAxisRenderer;
    }

    public void setXAxisRenderer(XAxisRenderer xAxisRenderer) {
        this.mXAxisRenderer = xAxisRenderer;
    }

    public YAxisRenderer getRendererLeftYAxis() {
        return this.mAxisRendererLeft;
    }

    public void setRendererLeftYAxis(YAxisRenderer rendererLeftYAxis) {
        this.mAxisRendererLeft = rendererLeftYAxis;
    }

    public YAxisRenderer getRendererRightYAxis() {
        return this.mAxisRendererRight;
    }

    public void setRendererRightYAxis(YAxisRenderer rendererRightYAxis) {
        this.mAxisRendererRight = rendererRightYAxis;
    }

    @Override
    public float getYChartMax() {
        return Math.max(this.mAxisLeft.mAxisMaximum, this.mAxisRight.mAxisMaximum);
    }

    @Override
    public float getYChartMin() {
        return Math.min(this.mAxisLeft.mAxisMinimum, this.mAxisRight.mAxisMinimum);
    }

    public boolean isAnyAxisInverted() {
        if (this.mAxisLeft.isInverted()) {
            return true;
        }
        return this.mAxisRight.isInverted();
    }

    public void setAutoScaleMinMaxEnabled(boolean enabled) {
        this.mAutoScaleMinMaxEnabled = enabled;
    }

    public boolean isAutoScaleMinMaxEnabled() {
        return this.mAutoScaleMinMaxEnabled;
    }

    @Override
    public void setPaint(Paint p, int which) {
        super.setPaint(p, which);
        switch (which) {
            case 4: {
                this.mGridBackgroundPaint = p;
            }
        }
    }

    @Override
    public Paint getPaint(int which) {
        Paint p = super.getPaint(which);
        if (p != null) {
            return p;
        }
        switch (which) {
            case 4: {
                return this.mGridBackgroundPaint;
            }
        }
        return null;
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        float[] pts = this.mOnSizeChangedBuffer;
        pts[1] = 0.0f;
        pts[0] = 0.0f;
        if (this.mKeepPositionOnRotation) {
            pts[0] = this.mViewPortHandler.contentLeft();
            pts[1] = this.mViewPortHandler.contentTop();
            this.getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(pts);
        }
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mKeepPositionOnRotation) {
            this.getTransformer(YAxis.AxisDependency.LEFT).pointValuesToPixel(pts);
            this.mViewPortHandler.centerViewPort(pts, (View)this);
        } else {
            this.mViewPortHandler.refresh(this.mViewPortHandler.getMatrixTouch(), (View)this, true);
        }
    }
}

