/*
 * Decompiled with CFR 0.152.
 */
package com.github.timm.cucumber.generate.name;

import com.github.timm.cucumber.generate.name.ClassNamingScheme;
import com.google.common.base.CaseFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class FeatureFileClassNamingScheme
implements ClassNamingScheme {
    private final Pattern startsWithDigit = Pattern.compile("^\\d.*");

    public String generate(String featureFileName) {
        String fileNameWithNoExtension = FilenameUtils.removeExtension((String)featureFileName);
        fileNameWithNoExtension = fileNameWithNoExtension.replaceAll("_", "-");
        fileNameWithNoExtension = fileNameWithNoExtension.replaceAll(" ", "");
        String className = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, fileNameWithNoExtension = fileNameWithNoExtension.replaceAll("\\.", "-"));
        Matcher startsWithDigitCheck = this.startsWithDigit.matcher(className);
        if (startsWithDigitCheck.matches()) {
            className = "_" + className;
        }
        return className;
    }
}

