/*
 * Decompiled with CFR 0.152.
 */
package com.github.timm.cucumber.generate;

import com.github.timm.cucumber.generate.CucumberITGenerator;
import com.github.timm.cucumber.generate.CucumberITGeneratorByFeature;
import com.github.timm.cucumber.generate.CucumberITGeneratorByScenario;
import com.github.timm.cucumber.generate.FileGeneratorConfig;
import com.github.timm.cucumber.generate.OverriddenCucumberOptionsParameters;
import com.github.timm.cucumber.generate.ParallelScheme;
import com.github.timm.cucumber.generate.name.ClassNamingScheme;
import org.apache.maven.plugin.MojoExecutionException;

public class CucumberITGeneratorFactory {
    private final OverriddenCucumberOptionsParameters overriddenParameters;
    private final ClassNamingScheme classNamingScheme;
    private final FileGeneratorConfig config;

    public CucumberITGeneratorFactory(FileGeneratorConfig config, OverriddenCucumberOptionsParameters overriddenParameters, ClassNamingScheme classNamingScheme) {
        this.overriddenParameters = overriddenParameters;
        this.classNamingScheme = classNamingScheme;
        this.config = config;
    }

    public CucumberITGenerator create(ParallelScheme parallelScheme) throws MojoExecutionException {
        if (ParallelScheme.FEATURE.equals((Object)parallelScheme)) {
            return this.createFileGeneratorByFeature();
        }
        return this.createFileGeneratorByScenario();
    }

    private CucumberITGenerator createFileGeneratorByFeature() throws MojoExecutionException {
        return new CucumberITGeneratorByFeature(this.config, this.overriddenParameters, this.classNamingScheme);
    }

    private CucumberITGenerator createFileGeneratorByScenario() throws MojoExecutionException {
        return new CucumberITGeneratorByScenario(this.config, this.overriddenParameters, this.classNamingScheme);
    }
}

